/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.QmmDataType;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataObject;
import java.util.UUID;

@JsonPropertyOrder(value={"type", "trackingInfo"})
public class Metadata
extends QmmData {
    private String source;
    private UUID messageId;
    private String timestamp;
    private String place = "";
    private long cameraId;
    private long externalCameraId;
    private float vmsAssumedLikelihood;
    private MetadataObject metadataObject = null;
    private int resolutionWidth;
    private int resolutionHeight;
    private boolean trackingInfo;

    public void setObject(MetadataObject metadataObject) {
        this.metadataObject = metadataObject;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public void setMessageId(UUID messageId) {
        this.messageId = messageId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public long getCameraId() {
        return this.cameraId;
    }

    public void setCameraId(long cameraId) {
        this.cameraId = cameraId;
    }

    public long getExternalCameraId() {
        return this.externalCameraId;
    }

    public void setExternalCameraId(long externalCameraId) {
        this.externalCameraId = externalCameraId;
    }

    public float getVmsAssumedLikelihood() {
        return this.vmsAssumedLikelihood;
    }

    public void setVmsAssumedLikelihood(float vmsAssumedLikelihood) {
        this.vmsAssumedLikelihood = vmsAssumedLikelihood;
    }

    @Override
    @JsonProperty(value="type")
    public QmmDataType getQmmDataType() {
        return QmmDataType.metadata;
    }

    @JsonProperty(value="Object")
    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public void setMetadataObject(MetadataObject metadataObject) {
        this.metadataObject = metadataObject;
    }

    public String toString() {
        return "[ Object id = " + this.metadataObject.getObjectId() + " Timestamp = " + this.getTimestamp() + " Type = " + (Object)((Object)this.getQmmDataType()) + "]";
    }

    public void setResolutionWidth(int width) {
        this.resolutionWidth = width;
    }

    public void setResolutionHeight(int height) {
        this.resolutionHeight = height;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public boolean isTrackingInfo() {
        return this.trackingInfo;
    }

    public void setTrackingInfo(boolean trackinInfo) {
        this.trackingInfo = trackinInfo;
    }

    protected void insertContentClass() {
        MetadataObject metadataObj = this.getMetadataObject();
        if (metadataObj.getAppearance().getColor() == null && metadataObj.getAppearance().getHumanBody() == null && metadataObj.getAppearance().getHumanFace() == null && metadataObj.getAppearance().getImage() == null && metadataObj.getAppearance().getLicensePlateInfo() == null && metadataObj.getAppearance().getVehicleInfo() == null && metadataObj.getAppearance().getClassDescriptor() == null && metadataObj.getBehaviour() == null) {
            this.trackingInfo = true;
        }
    }

    boolean containsObjectClassification() {
        return this.getMetadataObject().getAppearance().getClassDescriptor() != null;
    }
}

