/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.io;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrvCnf;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;

public class DigitalInputSrv
extends Service {
    private DigitalInputSrvCnf srvCnf = null;
    private int lastStatus = -1;
    private long lastStatusChange = -1L;
    private int inputNumber = -1;
    private long deadTime = -1L;
    private IOHandler ioHandler = null;

    public int init(Core core, Device device, IOHandler ioHandler, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "] for " + (Object)((Object)this));
            return errorCode;
        }
        this.ioHandler = ioHandler;
        this.srvCnf = new DigitalInputSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [SrvCnf] failed with error [" + errorCode + "] for " + (Object)((Object)this));
            return errorCode;
        }
        try {
            this.inputNumber = this.srvCnf.getInputNumber();
            this.deadTime = this.srvCnf.getDeadTime();
            if (this.deadTime < 0L) {
                this.logger.error("DeadTime [" + this.deadTime + "] is not valid for " + (Object)((Object)this));
                return -21602;
            }
        }
        catch (ConfigurationException cex) {
            this.logger.error("Configuration is invalid for " + (Object)((Object)this));
            return -21602;
        }
        return 0;
    }

    private int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        this.logger.info("Event of source [" + sourceID + "] from " + (Object)((Object)this));
        return super.getCore().sendApplicationEvent(sourceID);
    }

    @Override
    public int checkService() {
        return 0;
    }

    public void checkInput(int actualValue) {
        if (this.lastStatusChange < 0L) {
            try {
                this.lastStatusChange = System.currentTimeMillis();
                this.lastStatus = actualValue;
                super.publishServiceStatus(this.lastStatus);
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return;
        }
        try {
            if (this.lastStatus != actualValue) {
                this.logger.info("Status changed from [" + this.lastStatus + "] to [" + actualValue + "] for digital input [" + Basic.longToFormattedString((Long)super.getEntity().getEntityID()) + "] of " + this.ioHandler);
                super.publishServiceStatus(actualValue);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        if (this.lastStatusChange + this.deadTime < System.currentTimeMillis()) {
            if ((this.getServiceType() == 9801L || this.getServiceType() == 9804L) && this.lastStatus == 0 && actualValue != 0) {
                this.logger.info("Input [" + this.getInputNumber() + "] was switching to ON for " + (Object)((Object)this));
                this.lastStatusChange = System.currentTimeMillis();
                this.sendEvent();
            }
            if ((this.getServiceType() == 9802L || this.getServiceType() == 9805L) && this.lastStatus != 0 && actualValue == 0) {
                this.logger.info("Input [" + this.getInputNumber() + "] was switching to OFF for " + (Object)((Object)this));
                this.lastStatusChange = System.currentTimeMillis();
                this.sendEvent();
            }
        }
        this.lastStatus = actualValue;
    }

    public void checkInput(int[] inputs) {
        this.checkInput(inputs[this.getInputNumber() - 1]);
    }

    public DigitalInputSrvCnf getDigitalInputSrvCnf() {
        return this.srvCnf;
    }

    public int getInputNumber() {
        return this.inputNumber;
    }

    public int getInputStatus() {
        return this.lastStatus;
    }
}

