/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.genericevent;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericEventTriggerHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.GenericEventTriggerHandler";
    protected Logger logger = null;
    protected Device device = null;
    protected Core core = null;
    protected List<GenericEventTriggerCnf> genericEventTriggerCnfs = null;
    private Thread thread = null;
    private boolean isShutdown = false;
    private final MotionRecording motionRecording;
    private final Map<String, Long> lastTriggerMap = new HashMap<String, Long>();

    public GenericEventTriggerHandler(MotionRecording motionRecording) {
        this.motionRecording = motionRecording;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        this.device = device;
        this.core = device.getCore();
        this.genericEventTriggerCnfs = genericEventTriggerCnfs;
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    public int shutdown() {
        this.isShutdown = true;
        this.thread = null;
        this.lastTriggerMap.clear();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown;
    }

    public final List<GenericEventTriggerCnf> getGenericEventTriggerCnfs() {
        return this.genericEventTriggerCnfs;
    }

    public final boolean isTriggerEnabled(String triggerName) throws ConfigurationException {
        if (this.genericEventTriggerCnfs != null) {
            for (GenericEventTriggerCnf triggerCnf : this.genericEventTriggerCnfs) {
                if (!triggerCnf.getGenericEventTriggerType().equals(triggerName) || !triggerCnf.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    protected final int forwardTrigger(GenericEventTriggerCnf genericEventTriggerCnf) throws ConfigurationException {
        long lastTime;
        long time;
        String genericEventTriggerType;
        block5: {
            if (genericEventTriggerCnf == null) {
                return -20002;
            }
            genericEventTriggerType = genericEventTriggerCnf.getGenericEventTriggerType();
            time = System.currentTimeMillis();
            lastTime = this.lastTriggerMap.get(genericEventTriggerType) == null ? 0L : this.lastTriggerMap.get(genericEventTriggerType);
            try {
                if (genericEventTriggerCnf.isRecordOnMotion()) {
                    this.motionRecording.checkAndStartMotionRecording(true);
                }
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug("Ignoring trigger cause something went wrong while checking it: " + configurationException.getMessage());
            }
        }
        if (time - lastTime > genericEventTriggerCnf.getDeadTime()) {
            this.lastTriggerMap.put(genericEventTriggerType, time);
            this.core.sendApplicationEvent(genericEventTriggerCnf.getEntityId());
            return 0;
        }
        return -20054;
    }
}

