/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.factory;

public class Range
implements Comparable<Range> {
    private final long lower;
    private final long higher;

    public Range(long lower, long higher) {
        if (lower > higher) {
            throw new IllegalArgumentException("Region must start before its end. Started at " + lower + " ended at" + higher + ".");
        }
        this.lower = lower;
        this.higher = higher;
    }

    public Range(long singleValue) {
        this(singleValue, singleValue);
    }

    public long getLower() {
        return this.lower;
    }

    public long getHigher() {
        return this.higher;
    }

    public boolean contains(long value) {
        return value >= this.lower && value <= this.higher;
    }

    @Override
    public int compareTo(Range range) {
        if (this.lower > range.getHigher()) {
            return 1;
        }
        if (this.higher < range.getLower()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        return this.compareTo((Range)obj) == 0;
    }

    public int hashCode() {
        return 0;
    }
}

