/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.cameracontrol;

import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControlIntf;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CameraControl
extends Basic
implements CameraControlIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.CameraControl";
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    protected VideoSrv videoSrv = null;
    protected String host = null;
    protected int port = -1;
    protected String usr = null;
    protected String pwd = null;
    protected Vector<PresetCnf> presetList = null;
    protected NetworkParameter networkParameter = null;
    protected int previousPanSpeed = 0;
    protected int previousTiltSpeed = 0;
    protected int previousZoomSpeed = 0;
    protected PtzInfo ptzInfo;

    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        this.videoSrv = videoSrv;
        if (this.videoSrv == null) {
            return -21601;
        }
        this.host = host;
        if (this.host == null) {
            return -21601;
        }
        this.port = port;
        if (this.port <= 0 || port >= 65535) {
            return -21601;
        }
        this.presetList = presetList;
        if (this.presetList == null) {
            return -21601;
        }
        this.usr = usr;
        this.pwd = pwd;
        try {
            this.networkParameter = this.videoSrv.getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException cex) {
            this.logger.error("Cannot determine NetworkParameter of " + this.videoSrv, (Throwable)cex);
            return -21601;
        }
        return 0;
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return 0;
    }

    public boolean isShutdown() {
        return super.isShutdown(CLASS_NAME);
    }

    @Override
    public String getPresetName(long presetID) throws ConfigurationException {
        String presetName = null;
        if (this.presetList != null) {
            for (PresetCnf presetCnf : this.presetList) {
                if (presetCnf.getPresetID() != presetID) continue;
                presetName = presetCnf.getPresetName();
                break;
            }
        }
        return presetName;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.CameraControl@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", TCP=[" + this.host + ":" + this.port + "], " + this.presetList + "]]";
    }

    protected boolean removePresetFromListIfExistent(String presetName) throws ConfigurationException {
        if (presetName == null) {
            return false;
        }
        if (this.presetList != null) {
            Iterator<PresetCnf> iterator = this.presetList.iterator();
            while (iterator.hasNext()) {
                PresetCnf presetCnf = iterator.next();
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                iterator.remove();
                return true;
            }
        }
        this.printPresetNotAvailabeMessage(presetName);
        return false;
    }

    protected boolean isPresetExisting(String presetName) throws ConfigurationException {
        if (presetName == null) {
            return false;
        }
        if (this.presetList != null) {
            for (PresetCnf presetCnf : this.presetList) {
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                return true;
            }
        }
        this.printPresetNotAvailabeMessage(presetName);
        return false;
    }

    private void printPresetNotAvailabeMessage(String presetName) {
        this.logger.error("Preset [" + presetName + "] not available for " + this);
        this.logger.error("PresetList=" + this.presetList);
    }

    protected String getEncodedPresetNameEmptyNotAllowed(String presetName) throws UnsupportedEncodingException {
        if (presetName == null || presetName.trim().equals("")) {
            throw new UnsupportedEncodingException("String is null or empty");
        }
        return URLEncoder.encode(presetName.trim(), "UTF-8");
    }

    protected String getEncodedPresetName(String presetName) throws UnsupportedEncodingException {
        if (presetName == null) {
            throw new UnsupportedEncodingException("String is null");
        }
        return URLEncoder.encode(presetName.trim(), "UTF-8");
    }

    public PtzInfo getPtzInfo() {
        return this.ptzInfo;
    }

    @Override
    public int setAbsolutePt(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt) {
        throw new UnsupportedOperationException("Set absolute pan/tilt not implemented yet");
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        throw new UnsupportedOperationException("Set absolute zoom not implemented yet");
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        throw new UnsupportedOperationException("Import presets not implemented yet");
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        throw new UnsupportedOperationException("Adding camera presets not implemented yet");
    }
}

