/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.device.shared.AudioConfiguration;
import de.seetec.v5.re.cm.device.shared.CameraControlLock;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.InactivityAction;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.MotionRecordingHandler;
import de.seetec.v5.re.cm.device.shared.PtzControlStatus;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.StatusPtzUserAgent;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetConfigurationExtractor;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.shared.Action;
import de.seetec.v5.re.cm.shared.ActionHandlerIntf;
import de.seetec.v5.re.cm.shared.AlarmProcessor;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.communication.AdditionalRecordingHandler;
import de.seetec.v5.re.cm.shared.communication.CameraControlPriority;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.LiveReader;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.re.cm.shared.communication.RecordingHandler;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.re.cm.shared.recording.RecordingInfo;
import de.seetec.v5.re.cm.shared.recording.RecordingInfoList;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusAbsolutePTZ;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusControlLock;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusControlPriority;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusPTZUser;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusService;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.StreamOnDemandMode;
import de.seetec.v5.re.shared.TimerangeCnf;
import de.seetec.v5.re.shared.VideoSourceCnf;
import de.seetec.v5.re.shared.VideoStreamingAction;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqGetWriteProtections;
import de.seetec.v5.re.shared.srpc.ReqRemoveRecording;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.RspGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.RspGetWriteProtections;
import de.seetec.v5.re.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.NetworkDispatcherHeader;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.proxy.general.GeneralProxy;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.tree.TreeNode;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.WorkCenterCalendarRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class VideoSrv
extends Service
implements SRPCDispatcherListener,
MDBAccessorIntf,
ActionHandlerIntf,
MotionRecording,
PtzControlStatus {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.VideoSrv";
    protected HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection = null;
    protected GenericEventTriggerHandler genericEventTriggerHandler = null;
    protected volatile boolean streamDisabled = false;
    private final Object clientRequestHandlerSemaphore = new Object();
    private final Object recordingHandlerSemaphore = new Object();
    private final Object additionalRecordingHandlerSemaphore = new Object();
    private final Object controlLockSemaphore = new Object();
    private final Object SYNC_OBJ = new Object();
    private final Vector<PresetCnf> presetList = new Vector();
    private final Vector<LiveReader> liveReaders = new Vector();
    private final Hashtable<VideoProfileHandler, LiveReader[]> htLiveReaderFilter = new Hashtable();
    private final LinkedList<TrackingDataStreamHandler> listOfTrackingDataStreamHandler = new LinkedList();
    private List<VideoServiceClientRequestHandler> registeredVideoServiceClientRequestHandlers = null;
    private RecordingHandler recordingHandler = null;
    private AdditionalRecordingHandler additionalRecordingHandler = null;
    private MotionRecordingHandler motionRecordingHandler = null;
    private Action[] actions = null;
    private VideoSourceCnf videoSourceCnf = null;
    private TimerangeCnf standardRecordingTimerange = null;
    private String lastVideoMode = "Standard";
    private boolean sendStatusBlocked = false;
    private ReqStatusAbsolutePTZ lastReqStatusAbsolutePTZ = null;
    private final CameraControlLock cameraControlLock = new CameraControlLock();
    private InactivityActionWatchdog inactivityActionWatchdog = null;
    private InactivityAction inactivityAction = null;
    private long tsLastCameraControl = -1L;
    private long tsNotifyForNetworkFailure = -1L;
    private Integer lastPublishedStatusService = null;
    private VideoStreamingActionHandler videoStreamingActionHandler = null;
    private AudioConfiguration audioConfiguration = null;
    private Thread notification = null;
    private DatabaseProxy databaseProxy = null;
    private DatabaseProxy databaseProxyFailover = null;
    private TimeRangeInfoContainer recordingInfoContainer = null;
    private CameraControlPriority cameraControlPriority = null;
    private PTZPriorityTimer ptzPriorityTimer = null;
    private PTZLockTimer ptzLockTimer;
    private boolean isEdgeStorage;
    private StatusPtzUserAgent statusPtzUserAgent = null;
    private boolean additionalRecording = false;

    public boolean isStreamDisabled() {
        return this.streamDisabled;
    }

    @Override
    public int init(Core core, Device device, Entity entity) {
        try {
            int errorCode = super.init(core, device, entity);
            if (errorCode != 0) {
                return errorCode;
            }
            return this.init();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -21600;
        }
    }

    private int init() throws Exception {
        Entity[] enabledEntities;
        VideoStreamingAction videoStreamingStopAction;
        VideoStreamingAction videoStreamingStartAction;
        VideoStreamingActionHandler localVideoStreamingActionHandler;
        this.statusPtzUserAgent = new StatusPtzUserAgent(this);
        this.registeredVideoServiceClientRequestHandlers = new Vector<VideoServiceClientRequestHandler>();
        if (this.device != null) {
            DeviceCnf deviceCnf = this.device.getDeviceCnf();
            if (this.getEntityID().longValue() == deviceCnf.getAudioSourceID() && deviceCnf.getAudioCodec() != null) {
                this.audioConfiguration = new AudioConfiguration(deviceCnf.getAudioCodec(), deviceCnf.getAudioDefaultBitrate());
            }
        }
        this.videoSourceCnf = new VideoSourceCnf();
        int errorCode = this.videoSourceCnf.init(super.getEntity());
        if (errorCode != 0) {
            this.logger.error("Creating [VideoSourceCnf] failed with error [" + errorCode + "] ");
            return errorCode;
        }
        long[] nTypeList = new long[]{9901L, 9902L, 9903L, 9904L, 9960L, 9907L, 9906L};
        Long entityID = this.getEntity().getEntityID();
        Entity[] entities = this.device.getEnabledEntities(new long[]{entityID}, nTypeList);
        this.actions = new Action[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            this.actions[i] = new Action();
            errorCode = this.actions[i].init(entities[i]);
            if (errorCode == 0) continue;
            this.logger.error("Cannot initialize action [" + entities[i] + "] because of [" + errorCode + "]");
            return -21671;
        }
        boolean recordingEnabled = this.videoSourceCnf.isRecordingEnabled("Standard");
        long timerangeEntityID = this.videoSourceCnf.getTimeRangeID("Standard");
        WorkCenterCalendarRepository workCenterCalendarRepository = this.getCore().getWorkCenterCalendarRepository();
        this.standardRecordingTimerange = new TimerangeCnf(workCenterCalendarRepository);
        if (!recordingEnabled) {
            this.standardRecordingTimerange.init(false);
        } else if (timerangeEntityID < 0L) {
            this.standardRecordingTimerange.init(true);
        } else {
            try {
                Entity timerangeEntity = super.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(timerangeEntityID), Boolean.TRUE, 30000L);
                errorCode = this.standardRecordingTimerange.init(timerangeEntity.getConfiguration());
                if (errorCode != 0) {
                    this.logger.error("Creating [TimerangeCnf] failed with error [" + errorCode + "] ");
                    return errorCode;
                }
                this.device.registerSubEntity(timerangeEntityID);
            }
            catch (SeeTecException srpcex) {
                this.logger.warn((Object)srpcex, (Throwable)srpcex);
                if (srpcex.getErrorCode() != -20110) {
                    throw new RuntimeException(srpcex.getMessage());
                }
                this.logger.info("Timerange with id [" + Basic.longToFormattedString((long)timerangeEntityID) + "] is no longer available. Mode [always] will be used!");
                this.standardRecordingTimerange.init(true);
            }
        }
        Entity recordOnMotionTimerangeEntity = null;
        long recordOnMotionTimeRangeId = this.videoSourceCnf.getRecordOnMotionTimeRangeId();
        if (recordOnMotionTimeRangeId > 0L) {
            try {
                recordOnMotionTimerangeEntity = super.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(recordOnMotionTimeRangeId), Boolean.TRUE, 30000L);
                this.device.registerSubEntity(recordOnMotionTimeRangeId);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Timerange with Id [" + Basic.longToFormattedString((long)timerangeEntityID) + "] not available.[" + seeTecException.getMessage() + "]");
            }
        }
        TimerangeCnf recordOnMotionTimerange = new TimerangeCnf(workCenterCalendarRepository);
        if (recordOnMotionTimerangeEntity == null || recordOnMotionTimerange.init(recordOnMotionTimerangeEntity.getConfiguration()) != 0) {
            recordOnMotionTimerange.init(true);
        }
        this.motionRecordingHandler = new MotionRecordingHandler(recordOnMotionTimerange, this.videoSourceCnf, this, (SystemTimeProvider)new DefaultSystemTimeProvider());
        List inactivityActionParameter = this.videoSourceCnf.getInactivityActionParameter();
        this.inactivityAction = new InactivityAction();
        if (inactivityActionParameter.size() > 0) {
            this.inactivityAction.setEnabled(true);
            this.inactivityAction.setActionID((Long)inactivityActionParameter.get(0));
            this.inactivityAction.setServiceID((Long)inactivityActionParameter.get(1));
            this.inactivityAction.setTimeout((Long)inactivityActionParameter.get(2));
            InactivityActionWatchdog localInactivityActionWatchdog = new InactivityActionWatchdog();
            errorCode = localInactivityActionWatchdog.init(this);
            if (errorCode != 0) {
                localInactivityActionWatchdog.shutdown();
                this.logger.error("Creating [InactivityActionWatchdog] failed with error [" + errorCode + "] ");
                return errorCode;
            }
            this.inactivityActionWatchdog = localInactivityActionWatchdog;
        }
        if ((errorCode = (localVideoStreamingActionHandler = new VideoStreamingActionHandler()).init(this, 500L, videoStreamingStartAction = this.getVideoSourceCnf().getVideoStreamingStartActionParameter(), videoStreamingStopAction = this.getVideoSourceCnf().getVideoStreamingStopActionParameter())) != 0) {
            localVideoStreamingActionHandler.shutdown();
            this.logger.error("Creating [VideoStreamingActionHandler] failed with error [" + errorCode + "] ");
            return errorCode;
        }
        this.videoStreamingActionHandler = localVideoStreamingActionHandler;
        try {
            long externalPTZBackReference = this.getVideoSourceCnf().getExternalPTZBackReference();
            long externalPtzId = this.getVideoSourceCnf().getExternalPtzId();
            if (externalPTZBackReference > 0L) {
                ArrayList vTypes = new ArrayList();
                Tree t = this.getCore().getEntMgrProxy().getEntitiesAsTree(Long.valueOf(externalPTZBackReference), vTypes, Boolean.valueOf(true), Integer.valueOf(TreeTypes.LOGICALTREE.getType()), 30000L);
                List treeNodeEntities = t.getRoot().getChildren();
                LinkedList<Entity> presetEntities = new LinkedList<Entity>();
                for (TreeNode treeNode : treeNodeEntities) {
                    Entity entity = (Entity)treeNode.getData();
                    if (entity.getEntityType() != 9931L) continue;
                    presetEntities.add(entity);
                }
                entities = presetEntities.toArray(new Entity[presetEntities.size()]);
            } else if (externalPtzId > 0L) {
                entities = new Entity[]{};
            } else {
                try {
                    entities = this.getVideoSourceCnf().canPreset() ? this.readPresets() : new Entity[]{};
                }
                catch (Exception exception) {
                    entities = this.readPresets();
                }
            }
            Entity[] presetConfigurationExtractor = new PresetConfigurationExtractor();
            Entity[] entityArray = entities;
            int n = entityArray.length;
            for (int presetEntities = 0; presetEntities < n; ++presetEntities) {
                Entity presetEntity = entityArray[presetEntities];
                byte[] configuration = presetConfigurationExtractor.extract(presetEntity);
                try {
                    this.presetList.addElement(PresetCnf.createPresetCnf((long)presetEntity.getEntityID(), configuration));
                    continue;
                }
                catch (Exception ex) {
                    this.logger.warn("Ignoring preset because of invalid configuration");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while checking PTZ References for " + this, (Throwable)ex);
            return -21602;
        }
        super.getCore().registerToSRPCDispatcher(this, this.getEntityID());
        errorCode = super.getCore().registerEntity(super.getEntity().getEntityID(), super.getEntity().getEntityType());
        if (errorCode != 0) {
            this.logger.error("Registering " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.getCore().actionHandler.put(super.getServiceID(), this);
        AlarmProcessor alarmProcessor = super.getCore().getAlarmProcessor();
        if (alarmProcessor != null) {
            alarmProcessor.announceMDB(this.getEntityID(), this.getCore().getMultimediaDatabaseLifeCycle().getMultimediaDatabaseDevice());
        }
        long[] path = new long[]{this.getEntityID()};
        long[] entityTypeList = new long[]{9906L};
        for (Entity entity : enabledEntities = this.getDevice().getEnabledEntities(path, entityTypeList)) {
            if (!entity.getEntityType().equals(9906L) || entity.getStatus() != -21712) continue;
            this.streamDisabled = true;
        }
        try {
            if (this.streamDisabled) {
                this.logger.info("Stream is disabled, so publishing status of " + this + " now!");
                this.getCore().setEntityStatus(this.getEntityID(), -21712);
            } else if (!this.videoSourceCnf.isRecordingEnabled("Standard") && !this.videoSourceCnf.isRecordingEnabled("Alarm")) {
                this.logger.info("No recording enabled, so publishing status of " + this + " now!");
                this.getCore().setEntityStatus(this.getEntityID(), 0);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    private Entity[] readPresets() {
        try {
            ArrayList<Long> typeList = new ArrayList<Long>();
            typeList.add(9931L);
            Tree logicalTreeFromSource = this.getCore().getEntMgrProxy().getEntitiesAsTree(this.getEntityID(), typeList, Boolean.TRUE, Integer.valueOf(TreeTypes.LOGICALTREE.getType()), TimeUnit.SECONDS.toMillis(30L));
            List nodes = logicalTreeFromSource.getRoot().getChildren();
            Entity[] presets = new Entity[nodes.size()];
            for (int i = 0; i < presets.length; ++i) {
                Entity entity;
                presets[i] = entity = (Entity)((TreeNode)nodes.get(i)).getData();
            }
            return presets;
        }
        catch (Exception exception) {
            this.logger.error("Exception while reading presets for " + this, (Throwable)exception);
            return new Entity[0];
        }
    }

    public abstract int init(Vector<PresetCnf> var1) throws UnknownHostException, ConfigurationException;

    public int initLive() throws UnknownHostException, ConfigurationException {
        return this.init(this.presetList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            VideoServiceClientRequestHandler[] videoServiceClientRequestHandlers = this.getVideoServiceClientRequestHandlers();
            if (videoServiceClientRequestHandlers.length > 0) {
                ExecutorService videoServiceClientRequestHandlerKiller = Executors.newFixedThreadPool(videoServiceClientRequestHandlers.length, (ThreadFactory)new NamedThreadFactory("VideoSrv VideoServiceClientRequestHandler ShutDownPool"));
                for (final VideoServiceClientRequestHandler videoServiceClientRequestHandler : videoServiceClientRequestHandlers) {
                    videoServiceClientRequestHandlerKiller.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.currentThread().setName("VideoSrv shutdown " + videoServiceClientRequestHandler.toString());
                                videoServiceClientRequestHandler.shutdown();
                            }
                            catch (Throwable t) {
                                VideoSrv.this.logger.warn(String.format("Exception while shutting down VideoServiceClientRequestHandler [%s]", videoServiceClientRequestHandler), t);
                            }
                        }
                    });
                }
                videoServiceClientRequestHandlerKiller.shutdown();
            }
        }
        catch (Throwable t) {
            this.logger.warn(String.format("Exception while shutting down VideoServiceClientRequestHandlers of %s: ", this), t);
        }
        finally {
            this.registeredVideoServiceClientRequestHandlers = null;
        }
        try {
            for (int i = 0; i < this.listOfTrackingDataStreamHandler.size(); ++i) {
                this.listOfTrackingDataStreamHandler.get(i).shutdown();
            }
            this.listOfTrackingDataStreamHandler.clear();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        if (this.statusPtzUserAgent != null) {
            this.statusPtzUserAgent.shutdown();
        }
        if (this.motionRecordingHandler != null) {
            this.motionRecordingHandler.shutdown();
        }
        if (this.recordingHandler != null) {
            errorCode = this.recordingHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.recordingHandler + " failed with error [" + errorCode + "] ");
            }
            this.recordingHandler = null;
        }
        if (this.additionalRecordingHandler != null) {
            errorCode = this.additionalRecordingHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.additionalRecordingHandler + " failed with error [" + errorCode + "] ");
            }
            this.additionalRecordingHandler = null;
        }
        if (this.hardwareMotionDetection != null) {
            errorCode = this.hardwareMotionDetection.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.hardwareMotionDetection + " failed with error [" + errorCode + "] ");
            }
            this.hardwareMotionDetection = null;
        }
        if (this.genericEventTriggerHandler != null) {
            errorCode = this.genericEventTriggerHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.genericEventTriggerHandler + " failed with error [" + errorCode + "] for " + this);
            }
            this.genericEventTriggerHandler = null;
        }
        if (this.inactivityActionWatchdog != null) {
            errorCode = this.inactivityActionWatchdog.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.inactivityActionWatchdog + " failed with error [" + errorCode + "] ");
            }
            this.inactivityActionWatchdog = null;
        }
        if (this.videoStreamingActionHandler != null) {
            errorCode = this.videoStreamingActionHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.videoStreamingActionHandler + " failed with error [" + errorCode + "] ");
            }
            this.videoStreamingActionHandler = null;
        }
        return super.shutdown();
    }

    public Long getEntityID() {
        return this.getEntity().getEntityID();
    }

    public Long getEntityType() {
        return super.getEntity().getEntityType();
    }

    public String getEntityName() {
        return super.getEntity().getEntityName();
    }

    public HardwareMotionDetection<? extends MotionDetectionHandler> getHardwareMotionDetection() {
        return this.hardwareMotionDetection;
    }

    public GenericEventTriggerHandler getGenericEventHandler() {
        return this.genericEventTriggerHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordingHandler getRecordingHandler() {
        Object object = this.recordingHandlerSemaphore;
        synchronized (object) {
            if (this.recordingHandler != null && !this.recordingHandler.isShutdown()) {
                return this.recordingHandler;
            }
            if (this.getCore() != null && this.getCore().isShutdown()) {
                this.logger.warn((Object)((Object)this.getCore()) + " is already shutting down!");
                return null;
            }
            if (this.isShutdown(CLASS_NAME)) {
                this.logger.warn(this + " is already shutting down!");
                return null;
            }
            RecordingHandler localRecordingHandler = new RecordingHandler();
            int errorCode = this.additionalRecording ? localRecordingHandler.init(super.getCore(), (MDBAccessorIntf)this, this.getAdditionalRecordingHandler()) : localRecordingHandler.init(super.getCore(), this);
            if (errorCode != 0) {
                localRecordingHandler.shutdown();
                this.logger.error("Connecting MultimediaDatabase failed with error [" + errorCode + "] ");
                throw new RuntimeException("Initializing [RecordingHandler] failed with error [" + errorCode + "] ");
            }
            this.recordingHandler = localRecordingHandler;
        }
        return this.recordingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdditionalRecordingHandler getAdditionalRecordingHandler() {
        Object object = this.additionalRecordingHandlerSemaphore;
        synchronized (object) {
            if (this.additionalRecordingHandler != null) {
                return this.additionalRecordingHandler;
            }
            if (this.getCore() != null && this.getCore().isShutdown()) {
                this.logger.warn((Object)((Object)this.getCore()) + " is already shutting down!");
                return null;
            }
            if (this.isShutdown(CLASS_NAME)) {
                this.logger.warn(this + " is already shutting down!");
                return null;
            }
            AdditionalRecordingHandler localAdditionalRecordingHandler = new AdditionalRecordingHandler();
            int errorCode = localAdditionalRecordingHandler.init(super.getCore(), this, null);
            if (errorCode != 0) {
                localAdditionalRecordingHandler.shutdown();
                this.logger.error("Connecting MultimediaDatabase failed with error [" + errorCode + "] ");
                throw new RuntimeException("Initializing [AdditionalRecordingHandler] failed with error [" + errorCode + "] ");
            }
            this.additionalRecordingHandler = localAdditionalRecordingHandler;
        }
        return this.additionalRecordingHandler;
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (this.getCore() != null && this.getCore().isShutdown()) {
            this.logger.warn((Object)((Object)this.getCore()) + " is already shutting down, so refusing connection from " + socket);
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -21609;
        }
        if (networkDispatcherHeader.getProtocol() == 0) {
            return this.handleRequest(socket);
        }
        if (networkDispatcherHeader.getProtocol() == 1) {
            NetworkClientProxy networkClientProxy = new NetworkClientProxy(this.getCore().getConfigurationProvider());
            int errorCode = networkClientProxy.init(socket, networkDispatcherHeader.getClientID());
            if (errorCode != 0) {
                this.logger.error("Creating [NetworkClientProxy] with " + socket + "/" + networkDispatcherHeader + " failed with error [" + errorCode + "] ");
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return errorCode;
            }
            this.logger.info(socket + " used now as ContentStream for client [" + networkDispatcherHeader.getClientID() + "]");
            return super.getCore().registerNetworkClientProxy(networkClientProxy);
        }
        if (networkDispatcherHeader.getProtocol() == 3) {
            this.handleTrackingDataStreamRequest(socket, networkDispatcherHeader);
            return 0;
        }
        this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported ");
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -21005;
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME) || this.getCore().isShutdown()) {
            this.logger.error("... Client refused. " + this + " is already shutting down ");
            try {
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21609;
        }
        int activeThreads = Thread.activeCount();
        if (activeThreads >= Core.getThreadLimit()) {
            try {
                this.logger.error("There are already [" + activeThreads + "] threads active. So, the client connection " + socket + " will be refused!");
                socket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return -21680;
        }
        try {
            VideoServiceClientRequestHandler videoServiceRequestHandler = new VideoServiceClientRequestHandler(this, socket);
            int errorCode = videoServiceRequestHandler.init();
            if (errorCode != 0) {
                this.logger.error("Initializing [VideoServiceClientRequestHandler] failed with error [" + errorCode + "] ");
                errorCode = videoServiceRequestHandler.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down " + videoServiceRequestHandler + " failed with error [" + errorCode + "] ");
                }
                return errorCode;
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    private int handleTrackingDataStreamRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        TrackingDataStreamHandler trackingDataStreamHandler = new TrackingDataStreamHandler();
        int errorCode = trackingDataStreamHandler.init(socket);
        if (errorCode != 0) {
            this.logger.error("Initailizing [trackingDataStreamHandler] with " + socket + "/" + networkDispatcherHeader + " failed with error [" + errorCode + "] ");
            trackingDataStreamHandler.shutdown();
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return errorCode;
        }
        this.logger.info(trackingDataStreamHandler + " handles TrackingDataStream for client [" + networkDispatcherHeader.getClientID() + "]");
        this.listOfTrackingDataStreamHandler.add(trackingDataStreamHandler);
        try {
            for (int i = this.listOfTrackingDataStreamHandler.size() - 1; i >= 0; --i) {
                trackingDataStreamHandler = this.listOfTrackingDataStreamHandler.get(i);
                if (trackingDataStreamHandler != null && !trackingDataStreamHandler.isShutdown()) continue;
                this.listOfTrackingDataStreamHandler.remove(i);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    public void registerVideoServiceClientRequestHandler(VideoServiceClientRequestHandler videoServiceClientRequestHandler) {
        if (this.lastPublishedStatusService != null) {
            videoServiceClientRequestHandler.setLastPublishedServiceStatus(this.lastPublishedStatusService);
        }
        this.registeredVideoServiceClientRequestHandlers.add(videoServiceClientRequestHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deregisterVideoServiceClientRequestHandler(VideoServiceClientRequestHandler videoServiceClientRequestHandler) {
        Object object = this.clientRequestHandlerSemaphore;
        synchronized (object) {
            for (int i = 0; this.registeredVideoServiceClientRequestHandlers != null && i < this.registeredVideoServiceClientRequestHandlers.size(); ++i) {
                if (this.registeredVideoServiceClientRequestHandlers.get(i) != videoServiceClientRequestHandler) continue;
                this.registeredVideoServiceClientRequestHandlers.remove(i);
                return 0;
            }
        }
        return -21640;
    }

    public int sendMultipleStatus(VideoServiceClientRequestHandler videoServiceClientRequestHandler) {
        if (videoServiceClientRequestHandler != null && !videoServiceClientRequestHandler.isShutdown()) {
            try {
                GObject goLastPublishedStatusService;
                GObject goStatusControlLock;
                GObject goStatusAbsolutePTZ;
                ReqStatusContent reqStatusContent;
                SrpcMessage request;
                int errorCode;
                if (videoServiceClientRequestHandler.isLiveReaderAvailable() && !videoServiceClientRequestHandler.isDatabaseReaderAvailable() && (errorCode = videoServiceClientRequestHandler.sendStatus(request = SrpcMessage.createRequest((Methods)Methods.SSL_SRPC_REQ_STATUSCONTENT, (GObject)(reqStatusContent = new ReqStatusContent(this.getContentID(), this.getContentName())).createGObject()), false)) != 0) {
                    this.logger.warn("Sending " + request + " to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                }
                if (this.lastReqStatusAbsolutePTZ != null && (errorCode = videoServiceClientRequestHandler.sendStatus(request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSABSOLUTEPTZ, (GObject)(goStatusAbsolutePTZ = this.lastReqStatusAbsolutePTZ.createGObject())), false)) != 0) {
                    this.logger.warn("Sending " + goStatusAbsolutePTZ + " to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                }
                if ((errorCode = videoServiceClientRequestHandler.sendStatus(request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSCONTROLLOCK, (GObject)(goStatusControlLock = new ReqStatusControlLock(this.cameraControlLock.getUsername(), this.cameraControlLock.getClientId(), this.cameraControlLock.getTimeoutTime()).createGObject())))) != 0) {
                    this.logger.warn("Sending " + goStatusControlLock + " to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                }
                if (this.lastPublishedStatusService != null && (errorCode = videoServiceClientRequestHandler.sendStatus(request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSSERVICE, (GObject)(goLastPublishedStatusService = new ReqStatusService(this.lastPublishedStatusService).createGObject())))) != 0) {
                    this.logger.warn("Sending " + goLastPublishedStatusService + " to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Sending last multiple status to " + videoServiceClientRequestHandler + " failed ", ex);
                videoServiceClientRequestHandler.shutdown();
            }
        }
        return 0;
    }

    public abstract void checkFramerate();

    protected int checkInactivityAction(InactivityAction inactivityAction) {
        long inactivityTime;
        int errorCode = 0;
        if (inactivityAction.isEnabled() && this.tsLastCameraControl > 0L && (inactivityTime = System.currentTimeMillis() - this.tsLastCameraControl) > inactivityAction.getTimeout()) {
            errorCode = this.getEntityID().longValue() == inactivityAction.getServiceID() ? this.triggerAction(inactivityAction.getActionID()) : this.triggerActionOnAnotherService(inactivityAction.getServiceID(), inactivityAction.getActionID());
            this.tsLastCameraControl = -1L;
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int triggerActionOnAnotherService(long serviceId, long actionId) {
        GeneralProxy generalProxy = null;
        try {
            Location entity = super.getCore().getEntityLocationCache().get(serviceId);
            Long entityID = entity.getID();
            String entityHost = entity.getHost();
            Integer entityPort = entity.getPort();
            generalProxy = new GeneralProxy();
            generalProxy.init(entityHost, entityPort.intValue(), entityID.longValue());
            generalProxy.triggerAction(Long.valueOf(serviceId), Long.valueOf(actionId), Long.valueOf(-1L), Long.valueOf(-1L), Long.valueOf(-1L), null, 30000L);
            int n = 0;
            return n;
        }
        catch (Throwable ex) {
            this.logger.error("Remote action '" + actionId + "' could not be triggered at service " + serviceId, ex);
            int n = -20001;
            return n;
        }
        finally {
            if (generalProxy != null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                generalProxy.shutdown();
            }
        }
    }

    public void notifyForCameraControl() {
        this.tsLastCameraControl = System.currentTimeMillis();
    }

    public void notifyForNetworkFailure() {
        Vector vNetworkFailureActionParameter;
        if (this.getRecordingHandler() != null && this.getRecordingHandler().getDatabaseWriter() != null) {
            try {
                this.getRecordingHandler().getDatabaseWriter().finalizeCurrentSequence();
            }
            catch (Throwable throwable) {
                this.logger.warn("Error finalizing current sequence [" + throwable.getMessage() + "] for " + this);
            }
        }
        if (!(this.hardwareMotionDetection == null || this.notification != null && this.notification.isAlive())) {
            this.notification = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VideoSrv.this.hardwareMotionDetection.notifyForNetworkProblems();
                    }
                    catch (Throwable ex) {
                        VideoSrv.this.logger.error((Object)ex, ex);
                    }
                }
            }, "notification: " + this);
            this.notification.start();
        }
        long networkFailureActionDeadtime = 3600000L;
        try {
            networkFailureActionDeadtime = this.getVideoSourceCnf().getNetworkFailureActionDeadtime();
        }
        catch (ConfigurationException e) {
            this.logger.error("Could not read configured deadtime for network failure action, using default deadtime (1 hour) for " + this);
        }
        if (Math.abs(System.currentTimeMillis() - this.tsNotifyForNetworkFailure) < networkFailureActionDeadtime) {
            this.logger.info("Notification for network failure of " + this + " already triggered at [" + new Date(this.tsNotifyForNetworkFailure) + "]");
            return;
        }
        try {
            vNetworkFailureActionParameter = this.videoSourceCnf.getNetworkFailureActionParameter();
            if (vNetworkFailureActionParameter.size() <= 0) {
                return;
            }
        }
        catch (ConfigurationException cex) {
            this.logger.error((Object)cex, (Throwable)cex);
            return;
        }
        Long actionID = (Long)vNetworkFailureActionParameter.elementAt(0);
        Long serviceID = (Long)vNetworkFailureActionParameter.elementAt(1);
        if (actionID == null || actionID < 0L) {
            this.logger.warn("ActionID [" + actionID + "] not valid for " + this + "!");
            return;
        }
        if (serviceID == null || serviceID < 0L) {
            this.logger.warn("ServiceID [" + serviceID + "] not valid for " + this + "!");
            return;
        }
        this.triggerActionOnAnotherService(serviceID, actionID);
        this.tsNotifyForNetworkFailure = System.currentTimeMillis();
    }

    public void notifyForNetworkProblems() {
        try {
            if (this.hardwareMotionDetection != null) {
                this.hardwareMotionDetection.notifyForNetworkProblems();
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
    }

    public int triggerAction(Long actionID) {
        return this.triggerAction(actionID, -1L, -1L, -1L, null, -1L, -1L);
    }

    @Override
    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData, long ptzPriority, long ptzTimeout) {
        return this.triggerAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData, false, ptzPriority, ptzTimeout);
    }

    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData, boolean isControlGranted, long ptzPriority, long ptzTimeout) {
        if (this.isShutdown(CLASS_NAME) || this.getCore().isShutdown()) {
            this.logger.warn("Cannot trigger action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] because of shutdown of " + this + " ");
            return -21609;
        }
        try {
            String presetName = this.getPresetName(actionID);
            if (presetName != null) {
                if (!isControlGranted && this.cameraControlLock.islocked()) {
                    this.logger.info("No privileged access to locked " + this);
                    return 0;
                }
                CameraControlPriority requestCameraControlPriority = new CameraControlPriority(alarmScriptID, ptzPriority, ptzTimeout, false);
                if (!this.handlePTZPriority(requestCameraControlPriority)) {
                    return 0;
                }
                this.publishPtzUserName("System");
                String sDecodedPresetName = URLDecoder.decode(presetName.trim(), "UTF-8");
                return this.setPresetPosition(sDecodedPresetName);
            }
        }
        catch (ConfigurationException | UnsupportedEncodingException ex) {
            this.logger.error("Failed to set preset postion [" + ex.getMessage() + "] for " + this);
            return -21600;
        }
        for (Action action : this.actions) {
            long foundActionID = action.getActionID();
            long foundActionType = action.getActionType();
            if (foundActionID != actionID) continue;
            if (foundActionType == 9901L) {
                return this.getRecordingHandler().startStandardRecording(actionID, alarmScriptID, alarmInstanceID, System.currentTimeMillis() + alarmDuration, genericData);
            }
            if (foundActionType == 9902L) {
                return this.getRecordingHandler().stopStandardRecording(actionID, alarmScriptID, alarmInstanceID, genericData);
            }
            if (foundActionType == 9903L) {
                try {
                    long tsMaxRecording = System.currentTimeMillis() + this.videoSourceCnf.getPostEventTime();
                    if (alarmDuration != null && alarmDuration >= 0L) {
                        tsMaxRecording = System.currentTimeMillis() + alarmDuration;
                    }
                    return this.getRecordingHandler().startAlarmRecording(actionID, alarmScriptID, alarmInstanceID, tsMaxRecording, genericData);
                }
                catch (Exception ce) {
                    this.logger.error("Starting alarm recording for " + this + " failed", (Throwable)ce);
                    return -21677;
                }
            }
            if (foundActionType == 9904L) {
                return this.getRecordingHandler().stopAlarmRecording(actionID, alarmScriptID, alarmInstanceID, genericData);
            }
            if (foundActionType == 9960L) {
                this.logger.info("ACTION FOR EDGE STORAGE IMPORT RECEIVED");
                BasicVideoProfileHandler basicVideoProfileHandler = (BasicVideoProfileHandler)this.getVideoProfileHandler(null);
                this.getCore().getEdgeStorageHandler().addPlaybackVideoSourceClient(basicVideoProfileHandler.providePlaybackVideoSourceClient(false));
                return 0;
            }
            if (foundActionType == 9906L) {
                this.processStreamAction(foundActionType);
                return 0;
            }
            if (foundActionType == 9907L) {
                this.processStreamAction(foundActionType);
                return 0;
            }
            this.logger.error("Action type [" + foundActionType + "] is unknown to " + this);
            return -21672;
        }
        this.logger.error("Action [" + actionID + "] is unknown to " + this);
        return -21670;
    }

    protected void processStreamAction(long actionType) {
        Entity[] enabledEntities;
        LiveCameraSrv videoSrv;
        if (actionType == 9906L) {
            if (this.isStreamDisabled()) {
                return;
            }
            if (this.isStreamOnDemandActivated() && this instanceof LiveCameraSrv) {
                videoSrv = (LiveCameraSrv)this;
                this.shutdownVideoSourceClient(videoSrv.getBasicVideoProfileHandler());
                if (videoSrv.getAdditionalVideoProfileHandler() != null) {
                    for (VideoProfileHandler profileHandler : videoSrv.getAdditionalVideoProfileHandler()) {
                        this.shutdownVideoSourceClient(profileHandler);
                    }
                }
            }
            this.streamDisabled = true;
            this.sendStatusService(-21712);
            this.getCore().sendEvent(EventType.CM_EVENTTYPE_STREAM_DISABLED, this.getEntityID(), -1L, null);
        } else if (actionType == 9907L) {
            if (!this.isStreamDisabled()) {
                return;
            }
            this.streamDisabled = false;
            this.sendStatusService(0);
            this.getCore().sendEvent(EventType.CM_EVENTTYPE_STREAM_ENABLED, this.getEntityID(), -1L, null);
            if (this.isStreamOnDemandActivated() && this instanceof LiveCameraSrv) {
                videoSrv = (LiveCameraSrv)this;
                videoSrv.getBasicVideoProfileHandler().discard();
                if (videoSrv.getAdditionalVideoProfileHandler() != null) {
                    for (VideoProfileHandler profileHandler : videoSrv.getAdditionalVideoProfileHandler()) {
                        profileHandler.discard();
                    }
                }
            }
        } else {
            return;
        }
        long[] path = new long[]{this.getEntityID()};
        long[] typeList = new long[]{9906L};
        for (Entity entity : enabledEntities = this.getDevice().getEnabledEntities(path, typeList)) {
            if (!entity.getEntityType().equals(9906L)) continue;
            if (actionType == 9906L) {
                this.getCore().setEntityStatus(entity.getEntityID(), -21712);
                continue;
            }
            if (actionType != 9907L) continue;
            this.getCore().setEntityStatus(entity.getEntityID(), 0);
        }
    }

    public abstract int addPresetPosition(Vector<byte[]> var1, Long var2, String var3);

    public abstract int setAbsolutePTZ(VideoServiceClientRequestHandler var1, Integer var2, Integer var3, Integer var4);

    public abstract int setAbsolutePt(VideoServiceClientRequestHandler var1, Integer var2, Integer var3);

    public abstract int setAbsoluteZ(VideoServiceClientRequestHandler var1, Integer var2);

    public abstract int setContinuousPTZ(Integer var1, Integer var2, Integer var3);

    public abstract int setCenterPT(Integer var1, Integer var2, int[] var3);

    public abstract int setZoomArea(Integer var1, Integer var2, Integer var3, Integer var4, int[] var5);

    public abstract int setAbsoluteIris(Integer var1);

    public abstract int setContinuousIris(Integer var1);

    public abstract int setAutoIris(Boolean var1);

    public abstract int setAbsoluteFocus(Integer var1);

    public abstract int setContinuousFocus(Integer var1);

    public abstract int setAutoFocus(Boolean var1);

    public abstract int setZeroLux(Boolean var1);

    public abstract int setAutoZeroLux(Boolean var1);

    public abstract int setHomePosition();

    public abstract int setPresetPosition(String var1);

    public abstract int removePresetPosition(String var1);

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
        VideoServiceClientRequestHandler videoServiceClientRequestHandler;
        GObject goRequest = reqContentStatus.createGObject();
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.SSL_SRPC_REQ_STATUSCONTENT, (GObject)goRequest);
        long tsBlocked = System.currentTimeMillis();
        while (this.sendStatusBlocked) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tsBlocked + 60000L >= System.currentTimeMillis()) continue;
            this.logger.warn("Client connection of " + this + " is blocking! All clients will be discarded ...");
            for (int i = this.registeredVideoServiceClientRequestHandlers.size() - 1; i >= 0; --i) {
                videoServiceClientRequestHandler = this.registeredVideoServiceClientRequestHandlers.get(i);
                videoServiceClientRequestHandler.shutdown();
            }
            this.sendStatusBlocked = false;
        }
        this.sendStatusBlocked = true;
        if (this.registeredVideoServiceClientRequestHandlers != null) {
            for (int i = this.registeredVideoServiceClientRequestHandlers.size() - 1; i >= 0; --i) {
                videoServiceClientRequestHandler = this.registeredVideoServiceClientRequestHandlers.get(i);
                if (videoServiceClientRequestHandler.isShutdown()) continue;
                try {
                    int errorCode = videoServiceClientRequestHandler.sendStatus(request);
                    if (errorCode == 0) continue;
                    this.logger.warn("Sending content status to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "]");
                    videoServiceClientRequestHandler.shutdown();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.warn("Sending status to " + videoServiceClientRequestHandler + " failed", (Throwable)ex);
                    videoServiceClientRequestHandler.shutdown();
                }
            }
        }
        this.sendStatusBlocked = false;
    }

    public int sendStatusAbsolutePTZ(VideoServiceClientRequestHandler ownVideoServiceClientRequestHandler, Integer pan, Integer tilt, Integer zoom) {
        this.lastReqStatusAbsolutePTZ = new ReqStatusAbsolutePTZ(pan, tilt, zoom);
        GObject goReq = this.lastReqStatusAbsolutePTZ.createGObject();
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSABSOLUTEPTZ, (GObject)goReq);
        try {
            VideoServiceClientRequestHandler[] videoServiceClientRequestHandlers = this.getVideoServiceClientRequestHandlers();
            for (int i = videoServiceClientRequestHandlers.length; i > 0; --i) {
                VideoServiceClientRequestHandler otherVideoServiceClientRequestHandler = videoServiceClientRequestHandlers[i - 1];
                if (otherVideoServiceClientRequestHandler == ownVideoServiceClientRequestHandler || otherVideoServiceClientRequestHandler.isShutdown()) continue;
                try {
                    int errorCode = otherVideoServiceClientRequestHandler.sendStatus(request);
                    if (errorCode == 0) continue;
                    this.logger.warn("Sending " + (Object)((Object)this.lastReqStatusAbsolutePTZ) + " to " + otherVideoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    otherVideoServiceClientRequestHandler.shutdown();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.warn("Sending status to " + ownVideoServiceClientRequestHandler + " failed ", (Throwable)ex);
                    otherVideoServiceClientRequestHandler.shutdown();
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    private void sendStatusControlLock() {
        GObject goStatusControlLock = new ReqStatusControlLock(this.cameraControlLock.getUsername(), this.cameraControlLock.getClientId(), this.cameraControlLock.getTimeoutTime()).createGObject();
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSCONTROLLOCK, (GObject)goStatusControlLock);
        this.sendToAllServicedClients(request);
    }

    protected void sendStatusControlPriority() {
        GObject goStatusControlPriority = new ReqStatusControlPriority(this.cameraControlPriority.getEntityID(), this.cameraControlPriority.getPriority()).createGObject();
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSCONTROLPRIORITY, (GObject)goStatusControlPriority);
        this.sendToAllServicedClients(request);
    }

    @Override
    public void sendStatusPTZUser(String userName) {
        GObject goStatusPTZUser = new ReqStatusPTZUser(userName).createGObject();
        SrpcMessage srpcMessage = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSPTZUSER, (GObject)goStatusPTZUser);
        this.sendToAllServicedClients(srpcMessage);
    }

    private int sendToAllServicedClients(SrpcMessage srpcMessage) {
        if (this.isShutdown()) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        if (this.getCore() != null && this.getCore().isShutdown()) {
            this.logger.warn((Object)((Object)this.getCore()) + " is already shutting down!");
            return -21609;
        }
        try {
            VideoServiceClientRequestHandler[] videoServiceClientRequestHandlers = this.getVideoServiceClientRequestHandlers();
            for (int i = videoServiceClientRequestHandlers.length; i > 0; --i) {
                VideoServiceClientRequestHandler videoServiceClientRequestHandler = videoServiceClientRequestHandlers[i - 1];
                if (videoServiceClientRequestHandler.isShutdown()) continue;
                try {
                    int errorCode = videoServiceClientRequestHandler.sendStatus(srpcMessage);
                    if (errorCode == 0) continue;
                    this.logger.warn("Sending " + srpcMessage + " to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.warn("Sending " + srpcMessage + " to " + videoServiceClientRequestHandler + " failed", (Throwable)ex);
                    videoServiceClientRequestHandler.shutdown();
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    public int sendStatusService(int statusCode) {
        if (statusCode == 0 && this.isStreamDisabled()) {
            statusCode = -21712;
        }
        if (statusCode == -21603 || statusCode == -21656 || statusCode == -21712) {
            try {
                DatabaseWriter databaseWriter;
                RecordingHandler localRecordingHandler = this.getRecordingHandler();
                if (localRecordingHandler != null && (databaseWriter = this.getRecordingHandler().getDatabaseWriter()) != null) {
                    if (statusCode != -21712) {
                        this.logger.info("Network problem detected, finalizing current sequence of " + databaseWriter);
                    }
                    databaseWriter.finalizeCurrentSequence();
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Problems while finalizing sequence for " + this, ex);
            }
        }
        this.lastPublishedStatusService = statusCode;
        try {
            this.getCore().setEntityStatus(this.getEntityID(), statusCode);
            if (statusCode == -21656) {
                this.getCore().sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getEntityID(), statusCode, "Network connectivity problems for [" + this.getEntityName() + "]", "Network connectivity problems for [" + this.getEntityName() + "]");
                this.getCore().sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getEntityID());
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        try {
            VideoServiceClientRequestHandler[] videoServiceClientRequestHandlers = this.getVideoServiceClientRequestHandlers();
            for (int i = videoServiceClientRequestHandlers.length; i > 0; --i) {
                VideoServiceClientRequestHandler videoServiceClientRequestHandler = videoServiceClientRequestHandlers[i - 1];
                if (videoServiceClientRequestHandler.isShutdown()) continue;
                try {
                    int errorCode = videoServiceClientRequestHandler.sendStatusService(statusCode);
                    if (errorCode == 0) continue;
                    this.logger.warn("Sending service status [" + statusCode + "] to " + videoServiceClientRequestHandler + " failed with error [" + errorCode + "] ");
                    videoServiceClientRequestHandler.shutdown();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.warn("Sending service status [" + statusCode + "] to " + videoServiceClientRequestHandler + " failed", (Throwable)ex);
                    videoServiceClientRequestHandler.shutdown();
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    public VideoSourceCnf getVideoSourceCnf() {
        return this.videoSourceCnf;
    }

    public void setVideoSourceCnf(VideoSourceCnf videoSourceCnf) {
        this.videoSourceCnf = videoSourceCnf;
    }

    @Override
    public MDBCnfIntf getMDBCnf() {
        return this.videoSourceCnf;
    }

    @Override
    public long getRecordingDuration() {
        try {
            return this.standardRecordingTimerange.getExpirationTime(System.currentTimeMillis());
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot determine recording duration", ex);
        }
    }

    @Override
    public void setVideoMode(String videoMode) {
        if (!this.lastVideoMode.equals(videoMode)) {
            this.lastVideoMode = videoMode;
            this.changeVideoMode();
        } else {
            this.checkFramerate();
        }
    }

    public String getVideoMode() {
        return this.lastVideoMode;
    }

    public abstract void changeVideoMode();

    public Integer getLastPublishedStatusService() {
        return this.lastPublishedStatusService;
    }

    @Override
    public int checkService() {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        this.checkControlLock();
        this.checkInactivityAction(this.inactivityAction);
        long ts = System.currentTimeMillis();
        this.checkVideoProfileHandler();
        long duration = System.currentTimeMillis() - ts;
        if (duration > 9999L) {
            this.logger.warn("[checkVideoProfileHandler] of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        if (this.device.getDeviceType() != 209900L && this.device.getDeviceType() != 206802L && this.recordingHandler == null) {
            this.logger.error("Cannot ensure [RecordingHandler] for " + this);
            return -21600;
        }
        return 0;
    }

    public abstract int checkVideoProfileHandler();

    public AudioConfiguration getAudioConfiguration() {
        return this.audioConfiguration;
    }

    public abstract String getPresetName(long var1) throws ConfigurationException;

    public abstract ArrayOfCameraPreset getCameraPresetsList();

    public abstract int addCameraPresets(ArrayOfCameraPreset var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveReader[] getLiveReaders() {
        if (this.isShutdown(CLASS_NAME) || this.liveReaders == null) {
            return new LiveReader[0];
        }
        Vector<LiveReader> vector = this.liveReaders;
        synchronized (vector) {
            LiveReader[] liveReaderList = new LiveReader[this.liveReaders.size()];
            for (int i = 0; i < liveReaderList.length; ++i) {
                liveReaderList[i] = this.liveReaders.elementAt(i);
            }
            return liveReaderList;
        }
    }

    public void publishTrackingData(ContentFrame cfTrackingData) {
        LiveReader[] liveReaderss;
        for (LiveReader liveReaders : liveReaderss = this.getLiveReaders()) {
            liveReaders.deliverFrameToLive(cfTrackingData);
        }
        DatabaseWriter databaseWriter = this.getRecordingHandler().getDatabaseWriter();
        RecordingHandler localRecordingHandler = this.getRecordingHandler();
        if (databaseWriter != null && !databaseWriter.isShutdown() && localRecordingHandler.isRecordingActive()) {
            databaseWriter.deliverFrameToArchive((ContentFrame)cfTrackingData.clone(), false);
        }
    }

    public void invalidateAssociationOfVideoProfileHandler() {
        this.htLiveReaderFilter.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveReader[] getLiveReaders(VideoProfileHandler videoProfileHandler) {
        LiveReader[] liveReaderFound = this.htLiveReaderFilter.get(videoProfileHandler);
        if (liveReaderFound == null) {
            Vector<LiveReader> foundLiveReader = new Vector<LiveReader>();
            if (!this.isShutdown(CLASS_NAME) && this.liveReaders != null) {
                Vector<LiveReader> vector = this.liveReaders;
                synchronized (vector) {
                    for (int i = 0; i < this.liveReaders.size(); ++i) {
                        LiveReader liveReader = this.liveReaders.elementAt(i);
                        if (videoProfileHandler != liveReader.getVideoProfileHandler()) continue;
                        foundLiveReader.addElement(liveReader);
                    }
                }
            }
            liveReaderFound = new LiveReader[foundLiveReader.size()];
            for (int i = 0; i < foundLiveReader.size(); ++i) {
                liveReaderFound[i] = (LiveReader)((Object)foundLiveReader.elementAt(i));
            }
            this.htLiveReaderFilter.put(videoProfileHandler, liveReaderFound);
        }
        return liveReaderFound;
    }

    public int addLiveReader(LiveReader liveReader) {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn(this + " is already shutting down!");
            return -21609;
        }
        if (this.videoStreamingActionHandler != null && this.liveReaders.size() <= 0) {
            this.videoStreamingActionHandler.notifyForVideoStreamingStart();
        }
        this.liveReaders.addElement(liveReader);
        this.htLiveReaderFilter.clear();
        try {
            LinkedList<ContentFrame> videoBuffer;
            Integer statusService = this.getCore().getEntityStatus(this.getEntityID());
            if (statusService != null && statusService < 0) {
                this.logger.warn("Status [" + statusService + "] for " + this + ", so don't deliver a cached ContentFrame!");
            } else if (liveReader.getVideoProfileHandler() != null && (videoBuffer = liveReader.getVideoProfileHandler().getVideoBuffer()).size() > 0) {
                long tsStart = System.currentTimeMillis();
                int counter = 0;
                long volume = 0L;
                for (ContentFrame cf : videoBuffer) {
                    liveReader.deliverBufferedFrameToLive(cf);
                    ++counter;
                    volume += (long)cf.getData().length;
                }
                long duration = System.currentTimeMillis() - tsStart;
                this.logger.info("Start LiveStreaming with video buffer: [" + Basic.longToFormattedString((long)counter) + " frames] with a volume of [" + Basic.longToFormattedString((long)(volume >> 10)) + " KB]. Duration=[" + Basic.longToFormattedString((long)duration) + " ms]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        this.checkFramerate();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeLiveReader(LiveReader liveReader) {
        this.htLiveReaderFilter.clear();
        long tsStart = System.currentTimeMillis();
        Vector<LiveReader> vector = this.liveReaders;
        synchronized (vector) {
            for (int i = 0; i < this.liveReaders.size(); ++i) {
                if (this.liveReaders.elementAt(i) != liveReader) continue;
                this.liveReaders.removeElementAt(i);
                break;
            }
        }
        long duration = System.currentTimeMillis() - tsStart;
        if (duration > 9999L) {
            this.logger.warn("Removing " + (Object)((Object)liveReader) + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        if (this.videoStreamingActionHandler != null && this.liveReaders.size() <= 0) {
            this.videoStreamingActionHandler.notifyForVideoStreamingStop();
        }
        tsStart = System.currentTimeMillis();
        this.checkFramerate();
        duration = System.currentTimeMillis() - tsStart;
        if (duration > 9999L) {
            this.logger.warn("Checking framerate of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        return 0;
    }

    public VideoServiceClientRequestHandler[] getVideoServiceClientRequestHandlers() {
        if (this.isShutdown() || this.registeredVideoServiceClientRequestHandlers == null) {
            return new VideoServiceClientRequestHandler[0];
        }
        VideoServiceClientRequestHandler[] videoServiceClientRequestHandlers = new VideoServiceClientRequestHandler[this.registeredVideoServiceClientRequestHandlers.size()];
        for (int i = 0; i < videoServiceClientRequestHandlers.length; ++i) {
            videoServiceClientRequestHandlers[i] = this.registeredVideoServiceClientRequestHandlers.get(i);
        }
        return videoServiceClientRequestHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int checkControlLock() {
        Object object = this.controlLockSemaphore;
        synchronized (object) {
            if (this.cameraControlLock.isTimedOut()) {
                if (this.ptzLockTimer != null) {
                    this.ptzLockTimer.shutdown();
                    this.ptzLockTimer = null;
                } else {
                    this.logger.warn("Unexpected null value for ptzLockTimer in " + this);
                }
                this.cameraControlLock.unlock();
                this.sendStatusControlLock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setControlLock(VideoServiceClientRequestHandler videoServiceClientRequestHandler, String username, long clientID, long timeout) {
        Object object = this.controlLockSemaphore;
        synchronized (object) {
            this.endPtzPriority();
            if (this.ptzPriorityTimer != null) {
                this.ptzPriorityTimer = null;
            }
            this.logger.info("Unlock priority because Lock is being set");
            if (username == null || clientID < 0L || timeout < 0L) {
                this.logger.error("Invalid arguments for locking camera control of " + this);
                return -21601;
            }
            this.cameraControlLock.lock(username, clientID, timeout);
            this.ptzLockTimer = new PTZLockTimer();
            this.ptzLockTimer.init(this);
            this.sendStatusControlLock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeControlLock(VideoServiceClientRequestHandler videoServiceClientRequestHandler) {
        Object object = this.controlLockSemaphore;
        synchronized (object) {
            this.cameraControlLock.unlock(videoServiceClientRequestHandler);
            this.sendStatusControlLock();
        }
        return 0;
    }

    public boolean isPTZControlGranted(long clientId, long lockTimeout, long entityId, long priority, long priorityTimeout, String userName) {
        if (!this.isControlGranted(clientId, lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return false;
        }
        if (!this.handlePTZPriority(new CameraControlPriority(entityId, priority, priorityTimeout, true))) {
            return false;
        }
        this.publishPtzUserName(userName);
        return true;
    }

    private void publishPtzUserName(String userName) {
        try {
            if (this.videoSourceCnf.isShowUserNameOnPtz()) {
                this.statusPtzUserAgent.invoke(userName);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isControlGranted(long clientID, long timeout) {
        Object object = this.controlLockSemaphore;
        synchronized (object) {
            this.checkControlLock();
            return this.cameraControlLock.isControlGranted(clientID, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handlePTZPriority(CameraControlPriority requestCameraControlPriority) {
        boolean accessGranted = false;
        boolean priorityChanged = false;
        long endTimestamp = System.currentTimeMillis() + requestCameraControlPriority.getTimeout();
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            if (this.cameraControlPriority == null) {
                accessGranted = true;
                if (requestCameraControlPriority.getPriority() <= 0L) {
                    this.logger.debug("No priority given, but there was no lock previously for ");
                } else if (requestCameraControlPriority.getPriority() == 1001L) {
                    this.cameraControlPriority = requestCameraControlPriority;
                    this.ptzPriorityTimer = new PTZPriorityTimer(endTimestamp);
                    this.ptzPriorityTimer.startTimer();
                } else {
                    this.cameraControlPriority = requestCameraControlPriority;
                    this.ptzPriorityTimer = new PTZPriorityTimer(endTimestamp);
                    this.ptzPriorityTimer.startTimer();
                    priorityChanged = true;
                }
            } else if (requestCameraControlPriority.getPriority() <= 0L) {
                accessGranted = false;
            } else if (this.cameraControlPriority.getEntityID() == requestCameraControlPriority.getEntityID()) {
                this.ptzPriorityTimer.setEndTimestamp(endTimestamp);
                accessGranted = true;
            } else if (this.cameraControlPriority.getPriority() == 1001L && requestCameraControlPriority.getPriority() == 1001L) {
                this.ptzPriorityTimer.setEndTimestamp(endTimestamp);
                this.cameraControlPriority = requestCameraControlPriority;
                accessGranted = true;
            } else if (this.cameraControlPriority.getPriority() > requestCameraControlPriority.getPriority()) {
                this.ptzPriorityTimer.shutdown();
                this.cameraControlPriority = requestCameraControlPriority;
                this.setContinuousPTZ(0, 0, 0);
                this.setContinuousFocus(0);
                this.setContinuousIris(0);
                this.ptzPriorityTimer = new PTZPriorityTimer(endTimestamp);
                this.ptzPriorityTimer.startTimer();
                accessGranted = true;
                priorityChanged = true;
            }
            if (priorityChanged && !this.cameraControlLock.getClientHasLock()) {
                this.sendStatusControlPriority();
            }
        }
        return accessGranted;
    }

    public abstract ContentStreamIntf createContentStream(int var1);

    public abstract VideoProfileHandler getVideoProfileHandler(Integer var1);

    public abstract boolean isMPEG() throws ConfigurationException;

    public List<RspGetRecordingInfos> getRecordingInfosFromMdb(ReqGetRecordingInfos request) throws SeeTecException {
        long defaultMdbId = this.getDefaultMdb();
        ArrayList<Long> mdbIds = new ArrayList<Long>();
        mdbIds.add(defaultMdbId);
        try {
            long failoverMdbId = this.getCore().getFailoverMdbID();
            if (failoverMdbId != -1L) {
                this.getCore().getEntityLocationCache().get(failoverMdbId);
                mdbIds.add(failoverMdbId);
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.info("Failover MDB not registered.");
        }
        catch (Throwable throwable) {
            this.logger.info("Failover MDB cannot be found.", throwable);
        }
        ArrayList<RspGetRecordingInfos> result = new ArrayList<RspGetRecordingInfos>();
        for (Long id : mdbIds) {
            long mdbDeviceId = id + 1L;
            try {
                int errorCode = this.getRecordingInfosFromDatabase(request, result, mdbDeviceId);
                if (errorCode == 0) continue;
                this.logger.warn("[MDSProxy::getRecordingInfos] at [" + mdbDeviceId + "] failed with error [" + errorCode + "]");
                if (id == defaultMdbId) continue;
                this.logger.warn("No recording infos available on failover MDB, probably no recordings, so we ignore it.");
            }
            catch (SeeTecException errorCode) {
            }
            catch (Throwable throwable) {
                this.logger.warn("Problems while initializing MDS proxy or receiving recording infos", throwable);
            }
        }
        return result;
    }

    private long getDefaultMdb() throws SeeTecException {
        try {
            return this.getCore().getMultimediaDatabaseLifeCycle().getMultimediaDatabaseRuntime();
        }
        catch (Throwable throwable) {
            throw new SeeTecException(-21631, "Cannot locate local MDB", throwable);
        }
    }

    private int getRecordingInfosFromDatabase(ReqGetRecordingInfos request, List<RspGetRecordingInfos> result, long mdbDeviceId) throws SeeTecException, ConfigurationException {
        DatabaseProxyListener databaseProxyListener = null;
        if (mdbDeviceId == this.getCore().getMultimediaDatabaseLifeCycle().getMultimediaDatabaseDevice()) {
            if (this.databaseProxy == null) {
                this.databaseProxy = this.getCore().createDatabaseProxy(databaseProxyListener, mdbDeviceId);
            }
            return this.databaseProxy.getRecordingInformation(request, result);
        }
        if (mdbDeviceId == this.getCore().getFailoverMdbID() + 1L) {
            if (this.databaseProxyFailover == null) {
                this.databaseProxyFailover = this.getCore().createDatabaseProxy(databaseProxyListener, mdbDeviceId);
            }
            return this.databaseProxyFailover.getRecordingInformation(request, result);
        }
        this.logger.info("Could not create databaseProxy and get recording infos from database for " + mdbDeviceId);
        return -21600;
    }

    @Override
    public long getContentID() {
        return super.getServiceID();
    }

    @Override
    public String getContentName() {
        return super.getServiceName();
    }

    public void setAdditionalRecording(boolean isAdditionalRecordingConfigured) {
        this.additionalRecording = isAdditionalRecordingConfigured;
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "]";
    }

    @Override
    public final void checkAndStartMotionRecording(boolean isHardwareMotionDetection, boolean forceRecalculationPreAlarm) throws ConfigurationException {
        if (this.videoSourceCnf.isRecordOnMotion()) {
            this.motionRecordingHandler.checkAndStartMotionRecording(isHardwareMotionDetection, forceRecalculationPreAlarm);
        }
    }

    @Override
    public final void checkAndStartMotionRecording(boolean isHardwareMotionDetection) throws ConfigurationException {
        this.checkAndStartMotionRecording(isHardwareMotionDetection, false);
    }

    @Override
    public final void checkAndStopMotionRecording(boolean isHardwareMotionDetection) throws ConfigurationException {
        if (this.videoSourceCnf.isRecordOnMotion()) {
            this.motionRecordingHandler.checkAndStopMotionRecording();
        }
    }

    @Override
    public TimeRangeInfoContainer getRecordingInfos(ReqGetRecordingInfos request, boolean retrieveFromMDB, boolean useCleanAndMerge) {
        if (!retrieveFromMDB && this.recordingInfoContainer != null && this.recordingInfoContainer.getAge() > 300000L) {
            return this.recordingInfoContainer;
        }
        TimeRangeInfoContainer tempRecordingInfoContainer = null;
        this.logger.info("Executing " + request + " for " + this);
        try {
            List<RspGetRecordingInfos> result = this.getRecordingInfosFromMdb(request);
            if (result.isEmpty()) {
                this.logger.warn(request + " failed for " + this);
            } else {
                Long startTimestamp = result.get(0).getStartTimestamp();
                byte[] recordingInfos = result.get(0).getRecordings();
                Long startTimestampFailover = null;
                byte[] recordingInfosFailover = null;
                if (result.size() >= 2) {
                    startTimestampFailover = result.get(1).getStartTimestamp();
                    recordingInfosFailover = result.get(1).getRecordings();
                }
                RecordingInfoList recordingInfoList = new RecordingInfoList();
                RecordingInfoList recordingInfoListFailover = new RecordingInfoList();
                if (recordingInfos.length % 10 == 0) {
                    this.extractRecordingInfos(recordingInfos, recordingInfoList, false);
                    recordingInfoList.setAbsoluteStartTimestamp(startTimestamp);
                    if (startTimestampFailover != null && startTimestampFailover != -1L && recordingInfosFailover != null && recordingInfosFailover.length > 0 && recordingInfosFailover.length % 10 == 0) {
                        this.extractRecordingInfos(recordingInfosFailover, recordingInfoListFailover, true);
                        recordingInfoListFailover.setAbsoluteStartTimestamp(startTimestampFailover);
                        RecordingInfoList.adjustAbsoluteStartTimeStamp(recordingInfoList, recordingInfoListFailover);
                    }
                    if (recordingInfoList.isEmpty()) {
                        recordingInfoList = recordingInfoListFailover;
                    } else if (!recordingInfoListFailover.isEmpty()) {
                        recordingInfoList.mergeRecordingInfo(recordingInfoListFailover);
                        recordingInfoList.setAbsoluteStartTimestamp(Math.min(startTimestamp, startTimestampFailover));
                    }
                    long cumulationDistance = Math.max(request.getCumulationDistance(), 2000L);
                    if (recordingInfoList.size() > 1 && useCleanAndMerge) {
                        recordingInfoList.cleanAndMerge(cumulationDistance);
                    }
                    tempRecordingInfoContainer = recordingInfoList.convertToTimeRangeInfoContainer();
                    return tempRecordingInfoContainer;
                }
                this.logger.error("Could not parse recording infos. Length: " + recordingInfos.length + " for " + this);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn(request + " failed with error [" + ex.getMessage() + "] for " + this);
        }
        return tempRecordingInfoContainer;
    }

    private void extractRecordingInfos(byte[] rawdata, RecordingInfoList outRecordingInfoList, boolean isFailover) throws SeeTecException {
        for (int i = 0; i < rawdata.length; i += 10) {
            RecordingInfo recordingInfo = new RecordingInfo(Arrays.copyOfRange(rawdata, i, i + 10));
            recordingInfo.setIsFailover(isFailover);
            outRecordingInfoList.add(recordingInfo);
        }
    }

    public TimeRangeInfoContainer getRecordingInfos(String token) {
        ReqGetRecordingInfos reqGetRecordingInfos = new ReqGetRecordingInfos(Long.valueOf(this.getContentID()), Long.valueOf(-1L), Long.valueOf(-1L), Long.valueOf(-1L), Long.valueOf(-1L));
        reqGetRecordingInfos.setToken(token);
        this.recordingInfoContainer = this.getRecordingInfos(reqGetRecordingInfos, true, true);
        return this.recordingInfoContainer;
    }

    public List<Long[]> getDefaultMdbWriteProtections(ReqGetWriteProtections reqGetWriteProtections) throws SeeTecException {
        LinkedList writeProtectedTiles;
        block9: {
            DatabaseProxy[] mdsProxies = null;
            try {
                mdsProxies = this.getCore().createDatabaseProxies(null);
                DatabaseProxy[] srpcMessage = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETWRITEPROTECTIONS, (GObject)reqGetWriteProtections.createGObject());
                SrpcMessage srpcResponse = mdsProxies[0].sendGenericRequest((SrpcMessage)srpcMessage, 30000L);
                GObject goResponse = srpcResponse.getPayload();
                RspGetWriteProtections rspGetWriteProtections = RspGetWriteProtections.parseGObject((GObject)goResponse);
                int resultCode = rspGetWriteProtections.getResultCode();
                if (resultCode == 0) {
                    writeProtectedTiles = rspGetWriteProtections.getWriteProtections();
                    break block9;
                }
                throw new SeeTecException(resultCode, "Unable to fetch write protections");
            }
            catch (SeeTecException seeTecException) {
                throw seeTecException;
            }
            catch (Exception exception) {
                throw new SeeTecException(-21600, "Unable to fetch write protections [" + exception.getMessage() + "]");
            }
            finally {
                if (mdsProxies != null) {
                    for (DatabaseProxy mdsProxy : mdsProxies) {
                        if (mdsProxy == null) continue;
                        mdsProxy.shutdown();
                    }
                }
            }
        }
        return writeProtectedTiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endPtzPriority() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            if (this.cameraControlPriority != null) {
                this.cameraControlPriority.setEntityID(-1L);
                this.cameraControlPriority.setPriority(-1L);
                this.sendStatusControlPriority();
            }
            this.cameraControlPriority = null;
        }
    }

    public void setIsEdgeStorage(boolean isEdgeStorage) {
        this.isEdgeStorage = isEdgeStorage;
    }

    public boolean isEdgeStorage() {
        return this.isEdgeStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRecording(long start, long end, long videoSourceID) {
        this.logger.info("Remove recordings between " + new Date(start) + " and " + new Date(end) + " for videosource " + videoSourceID);
        ReqRemoveRecording request = new ReqRemoveRecording(Long.valueOf(videoSourceID), Long.valueOf(start), Long.valueOf(end));
        request.setContentID(Long.valueOf(this.getContentID()));
        DatabaseProxy[] mdsProxies = null;
        try {
            SrpcMessage responseMessageFailover;
            mdsProxies = this.getCore().createDatabaseProxies(null);
            DatabaseProxy[] requestMessage = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_REMOVERECORDING, (GObject)request.createGObject());
            SrpcMessage responseMessage = mdsProxies[0].sendGenericRequest((SrpcMessage)requestMessage, 30000L);
            if (responseMessage.getError() != 0) {
                this.logger.warn("Error while removing recordings for " + videoSourceID);
            }
            if (mdsProxies[1] != null && (responseMessageFailover = mdsProxies[1].sendGenericRequest((SrpcMessage)requestMessage, 30000L)).getError() != 0) {
                this.logger.warn("Error while removing recordings from failover MDS for " + videoSourceID);
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Error while removing recordings for " + videoSourceID);
        }
        finally {
            if (mdsProxies != null) {
                for (DatabaseProxy mdsProxy : mdsProxies) {
                    if (mdsProxy == null) continue;
                    mdsProxy.shutdown();
                }
            }
        }
    }

    public boolean isStreamOnDemandActivated() {
        try {
            return this.videoSourceCnf.getStreamOnDemandMode() == StreamOnDemandMode.ON_DEMAND;
        }
        catch (ConfigurationException ex) {
            this.logger.info("Can't get configuration StreamOnDemandMode for " + this);
            return false;
        }
    }

    public boolean isStreamOnDemandActivatedAndStreamDisabled() {
        return this.isStreamOnDemandActivated() && this.streamDisabled;
    }

    private void shutdownVideoSourceClient(VideoProfileHandler profileHandler) {
        if (profileHandler != null) {
            profileHandler.shutdownVideoSourceClient();
        }
    }

    private class PTZLockTimer
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.PTZLockTimer";
        private VideoSrv videoSrv = null;
        private Thread myThread = null;

        private PTZLockTimer() {
        }

        public int init(VideoSrv videoSrv) {
            this.videoSrv = videoSrv;
            if (this.videoSrv == null) {
                return -21601;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        public int shutdown() {
            this.startShutdown(CLASS_NAME);
            return 0;
        }

        @Override
        public void run() {
            try {
                while (!super.isShutdown(CLASS_NAME) && !this.videoSrv.isShutdown()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.videoSrv.checkControlLock();
                }
            }
            catch (Throwable ex) {
                VideoSrv.this.logger.error((Object)ex, ex);
            }
            VideoSrv.this.logger.info("Thread of this " + this + " finished ");
        }

        public String toString() {
            return "[" + super.toString() + ", " + this.videoSrv + "], " + this.myThread + "]]";
        }
    }

    private class TrackingDataStreamHandler
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.VideoSrv.TrackingDataStreamHandler";
        private Thread myThread = null;
        private Socket socket = null;
        private ContentTransportQueue ctqExclusiveRecipient = null;

        private TrackingDataStreamHandler() {
        }

        public int init(Socket socket) {
            this.socket = socket;
            if (this.socket == null) {
                return -21601;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        public final boolean isShutdown() {
            return this.isShutdown(CLASS_NAME);
        }

        public int shutdown() {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            VideoSrv.this.logger.info("Shutting down " + this);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.socket = null;
            }
            return 0;
        }

        @Override
        public void run() {
            long lastIncomingData = System.currentTimeMillis();
            this.ctqExclusiveRecipient = null;
            try {
                byte[] leadingHeader;
                this.socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(1L));
                VideoSrv.this.logger.info("Reading TrackingDataStream from " + this.socket);
                InputStream is = this.socket.getInputStream();
                int magic = Basic.byteArrayToInt4((byte[])this.readByteArrayFromInputStream(is, 4));
                VideoSrv.this.logger.info("Magic=[" + Integer.toHexString(magic) + "]");
                if (magic == Basic.byteArrayToInt4((byte[])SSL_SRPC_TCP_HEADER)) {
                    leadingHeader = this.readByteArrayFromInputStream(is, 12);
                    long nIDOfAnalyzingEntity = Basic.byteArrayToInt8((byte[])leadingHeader, (int)0, (int)8);
                    VideoSrv.this.logger.info("IDOfAnalyzingEntity=[" + nIDOfAnalyzingEntity + "]");
                    int nLengthDescription = Basic.byteArrayToInt4((byte[])leadingHeader, (int)8, (int)4);
                    VideoSrv.this.logger.info("LengthOfDescription=[" + nLengthDescription + "]");
                    byte[] description = this.readByteArrayFromInputStream(is, nLengthDescription);
                    VideoSrv.this.logger.info("Description=[" + new String(description) + "]");
                } else if (magic == Basic.byteArrayToInt4((byte[])SSL_SRPC_TRACKINGDATA_HEADER)) {
                    leadingHeader = this.readByteArrayFromInputStream(is, 28);
                    long idOfAnalyzingEntity = Basic.byteArrayToInt8((byte[])leadingHeader, (int)0, (int)8);
                    VideoSrv.this.logger.info("IDOfAnalyzingEntity=[" + idOfAnalyzingEntity + "]");
                    int lengthDescription = Basic.byteArrayToInt4((byte[])leadingHeader, (int)8, (int)4);
                    VideoSrv.this.logger.info("LengthOfDescription=[" + lengthDescription + "]");
                    long targetClientID = Basic.byteArrayToInt8((byte[])leadingHeader, (int)12, (int)8);
                    VideoSrv.this.logger.info("TargetClientID=[" + targetClientID + "]");
                    long targetSessionID = Basic.byteArrayToInt8((byte[])leadingHeader, (int)20, (int)8);
                    VideoSrv.this.logger.info("TargetSessionID=[" + targetSessionID + "]");
                    byte[] description = this.readByteArrayFromInputStream(is, lengthDescription);
                    VideoSrv.this.logger.info("Description=[" + new String(description) + "]");
                    if (targetSessionID < 0L) {
                        VideoSrv.this.logger.info("Broadcasting all tracking data ...");
                    } else {
                        this.ctqExclusiveRecipient = VideoSrv.this.getCore().determineClientRecipient(targetClientID, targetSessionID);
                        if (this.ctqExclusiveRecipient == null) {
                            throw new RuntimeException("No recipient found for ClientID=[" + targetClientID + "] with SessionID=[" + targetSessionID + "]");
                        }
                        VideoSrv.this.logger.info("ExclusiveRecipient for tracking data is " + (Object)((Object)this.ctqExclusiveRecipient));
                    }
                } else {
                    throw new RuntimeException("Magic [" + Integer.toHexString(magic) + "] not valid for " + this);
                }
                while (!super.isShutdown(CLASS_NAME) && !VideoSrv.this.isShutdown()) {
                    byte[] transmissionFrame;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException leadingHeader2) {
                        // empty catch block
                    }
                    try {
                        transmissionFrame = this.readByteArrayFromInputStream(is, 20);
                        lastIncomingData = System.currentTimeMillis();
                    }
                    catch (SocketTimeoutException stex) {
                        if (Math.abs(System.currentTimeMillis() - lastIncomingData) <= 60000L) continue;
                        VideoSrv.this.logger.warn("Stop reading tracking data because of timeout for " + this);
                        break;
                    }
                    int nMagic = Basic.byteArrayToInt4((byte[])transmissionFrame, (int)0, (int)4);
                    if (nMagic != Basic.byteArrayToInt4((byte[])SSLConstantsIntf.SSL_SRPC_TCP_HEADER, (int)0, (int)4) && nMagic != Basic.byteArrayToInt4((byte[])SSLConstantsIntf.SSL_SRPC_TRACKINGDATA_HEADER, (int)0, (int)4)) {
                        throw new RuntimeException("Invalid MagicHeader [" + Long.toHexString(nMagic) + "] read for " + this);
                    }
                    long startTimestamp = Basic.byteArrayToInt8((byte[])transmissionFrame, (int)4, (int)8);
                    if (startTimestamp > System.currentTimeMillis() && startTimestamp < System.currentTimeMillis() + 10000L) {
                        startTimestamp = System.currentTimeMillis();
                    }
                    if (startTimestamp < System.currentTimeMillis() - 60000L || startTimestamp > System.currentTimeMillis() + 100L) {
                        try {
                            VideoSrv.this.logger.info("Start timestamp: " + startTimestamp + ", Current time: " + System.currentTimeMillis() + ", bytes from transmission frame: [" + transmissionFrame[4] + "] [" + transmissionFrame[5] + "] [" + transmissionFrame[6] + "] [" + transmissionFrame[7] + "] [" + transmissionFrame[8] + "] [" + transmissionFrame[9] + "] [" + transmissionFrame[10] + "] [" + transmissionFrame[11] + "] ");
                        }
                        catch (Throwable description) {
                            // empty catch block
                        }
                        throw new RuntimeException("Invalid StartTimestamp [" + Basic.longToFormattedString((long)startTimestamp) + "]/[" + new Date(startTimestamp) + "] read for " + this);
                    }
                    int mediatype = Basic.byteArrayToInt4((byte[])transmissionFrame, (int)12, (int)4);
                    if (mediatype < 0) {
                        throw new RuntimeException("Invalid Mediatype [" + mediatype + "] read for " + this);
                    }
                    int dataLength = Basic.byteArrayToInt4((byte[])transmissionFrame, (int)16, (int)4);
                    if (dataLength < 0 || dataLength > 0x100000) {
                        throw new RuntimeException("Invalid DataLength [" + Basic.longToFormattedString((long)dataLength) + "] read for " + this);
                    }
                    byte[] data = null;
                    while (!super.isShutdown(CLASS_NAME) && !VideoSrv.this.isShutdown()) {
                        try {
                            data = this.readByteArrayFromInputStream(is, dataLength);
                            lastIncomingData = System.currentTimeMillis();
                        }
                        catch (SocketTimeoutException stex) {
                            if (Math.abs(System.currentTimeMillis() - lastIncomingData) <= 60000L) continue;
                            VideoSrv.this.logger.warn("Stop reading tracking data because of timeout for " + this);
                        }
                        break;
                    }
                    if (data == null) {
                        VideoSrv.this.logger.warn("No TrackingData read for " + this);
                        break;
                    }
                    ContentFrame cfTrackingData = new ContentFrame(mediatype, 0, startTimestamp, startTimestamp, data);
                    if (this.ctqExclusiveRecipient != null) {
                        short transactionID = 0;
                        this.ctqExclusiveRecipient.putContentFrame(false, -1L, new ContentFrame[]{cfTrackingData}, true, transactionID, false);
                        continue;
                    }
                    VideoSrv.this.publishTrackingData(cfTrackingData);
                }
            }
            catch (Throwable ex) {
                VideoSrv.this.logger.error((Object)ex, ex);
            }
            VideoSrv.this.logger.info("Thread of this " + this + " finished ");
            this.shutdown();
        }

        private byte[] readByteArrayFromInputStream(InputStream is, int length) throws SeeTecException, IOException {
            int bytesRead;
            if (is == null) {
                throw new SeeTecException(-1, "Argument <InputStream> not valid");
            }
            if (length < 0 || length > 0x1000000) {
                throw new SeeTecException(-1, "Argument <Length> not valid");
            }
            byte[] result = new byte[length];
            for (int offset = 0; offset < result.length; offset += bytesRead) {
                bytesRead = is.read(result, offset, result.length - offset);
                if (bytesRead >= 0) continue;
                throw new SeeTecException(-1, "Unexpected EndOfStream");
            }
            return result;
        }

        public String toString() {
            String sThis = "de.seetec.v5.re.cm.device.shared.VideoSrv.TrackingDataStreamHandler@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + VideoSrv.this + ", Socket=[" + this.socket + "]]";
        }
    }

    private class VideoStreamingActionHandler
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.VideoStreamingActionHandler";
        private VideoSrv videoSrv = null;
        private Thread myThread = null;
        private long executionDelay = -1L;
        private VideoStreamingAction videoStreamingStartAction = null;
        private VideoStreamingAction videoStreamingStopAction = null;
        private VideoStreamingAction lastNotifying = null;
        private long tsLastNotifying = -1L;

        private VideoStreamingActionHandler() {
        }

        public int init(VideoSrv videoSrv, long executionDelay, VideoStreamingAction videoStreamingStartAction, VideoStreamingAction videoStreamingStopAction) {
            this.videoSrv = videoSrv;
            if (this.videoSrv == null) {
                return -21601;
            }
            this.executionDelay = executionDelay;
            if (this.executionDelay > 0x100000000L) {
                return -21601;
            }
            this.videoStreamingStartAction = videoStreamingStartAction;
            if (this.videoStreamingStartAction == null) {
                return -21601;
            }
            this.videoStreamingStopAction = videoStreamingStopAction;
            if (this.videoStreamingStopAction == null) {
                return -21601;
            }
            if (videoStreamingStartAction.isEnabled() || videoStreamingStopAction.isEnabled()) {
                this.myThread = new Thread((Runnable)this, this.toString());
                this.myThread.start();
            }
            return 0;
        }

        public int shutdown() {
            this.startShutdown(CLASS_NAME);
            return 0;
        }

        @Override
        public void run() {
            try {
                while (!super.isShutdown(CLASS_NAME) && !this.videoSrv.isShutdown()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.lastNotifying == null || this.lastNotifying.getActionID() <= 0L || System.currentTimeMillis() - this.tsLastNotifying <= 500L) continue;
                    if (VideoSrv.this.logger.isDebugEnabled()) {
                        VideoSrv.this.logger.info("-----------------------------------------");
                        VideoSrv.this.logger.info("LastNotifying: " + this.lastNotifying);
                        VideoSrv.this.logger.info("[" + Basic.longToFormattedString((long)(System.currentTimeMillis() - this.lastNotifying.getTimestampLastTriggering())) + " ms]");
                        VideoSrv.this.logger.info("-----------------------------------------");
                    }
                    if (System.currentTimeMillis() - this.lastNotifying.getTimeout() > this.lastNotifying.getTimestampLastTriggering()) {
                        this.lastNotifying.setTimestampLastTriggering(System.currentTimeMillis());
                        this.notifyForVideoStreamingAction(this.lastNotifying);
                        this.lastNotifying = null;
                        this.tsLastNotifying = -1L;
                        continue;
                    }
                    VideoSrv.this.logger.info(">>>" + this.lastNotifying + " will not be triggered because of deadtime!");
                }
            }
            catch (Throwable ex) {
                VideoSrv.this.logger.error((Object)ex, ex);
            }
            VideoSrv.this.logger.info("Thread of this " + this + " finished");
        }

        public final void notifyForVideoStreamingStart() {
            this.lastNotifying = this.videoStreamingStartAction;
            this.tsLastNotifying = System.currentTimeMillis();
        }

        public final void notifyForVideoStreamingStop() {
            this.lastNotifying = this.videoStreamingStopAction;
            this.tsLastNotifying = System.currentTimeMillis();
        }

        public void notifyForVideoStreamingAction(VideoStreamingAction videoStreamingAction) {
            VideoSrv.this.triggerActionOnAnotherService(videoStreamingAction.getServiceID(), videoStreamingAction.getActionID());
        }

        public String toString() {
            String sThis = "de.seetec.v5.re.cm.shared.VideoStreamingActionHandler@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.videoSrv + ", Thread=[" + (this.myThread != null) + "], ExecutionDelay=[" + Basic.longToFormattedString((long)this.executionDelay) + "], " + this.videoStreamingStartAction + ", " + this.videoStreamingStopAction + "]";
        }
    }

    private class InactivityActionWatchdog
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.InactivityActionWatchdog";
        private VideoSrv videoSrv = null;
        private Thread myThread = null;

        private InactivityActionWatchdog() {
        }

        public int init(VideoSrv videoSrv) {
            this.videoSrv = videoSrv;
            if (this.videoSrv == null) {
                return -21601;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        public int shutdown() {
            this.startShutdown(CLASS_NAME);
            return 0;
        }

        @Override
        public void run() {
            try {
                while (!super.isShutdown(CLASS_NAME) && !this.videoSrv.isShutdown()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.videoSrv.checkInactivityAction(VideoSrv.this.inactivityAction);
                }
            }
            catch (Throwable ex) {
                VideoSrv.this.logger.error((Object)ex, ex);
            }
            VideoSrv.this.logger.info("Thread of this " + this + " finished");
        }

        public String toString() {
            return "[" + super.toString() + ", " + this.videoSrv + "], " + this.myThread + "]]";
        }
    }

    private class PTZPriorityTimer
    implements Runnable {
        private volatile long endTimestamp;
        private boolean isShutdown;

        private PTZPriorityTimer(long endTimestamp) {
            this.endTimestamp = endTimestamp;
            this.isShutdown = false;
        }

        @Override
        public void run() {
            while (!this.isShutdown && System.currentTimeMillis() < this.endTimestamp) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isShutdown) {
                this.shutdown();
            }
        }

        private void startTimer() {
            this.isShutdown = false;
            Thread timerThread = new Thread((Runnable)this, this.toString());
            timerThread.start();
        }

        private void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        private void shutdown() {
            if (!this.isShutdown) {
                this.isShutdown = true;
                VideoSrv.this.endPtzPriority();
            }
        }
    }
}

