/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.device.shared.PtzControlStatus;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class StatusPtzUserAgent {
    private static final int OVERLAY_TIMEOUT = 5000;
    private final PtzControlStatus ptzControlStatus;
    private final ScheduledExecutorService schedulerService;
    private final SystemTimeProvider systemTimeProvider;
    private ScheduledFuture<?> scheduledFuture = null;
    private long lastSendStatus = -1L;
    private String lastUser = null;

    public StatusPtzUserAgent(PtzControlStatus ptzControlStatus) throws SeeTecException {
        this(ptzControlStatus, (SystemTimeProvider)new DefaultSystemTimeProvider());
    }

    protected StatusPtzUserAgent(PtzControlStatus ptzControlStatus, SystemTimeProvider systemTimeProvider) throws SeeTecException {
        this.ptzControlStatus = ptzControlStatus;
        if (this.ptzControlStatus == null || (this.systemTimeProvider = systemTimeProvider) == null) {
            throw new SeeTecException(-20002, "Required arguments null");
        }
        this.schedulerService = Executors.newSingleThreadScheduledExecutor();
    }

    public void invoke(String userName) {
        this.invoke(userName, 5000L);
    }

    public void invoke(String userName, long timeoutInMillis) {
        if (this.schedulerService.isShutdown() || userName == null) {
            return;
        }
        if (this.systemTimeProvider.currentTimeMillis() - TimeUnit.SECONDS.toMillis(1L) > this.lastSendStatus || !userName.equals(this.lastUser)) {
            this.ptzControlStatus.sendStatusPTZUser(userName);
            this.clearStatusPtzUserAfterTimeout(timeoutInMillis);
            this.lastSendStatus = this.systemTimeProvider.currentTimeMillis();
            this.lastUser = userName;
        }
    }

    private void clearStatusPtzUserAfterTimeout(long timeout) {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.schedulerService.schedule(() -> this.ptzControlStatus.sendStatusPTZUser(""), timeout, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.schedulerService.shutdownNow();
    }
}

