/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.shared.TimerangeCnf;
import de.seetec.v5.re.shared.VideoSourceCnf;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MotionRecordingHandler {
    private static final long DEFAULT_RECORDONMOTION_POSTALARM = TimeUnit.DAYS.toMillis(36500L);
    private final Logger logger;
    private final TimerangeCnf recordOnMotionTimerange;
    private final VideoSourceCnf videoSourceCnf;
    private final VideoSrv videoSrv;
    private final SystemTimeProvider systemTimeProvider;
    private final ScheduledExecutorService futureRecordOnMotion = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean isRecordOnMotionActive = new AtomicBoolean(false);
    private ScheduledFuture<?> futureTask = null;

    public MotionRecordingHandler(TimerangeCnf recordOnMotionTimerange, VideoSourceCnf videoSourceCnf, VideoSrv videoSrv, SystemTimeProvider systemTimeProvider) {
        this.recordOnMotionTimerange = recordOnMotionTimerange;
        this.videoSourceCnf = videoSourceCnf;
        this.videoSrv = videoSrv;
        this.systemTimeProvider = systemTimeProvider;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public final void checkAndStartMotionRecording(boolean isHardwareMotionDetection, boolean forceRecalculationPreAlarm) throws ConfigurationException {
        long preAlarm = this.videoSourceCnf.getRecordOnMotionPreAlarm();
        long postAlarm = this.videoSourceCnf.getRecordOnMotionPostAlarm();
        long timeNow = this.systemTimeProvider.currentTimeMillis();
        if (isHardwareMotionDetection) {
            this.checkAndStartDeviceTriggeredMotionRecording(preAlarm, postAlarm, timeNow, forceRecalculationPreAlarm);
            return;
        }
        this.checkAndStartServerTriggeredMotionRecording(preAlarm, postAlarm, timeNow, forceRecalculationPreAlarm);
    }

    public final void checkAndStopMotionRecording() throws ConfigurationException {
        this.shutdown();
        long postAlarm = this.videoSourceCnf.getRecordOnMotionPostAlarm();
        if (postAlarm > 0L) {
            this.videoSrv.getRecordingHandler().stopRecordOnMotionAlarmRecording(postAlarm);
        } else {
            this.videoSrv.getRecordingHandler().stopAlarmRecording();
        }
    }

    public final void shutdown() {
        this.isRecordOnMotionActive.compareAndSet(true, false);
        if (this.futureTask != null) {
            this.futureTask.cancel(true);
        }
    }

    private void checkAndStartDeviceTriggeredMotionRecording(long preAlarm, long postAlarm, long timeNow, boolean forceRecalculationPreAlarm) {
        if (this.recordOnMotionTimerange.getExpirationTime(timeNow) >= 0L) {
            this.videoSrv.getRecordingHandler().startAlarmRecording(preAlarm, postAlarm, true, forceRecalculationPreAlarm);
        }
    }

    private void checkAndStartServerTriggeredMotionRecording(long preAlarm, long postAlarm, long timeNow, boolean forceRecalculationPreAlarm) throws ConfigurationException {
        if (!this.isTimerangeConfigured()) {
            this.videoSrv.getRecordingHandler().startAlarmRecording(preAlarm, DEFAULT_RECORDONMOTION_POSTALARM, true, forceRecalculationPreAlarm);
        } else {
            long schedulingTime = this.calculateSchedulingTime(timeNow);
            if (this.isRecordOnMotionActive.compareAndSet(false, true)) {
                this.futureTask = this.futureRecordOnMotion.schedule(() -> {
                    while (this.isRecordOnMotionActive.get()) {
                        long expirationTime = this.recordOnMotionTimerange.getExpirationTime(this.systemTimeProvider.currentTimeMillis());
                        if (expirationTime >= 0L && !this.videoSrv.getRecordingHandler().isAlarmRecordingActive()) {
                            long recordOnMotionExpirationTime = expirationTime + postAlarm;
                            this.videoSrv.getRecordingHandler().startAlarmRecording(preAlarm, recordOnMotionExpirationTime, true, forceRecalculationPreAlarm);
                        }
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.debug("Thread " + interruptedException.getMessage());
                        }
                    }
                }, schedulingTime, TimeUnit.MILLISECONDS);
            }
        }
    }

    private long calculateSchedulingTime(long timeNow) throws ConfigurationException {
        long expirationTime = this.recordOnMotionTimerange.getExpirationTime(timeNow);
        long scheduleRecordOnMotion = expirationTime < 0L ? Math.abs(expirationTime) : 0L;
        return scheduleRecordOnMotion;
    }

    private boolean isTimerangeConfigured() throws ConfigurationException {
        return this.videoSourceCnf.getRecordOnMotionTimeRangeId() > -1L;
    }
}

