/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepositoryListener;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.qognifymetadatamanager.MetadataManager;
import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.metadata.MetadataReader;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.acutvista.AcutvistaCameraSrv;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraSrv;
import de.seetec.v5.re.cm.device.video.lumenera.LumeneraCameraSrv;
import de.seetec.v5.re.cm.device.video.mobotix.MobotixCameraSrv;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraSrv;
import de.seetec.v5.re.cm.device.video.santec.SantecCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.TamperingCnf;
import de.seetec.v5.re.cm.shared.VideoLossCnf;
import de.seetec.v5.re.cm.shared.communication.ContentStream;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public abstract class LiveCameraSrv
extends VideoSrv
implements QognifyMetadataManagerRepositoryListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.LiveCameraSrv";
    protected CameraControl cameraControl = null;
    protected long lastCannotCreateDeviceEventSent = Long.MIN_VALUE;
    private MetadataReader metadataReader;
    private Vector<PresetCnf> presetList = null;
    private final Integer[] prevValuesForContinuesPTZ = new Integer[]{0, 0, 0};
    private BasicVideoProfileHandler basicVideoProfileHandler = null;
    private VideoProfileHandler[] additionalVideoProfileHandlers = null;
    private AudioOutServer audioOutServer = null;
    private long externalID = -1L;
    private TamperingCnf tamperingCnf = null;
    private VideoLossCnf videoLossCnf = null;
    private final Hashtable<String, Long> detectionTimes = new Hashtable();
    private String currentPresetPosition = "";

    @Override
    public int init(Vector<PresetCnf> presetList) throws ConfigurationException {
        VideoSourceParameter alarmVideoSourceParameter;
        int dynamicVideoProfileID = -1;
        VideoSourceParameter standardVideoSourceParameter = new VideoSourceParameter();
        int errorCode = standardVideoSourceParameter.init(super.getEntity(), null, "Standard");
        if (errorCode != 0) {
            this.logger.error("Creating VideoSourceParameter for the standard modus failed with error [" + errorCode + "]");
            return errorCode;
        }
        if (standardVideoSourceParameter.getRtspPort() == -1) {
            standardVideoSourceParameter.setRtspPort(this.device.getDeviceCnf().getRTSPport());
        }
        if ((errorCode = (alarmVideoSourceParameter = new VideoSourceParameter()).init(super.getEntity(), null, "Alarm")) != 0) {
            this.logger.error("Creating VideoSourceParameter for the alarm modus failed with error [" + errorCode + "]");
            return errorCode;
        }
        if (alarmVideoSourceParameter.getRtspPort() == -1) {
            alarmVideoSourceParameter.setRtspPort(this.device.getDeviceCnf().getRTSPport());
        }
        this.basicVideoProfileHandler = new BasicVideoProfileHandler();
        errorCode = this.basicVideoProfileHandler.init(super.getCore(), this, standardVideoSourceParameter, alarmVideoSourceParameter, ++dynamicVideoProfileID);
        if (errorCode != 0) {
            this.logger.error("Creating [BasicVideoProfileHandler] failed with error [" + errorCode + "]");
            return errorCode;
        }
        VideoProfileHandler videoProfileHandlerPreferredForMotionDetection = this.basicVideoProfileHandler;
        String[] videoProfiles = VideoSourceParameter.getAdditionalVideoProfiles((byte[])super.getEntity().getConfiguration());
        if (videoProfiles.length <= 0) {
            this.additionalVideoProfileHandlers = new AdditionalVideoProfileHandler[0];
        } else {
            this.additionalVideoProfileHandlers = new AdditionalVideoProfileHandler[videoProfiles.length];
            for (int i = 0; i < videoProfiles.length; ++i) {
                AdditionalVideoProfileHandler additionalVideoProfileHandler;
                VideoSourceParameter videoSourceParameter = new VideoSourceParameter();
                errorCode = videoSourceParameter.init(super.getEntity(), videoProfiles[i], null);
                if (errorCode != 0) {
                    this.logger.error("Creating VideoSourceParameter for VideoProfile [" + videoProfiles[i] + "] failed with error [" + errorCode + "]");
                    return errorCode;
                }
                if (videoSourceParameter.getRtspPort() == -1) {
                    videoSourceParameter.setRtspPort(this.device.getDeviceCnf().getRTSPport());
                }
                if ((errorCode = (additionalVideoProfileHandler = new AdditionalVideoProfileHandler()).init(super.getCore(), this, videoSourceParameter, ++dynamicVideoProfileID)) != 0) {
                    this.logger.error("Creating [AdditionalVideoProfileHandler] failed with error [" + errorCode + "]");
                    return errorCode;
                }
                if (this.getVideoSourceCnf().getAlarmRecordingStreamIndex() == dynamicVideoProfileID) {
                    this.logger.info("Enabling Alarm Recording of Stream " + dynamicVideoProfileID + " for " + this.device);
                    super.setAdditionalRecording(true);
                    additionalVideoProfileHandler.setAdditionalRecording(true);
                }
                this.additionalVideoProfileHandlers[i] = additionalVideoProfileHandler;
                if (!this.additionalVideoProfileHandlers[i].getVideoSourceParameter().isFetchPermanently()) continue;
                videoProfileHandlerPreferredForMotionDetection = this.additionalVideoProfileHandlers[i];
            }
        }
        if (this.isStreamOnDemandActivatedAndStreamDisabled()) {
            return 0;
        }
        this.basicVideoProfileHandler.checkFramerate();
        for (VideoProfileHandler additional : this.additionalVideoProfileHandlers) {
            additional.checkFramerate();
        }
        if (videoProfileHandlerPreferredForMotionDetection != null) {
            this.logger.debug("Using " + videoProfileHandlerPreferredForMotionDetection + " as preferred VideoProfile for hardware MotionDetection of " + this);
            videoProfileHandlerPreferredForMotionDetection.setHardwareMotionDetection(true);
        }
        long[] typeList = new long[]{9808L};
        Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, typeList);
        if (entities.length > 0) {
            HardwareMotionDetectionCnf[] motionDetectionList = new HardwareMotionDetectionCnf[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                Entity motionDetectionEntity = entities[i];
                motionDetectionList[i] = new HardwareMotionDetectionCnf();
                motionDetectionList[i].init(motionDetectionEntity);
            }
            try {
                this.hardwareMotionDetection = HardwareMotionDetection.getInstance(this, motionDetectionList);
            }
            catch (SeeTecException se) {
                this.logger.error("Creating [HardwareMotionDetection] failed for " + this + " with error: " + se.getErrorCode());
                return se.getErrorCode();
            }
        }
        List<Entity> genericEventTriggerEntities = this.getGenericEventTriggerEntities();
        boolean atLeastOneEnabled = false;
        ArrayList<GenericEventTriggerCnf> genericEventTriggerCnfs = new ArrayList<GenericEventTriggerCnf>();
        for (Entity genericEventTriggerEntity : genericEventTriggerEntities) {
            if (genericEventTriggerEntity.isEnabled().booleanValue()) {
                atLeastOneEnabled = true;
            }
            try {
                genericEventTriggerCnfs.add(new GenericEventTriggerCnf(genericEventTriggerEntity));
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Generic event trigger could not be parsed: " + genericEventTriggerEntity);
            }
        }
        if (!genericEventTriggerCnfs.isEmpty() && atLeastOneEnabled) {
            try {
                this.genericEventTriggerHandler = this.createNewGenericEventTriggerHandler();
                errorCode = this.genericEventTriggerHandler.init(this.device, genericEventTriggerCnfs);
                if (errorCode != 0) {
                    this.logger.error("GenericEventTriggerHandler for " + this + " could not be initalized");
                    return errorCode;
                }
            }
            catch (Exception exception) {
                this.logger.error("Creating [GenericEventTriggerHandler] failed for " + this, (Throwable)exception);
            }
        }
        typeList = new long[]{9809L};
        Entity[] tamperingEntities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, typeList);
        if (tamperingEntities.length > 0) {
            this.tamperingCnf = new TamperingCnf();
            this.tamperingCnf.init(tamperingEntities[0]);
            this.detectionTimes.put("tampering", Long.MIN_VALUE);
        }
        typeList = new long[]{9810L};
        Entity[] videoLossEntities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, typeList);
        if (videoLossEntities.length > 0) {
            this.videoLossCnf = new VideoLossCnf();
            this.videoLossCnf.init(videoLossEntities[0]);
            this.detectionTimes.put("videoloss", Long.MIN_VALUE);
        }
        String api = this.device.getDeviceCnf().getAPI();
        String host = this.device.getDeviceCnf().getHardwareHost();
        int port = this.device.getDeviceCnf().getHardwarePort();
        String usr = this.device.getDeviceCnf().getUser();
        String pwd = this.device.getDeviceCnf().getPassword();
        this.presetList = presetList;
        if (this.getVideoProfileHandler(null) != null && this.getVideoProfileHandler(null).getVideoSourceParameter() != null && (this.externalID = this.getVideoProfileHandler(null).getVideoSourceParameter().getExternalPtzId()) > 0L) {
            this.logger.info("Use external device '" + this.externalID + "' to control device " + this);
            this.cameraControl = this.getExternalControl(this.externalID);
        } else {
            this.cameraControl = this.createCameraControl(this.getEntity().getEntityType());
            if (this.cameraControl == null) {
                this.logger.error("Could not create a CameraControl for " + this);
            }
        }
        if (this.externalID <= 0L && this.cameraControl != null && (errorCode = this.cameraControl.init(this, api, host, port, usr, pwd, presetList)) != 0) {
            this.logger.error("Creating " + this.cameraControl + " failed with error [" + errorCode + "] :-(");
        }
        if (this.getVideoProfileHandler(null) != null && this.getVideoProfileHandler(null).getVideoSourceParameter() != null && this.getVideoProfileHandler(null).getVideoSourceParameter().isAudioOutEnabled()) {
            this.audioOutServer = this.createAudioOutServer();
        }
        this.configurationChanged();
        return 0;
    }

    protected List<Entity> getGenericEventTriggerEntities() {
        long[] typeList = new long[]{9813L};
        Entity[] srcEntities = this.device.getAllEntities(new long[]{this.getEntityID()}, typeList);
        Entity[] devEntities = this.device.getAllEntities(new long[]{this.getDevice().getDeviceID()}, typeList);
        ArrayList<Entity> genericEventTriggerEntities = new ArrayList<Entity>();
        genericEventTriggerEntities.addAll(Arrays.asList(srcEntities));
        genericEventTriggerEntities.addAll(Arrays.asList(devEntities));
        return genericEventTriggerEntities;
    }

    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }

    public Vector<PresetCnf> getPresetList() {
        return this.presetList;
    }

    private CameraControl getExternalControl(long externalID) {
        CameraControl externalCameraControl = null;
        for (Device singleDevice : this.getCore().getDeviceLifeCycleInformation().getDeviceList()) {
            LiveCameraSrv liveCameraSrv = null;
            if (singleDevice == null || (liveCameraSrv = (LiveCameraSrv)singleDevice.getService(externalID)) == null) continue;
            externalCameraControl = liveCameraSrv.getCameraControl();
            break;
        }
        if (externalCameraControl == null) {
            this.logger.warn("External device '" + externalID + "' not existing or not started yet to control " + this);
        }
        return externalCameraControl;
    }

    public void evaluateVideoLoss() {
        if (this.videoLossCnf != null) {
            try {
                long timestamp = this.detectionTimes.get("videoloss");
                if (timestamp + this.videoLossCnf.getDeadTime() < System.currentTimeMillis()) {
                    this.detectionTimes.put("videoloss", System.currentTimeMillis());
                    this.logger.info("VideoLoss trigger will be fired for " + this);
                    this.getCore().sendApplicationEvent(this.videoLossCnf.getEntityID());
                }
            }
            catch (ConfigurationException e) {
                this.logger.warn("Something's wrong while reading deadtime from config. " + e.getMessage() + " for " + this);
            }
        }
    }

    public void evaluateTampering() {
        if (this.tamperingCnf != null) {
            try {
                long timestamp = this.detectionTimes.get("tampering");
                if (timestamp + this.tamperingCnf.getDeadTime() < System.currentTimeMillis()) {
                    this.detectionTimes.put("tampering", System.currentTimeMillis());
                    this.logger.info("Tampering trigger will be fired for " + this);
                    this.getCore().sendApplicationEvent(this.tamperingCnf.getEntityID());
                }
            }
            catch (ConfigurationException e) {
                this.logger.warn("Something's wrong while reading deadtime from config. " + e.getMessage() + " for " + this);
            }
        }
    }

    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.hardwareMotionDetection != null) {
            errorCode = this.hardwareMotionDetection.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + (Object)((Object)this.hardwareMotionDetection) + " failed with error [" + errorCode);
            }
            this.hardwareMotionDetection = null;
        }
        if (this.genericEventTriggerHandler != null) {
            errorCode = this.genericEventTriggerHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Discarding " + this.genericEventTriggerHandler + " failed with error [" + errorCode + "] for " + this);
            }
            this.genericEventTriggerHandler = null;
        }
        if (this.audioOutServer != null) {
            this.audioOutServer.shutdown();
        }
        if (this.metadataReader != null) {
            this.metadataReader.shutdown();
        }
        if (this.basicVideoProfileHandler != null) {
            errorCode = this.basicVideoProfileHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + this.basicVideoProfileHandler + "] failed with error [" + errorCode);
            }
            this.basicVideoProfileHandler = null;
        }
        if (this.additionalVideoProfileHandlers != null && this.additionalVideoProfileHandlers.length > 0) {
            for (VideoProfileHandler additionalVideoProfileHandler1 : this.additionalVideoProfileHandlers) {
                if (additionalVideoProfileHandler1 == null || (errorCode = additionalVideoProfileHandler1.shutdown()) == 0) continue;
                this.logger.warn("Shutting down [" + additionalVideoProfileHandler1 + "] failed with error [" + errorCode);
            }
            this.additionalVideoProfileHandlers = null;
        }
        if (this.externalID <= 0L && this.cameraControl != null) {
            errorCode = this.cameraControl.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + this.cameraControl + "] failed with error [" + errorCode);
            }
            this.cameraControl = null;
        }
        return super.shutdown();
    }

    @Override
    public int checkVideoProfileHandler() {
        if (this.basicVideoProfileHandler != null && !this.basicVideoProfileHandler.isShutdown() && !this.streamDisabled) {
            return this.basicVideoProfileHandler.checkNetwork();
        }
        return 0;
    }

    public int checkReachability(VideoProfileHandler listener) {
        int port;
        String host;
        NetworkParameter networkParameter;
        int errorCode = 0;
        int defaultTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
        try {
            networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            host = networkParameter.getHost();
            port = networkParameter.useHTTPS() ? networkParameter.getSSLport() : networkParameter.getHTTPport();
        }
        catch (ConfigurationException ce) {
            this.logger.warn("Error reading host/port information on " + this);
            return -20000;
        }
        networkParameter.checkAndSetTimeout(defaultTimeout);
        int socketTimeout = networkParameter.getSoTimeout();
        if (listener == null) {
            this.logger.warn("Listener is null on " + this);
            return -20002;
        }
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), socketTimeout);
            this.device.sendResolvedConnectionEvent(this.getEntityID());
        }
        catch (Throwable ex) {
            this.logger.warn("Timeout connecting to socket after [" + socketTimeout + " ms] for " + this);
            if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                this.notifyForNetworkFailure();
            }
            if (System.currentTimeMillis() > this.lastCannotCreateDeviceEventSent + 5000L) {
                this.lastCannotCreateDeviceEventSent = System.currentTimeMillis();
                listener.sendStatusService(-21656);
            }
            this.logger.error("Exception [" + ex.getMessage() + " for " + this);
        }
        return errorCode;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        return this.getCameraControl().addPresetPosition(result, presetID, presetName);
    }

    @Override
    public int removePresetPosition(String presetName) {
        this.currentPresetPosition = "";
        return this.getCameraControl().removePresetPosition(presetName);
    }

    @Override
    public ArrayOfCameraPreset getCameraPresetsList() {
        return this.getCameraControl().getPresetsFromCamera();
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        return this.getCameraControl().addCameraPresets(presets);
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        this.currentPresetPosition = "";
        return this.getCameraControl().setAbsolutePTZ(sender, pan, tilt, zoom);
    }

    @Override
    public int setAbsolutePt(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt) {
        this.currentPresetPosition = "";
        return this.getCameraControl().setAbsolutePt(sender, pan, tilt);
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        this.currentPresetPosition = "";
        return this.getCameraControl().setAbsoluteZ(sender, zoom);
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        Integer zoom = zoomSpeed;
        Integer pan = panSpeed;
        Integer tilt = tiltSpeed;
        if (pan != null && pan != 0 || tilt != null && tilt != 0 || zoom != null && zoom != 0) {
            this.currentPresetPosition = "";
        }
        if (this.prevValuesForContinuesPTZ[0] != null && pan != null && this.prevValuesForContinuesPTZ[0].intValue() == pan.intValue()) {
            pan = null;
        } else {
            this.prevValuesForContinuesPTZ[0] = pan;
        }
        if (this.prevValuesForContinuesPTZ[1] != null && tilt != null && this.prevValuesForContinuesPTZ[1].intValue() == tilt.intValue()) {
            tilt = null;
        } else {
            this.prevValuesForContinuesPTZ[1] = tilt;
        }
        if (this.prevValuesForContinuesPTZ[2] != null && zoom != null && this.prevValuesForContinuesPTZ[2].intValue() == zoom.intValue()) {
            zoom = null;
        } else {
            this.prevValuesForContinuesPTZ[2] = zoom;
        }
        if (this.getCameraControl() == null) {
            return 0;
        }
        return this.getCameraControl().setContinuousPTZ(pan, tilt, zoom);
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        this.currentPresetPosition = "";
        return this.getCameraControl().setCenterPT(xPosition, yPosition, resolution);
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        return this.getCameraControl().setZoomArea(xPosition, yPosition, width, heigth, resolution);
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return this.getCameraControl().setAbsoluteIris(value);
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.getCameraControl() == null) {
            return 0;
        }
        return this.getCameraControl().setContinuousIris(value);
    }

    @Override
    public int setAutoIris(Boolean active) {
        return this.getCameraControl().setAutoIris(active);
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return this.getCameraControl().setAbsoluteFocus(value);
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (this.getCameraControl() == null) {
            return 0;
        }
        return this.getCameraControl().setContinuousFocus(value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        return this.getCameraControl().setAutoFocus(active);
    }

    @Override
    public int setZeroLux(Boolean active) {
        return this.getCameraControl().setZeroLux(active);
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return this.getCameraControl().setAutoZeroLux(active);
    }

    @Override
    public int setHomePosition() {
        this.currentPresetPosition = "";
        return this.getCameraControl().setHomePosition();
    }

    @Override
    public int setPresetPosition(String preset) {
        this.currentPresetPosition = preset.trim();
        return this.getCameraControl().setPresetPosition(preset);
    }

    @Override
    public void checkFramerate() {
        if (this.basicVideoProfileHandler != null) {
            this.basicVideoProfileHandler.checkFramerate();
        }
        if (this.additionalVideoProfileHandlers != null && this.additionalVideoProfileHandlers.length > 0) {
            for (VideoProfileHandler additionalVideoProfileHandler : this.additionalVideoProfileHandlers) {
                if (additionalVideoProfileHandler == null) continue;
                additionalVideoProfileHandler.checkFramerate();
            }
        }
    }

    @Override
    public void changeVideoMode() {
        if (this.basicVideoProfileHandler != null) {
            try {
                int[] standardImgageSize = this.getVideoSourceCnf().getImageSize("Standard");
                int standardCompression = this.getVideoSourceCnf().getQuality("Standard");
                int standardIFrameDistance = this.getVideoSourceCnf().getIFrameDistance("Standard");
                int standardBandwidth = this.getVideoSourceCnf().getBandWidth("Standard");
                int[] alarmImgSize = this.getVideoSourceCnf().getImageSize("Alarm");
                int alarmCompression = this.getVideoSourceCnf().getQuality("Alarm");
                int alarmIFrameDistance = this.getVideoSourceCnf().getIFrameDistance("Alarm");
                int alarmBandwidth = this.getVideoSourceCnf().getBandWidth("Alarm");
                boolean bandwidthControlChanged = false;
                try {
                    VideoSourceParameter standardVideoSourceParameter = this.basicVideoProfileHandler.getVideoSourceParameter("standard");
                    VideoSourceParameter alarmVideoSourceParameter = this.basicVideoProfileHandler.getVideoSourceParameter("alarm");
                    bandwidthControlChanged = standardVideoSourceParameter.getBandwidthControl() != alarmVideoSourceParameter.getBandwidthControl();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (standardImgageSize[0] != alarmImgSize[0] || standardImgageSize[1] != alarmImgSize[1] || standardCompression != alarmCompression || standardIFrameDistance != alarmIFrameDistance || standardBandwidth != alarmBandwidth || bandwidthControlChanged) {
                    if (this.getEntityType() >= 210200L && this.getEntityType() <= 210299L) {
                        this.basicVideoProfileHandler.optionalMobotixDiscarding((MobotixCameraSrv)this, this.getVideoMode());
                    }
                    if (this.getEntityType() >= 211400L && this.getEntityType() <= 211499L) {
                        this.basicVideoProfileHandler.optionalLumeneraDiscarding((LumeneraCameraSrv)this, this.getVideoMode());
                    }
                    if (this.getDevice().getDeviceType() >= 202500L && this.getDevice().getDeviceType() <= 202599L && this.getDevice().getDeviceType() >= 203400L && this.getDevice().getDeviceType() <= 203400L && standardImgageSize[0] == alarmImgSize[0] && standardImgageSize[1] == alarmImgSize[1]) {
                        this.basicVideoProfileHandler.optionalSantecDiscarding((SantecCameraSrv)this, this.getVideoMode());
                    }
                    if (!(this.isMPEG() || this.getEntityType() != 211902L && this.getEntityType() != 211911L && this.getEntityType() != 211903L && this.getEntityType() != 211912L && this.getEntityType() != 211905L && this.getEntityType() != 211914L && this.getEntityType() != 211906L && this.getEntityType() != 211915L)) {
                        this.basicVideoProfileHandler.optionalSanyoHD1Discarding((SanyoCameraSrv)this, this.getVideoMode());
                    }
                    if (!(this.isMPEG() || this.getEntityType() != 211904L && this.getEntityType() != 211913L && this.getEntityType() != 211907L && this.getEntityType() != 211916L && this.getEntityType() != 211908L && this.getEntityType() != 211917L && this.getEntityType() != 211909L && this.getEntityType() != 211918L && this.getEntityType() != 211910L && this.getEntityType() != 211919L)) {
                        this.basicVideoProfileHandler.optionalSanyoHD2Discarding((SanyoCameraSrv)this, this.getVideoMode());
                    }
                    if (!this.isMPEG() && this.getEntityType() == 212200L) {
                        this.basicVideoProfileHandler.optionalSiemensDiscarding((SiemensCameraSrv)this, this.getVideoMode());
                    }
                    if (!(this.isMPEG() || this.getEntityType() != 210526L && this.getEntityType() != 210532L && this.getEntityType() != 210533L && this.getEntityType() != 210527L && this.getEntityType() != 210528L && this.getEntityType() != 210529L && this.getEntityType() != 210534L && this.getEntityType() != 210530L && this.getEntityType() != 210531L && this.getEntityType() != 210537L && this.getEntityType() != 210538L && this.getEntityType() != 210539L && this.getEntityType() != 210540L && this.getEntityType() != 210541L && this.getEntityType() != 210536L && this.getDevice().getDeviceType() != 200630L && this.getDevice().getDeviceType() != 200631L && this.getDevice().getDeviceType() != 200632L && this.getDevice().getDeviceType() != 200633L)) {
                        this.basicVideoProfileHandler.optionalSonyDiscarding((SonyCameraSrv)this, this.getVideoMode());
                    }
                    if (!this.isMPEG() && (this.getEntityType() >= 201800L && this.getEntityType() < 201900L || this.getDevice().getDeviceType() >= 201800L && this.getDevice().getDeviceType() == 201900L)) {
                        this.basicVideoProfileHandler.optionalSamsungDiscarding((SamsungCameraSrv)this, this.getVideoMode());
                    }
                    if (!this.isMPEG() && this.getDevice().getDeviceType() == 202800L) {
                        this.basicVideoProfileHandler.optionalAcutvistaDiscarding((AcutvistaCameraSrv)this, this.getVideoMode());
                    }
                    if (!this.isMPEG() && (this.getEntityType() >= 210400L && this.getEntityType() <= 210499L || this.getEntityType() >= 214400L && this.getEntityType() <= 214499L)) {
                        this.basicVideoProfileHandler.optionalHikvisionDiscarding((HikvisionCameraSrv)this, this.getVideoMode());
                    }
                    this.basicVideoProfileHandler.discard();
                }
                this.checkFramerate();
            }
            catch (ConfigurationException cex) {
                throw new RuntimeException("Invalid configuration: " + cex.getMessage());
            }
        } else {
            this.checkFramerate();
        }
    }

    public abstract CameraControl createCameraControl(Long var1);

    protected AudioOutServer createAudioOutServer() {
        this.logger.info("Creating !!NO!! Audio Out Server for " + this);
        return null;
    }

    protected MetadataReader createMetadataReader(QognifyMetadataManagerRepository qognifyMetadataManagerRepository) {
        return null;
    }

    @Override
    public String getPresetName(long presetID) throws ConfigurationException {
        return this.cameraControl != null ? this.getCameraControl().getPresetName(presetID) : null;
    }

    public abstract VideoSourceClient createVideoSourceClient(Core var1, VideoProfileHandler var2) throws SeeTecException;

    @Override
    public final boolean isMPEG() throws ConfigurationException {
        return this.getVideoSourceCnf().getMediaCodec() == Codec.MPEG4 || this.getVideoSourceCnf().getMediaCodec() == Codec.H264 || this.getVideoSourceCnf().getMediaCodec() == Codec.H265;
    }

    @Override
    public ContentStreamIntf createContentStream(int openingMode) {
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down");
        }
        if (openingMode == 0 || openingMode == 1) {
            return new ContentStream();
        }
        throw new RuntimeException("Opening mode [" + openingMode + " for " + this + " not supported for " + this);
    }

    public boolean limitJpegFramerateToVideoProfile() {
        long[] rangeOfSanyoVideoSources = new long[]{211900L, 211999L};
        return this.getEntityType() >= rangeOfSanyoVideoSources[0] && this.getEntityType() <= rangeOfSanyoVideoSources[1] && this.additionalVideoProfileHandlers != null && this.additionalVideoProfileHandlers.length > 0;
    }

    public VideoProfileHandler getBasicVideoProfileHandler() {
        return this.basicVideoProfileHandler;
    }

    public VideoProfileHandler[] getAdditionalVideoProfileHandler() {
        return this.additionalVideoProfileHandlers;
    }

    public final CameraControl getCameraControl() {
        if (this.cameraControl == null && this.externalID > 0L) {
            this.cameraControl = this.getExternalControl(this.externalID);
        }
        return this.cameraControl;
    }

    public final String getCurrentPresetPosition() {
        return this.currentPresetPosition;
    }

    public AudioOutServer getAudioOutServer() {
        return this.audioOutServer;
    }

    @Override
    public final VideoProfileHandler getVideoProfileHandler(Integer classification) {
        try {
            if (classification == null) {
                if (this.additionalVideoProfileHandlers != null) {
                    for (VideoProfileHandler additionalVideoProfileHandler1 : this.additionalVideoProfileHandlers) {
                        if (additionalVideoProfileHandler1 == null || !additionalVideoProfileHandler1.isStandardVideoProfile()) continue;
                        return additionalVideoProfileHandler1;
                    }
                }
                return this.basicVideoProfileHandler;
            }
            if (this.additionalVideoProfileHandlers != null) {
                for (VideoProfileHandler additionalVideoProfileHandler1 : this.additionalVideoProfileHandlers) {
                    Integer[] lClassifications;
                    if (additionalVideoProfileHandler1 == null) {
                        this.logger.warn("Not all VideoProfileHandler initialized yet, so delivering the BasicVideoProfile for " + this);
                        return this.basicVideoProfileHandler;
                    }
                    for (Integer lClassification : lClassifications = additionalVideoProfileHandler1.getVideoSourceParameter().getClassifications()) {
                        if (lClassification.intValue() != classification.intValue()) continue;
                        this.logger.info((Object)additionalVideoProfileHandler1);
                        this.logger.info("Transmission.ID=" + additionalVideoProfileHandler1.getVideoSourceParameter().getTransmissionID());
                        this.logger.info("Transmission.Name=" + additionalVideoProfileHandler1.getVideoSourceParameter().getTransmissionName());
                        return additionalVideoProfileHandler1;
                    }
                }
                for (VideoProfileHandler additionalVideoProfileHandler1 : this.additionalVideoProfileHandlers) {
                    if (!additionalVideoProfileHandler1.isStandardVideoProfile()) continue;
                    return additionalVideoProfileHandler1;
                }
            }
            return this.basicVideoProfileHandler;
        }
        catch (Throwable throwable) {
            this.logger.error("Problem while trying to get VideoProfileHandler for " + this, throwable);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public abstract ContentFrame getJpegSnapshot(Integer[] var1) throws SeeTecException;

    @Override
    public String toString() {
        return "[" + super.toString() + "]";
    }

    @Override
    public void configurationChanged() {
        MetadataManager metadataManager = this.device.getCore().getQognifyMetadataManagerRepository().getMetadataManager();
        if (metadataManager != null) {
            if (this.metadataReader != null) {
                this.metadataReader.shutdown();
            }
            try {
                if (this.getVideoSourceCnf().getEnableMetadata()) {
                    this.logger.info("Enable metadata for " + this.getEntity());
                    new MetadataReaderStartThread(this).start();
                } else {
                    this.logger.info("Disable metadata for " + this.getEntity());
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    protected MetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    private class MetadataReaderStartThread
    extends Thread {
        private final LiveCameraSrv caller;

        MetadataReaderStartThread(LiveCameraSrv caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            LiveCameraSrv.this.metadataReader = LiveCameraSrv.this.createMetadataReader(LiveCameraSrv.this.device.getCore().getQognifyMetadataManagerRepository());
            LiveCameraSrv.this.device.getCore().getQognifyMetadataManagerRepository().addListener(this.caller);
        }
    }
}

