/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandler;
import de.seetec.v5.re.cm.device.shared.EdgeStorageImportTask;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EdgeStorageImportWatchdog
extends Thread {
    private static long EDGE_STORAGE_RETRY_PERIOD = TimeUnit.SECONDS.toMillis(10L);
    private boolean running = false;
    private final EdgeStorageHandler handler;
    private final Core core;
    private final Map<Long, PlaybackVideoSourceClient> playbackClients;
    private final Map<Long, List<TimeRange>> unfinishedGaps;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public EdgeStorageImportWatchdog(EdgeStorageHandler handler, Core core) {
        this.handler = handler;
        this.core = core;
        this.playbackClients = new HashMap<Long, PlaybackVideoSourceClient>();
        this.unfinishedGaps = new HashMap<Long, List<TimeRange>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdgeStorageTasks(List<TimeRange> unfinishedGap, PlaybackVideoSourceClient playbackVideoSourceClient, Long videoSourceId) {
        EdgeStorageImportWatchdog edgeStorageImportWatchdog = this;
        synchronized (edgeStorageImportWatchdog) {
            unfinishedGap.forEach(timeRange -> this.addEdgeStorageTask((TimeRange)timeRange, playbackVideoSourceClient, videoSourceId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEdgeStorageTask(TimeRange unfinishedGap, PlaybackVideoSourceClient playbackVideoSourceClient, Long videoSourceId) {
        if (!this.areInputParamsValid(unfinishedGap, playbackVideoSourceClient, videoSourceId)) {
            return;
        }
        EdgeStorageImportWatchdog edgeStorageImportWatchdog = this;
        synchronized (edgeStorageImportWatchdog) {
            this.playbackClients.put(videoSourceId, playbackVideoSourceClient);
            this.unfinishedGaps.putIfAbsent(videoSourceId, new ArrayList());
            List<TimeRange> gaps = this.unfinishedGaps.get(videoSourceId);
            if (!gaps.contains(unfinishedGap)) {
                this.unfinishedGaps.get(videoSourceId).add(unfinishedGap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning()) {
            HashSet<Long> keySet = new HashSet<Long>(this.playbackClients.keySet());
            for (Long videoSourceId : keySet) {
                List<TimeRange> fillableGaps;
                long[] minMaxTimestampFromList;
                List<TimeRange> recordingInfosFromDevice;
                this.logger.info("Retrying edge storage import for '" + videoSourceId + "' video source.");
                Integer status = this.core.getEntityStatus(videoSourceId);
                if (status == null) continue;
                PlaybackVideoSourceClient playbackClient = this.playbackClients.get(videoSourceId);
                if (playbackClient.isShutdown() || !this.core.getEntityByID(videoSourceId).isEnabled().booleanValue()) {
                    this.stopPeriodicRetryFor(videoSourceId);
                    continue;
                }
                if (status != 0 || (recordingInfosFromDevice = playbackClient.getRecordingInfosFromDevice((minMaxTimestampFromList = EdgeStorageHandler.getMinMaxTimestampFromList(this.unfinishedGaps.get(videoSourceId)))[0], minMaxTimestampFromList[1])).isEmpty() && this.core.getEntityStatus(videoSourceId) != 0) continue;
                EdgeStorageImportWatchdog edgeStorageImportWatchdog = this;
                synchronized (edgeStorageImportWatchdog) {
                    List<TimeRange> gaps = this.unfinishedGaps.remove(videoSourceId);
                    playbackClient = this.playbackClients.remove(videoSourceId);
                    fillableGaps = EdgeStorageHandler.getOverlappingTimeRanges(recordingInfosFromDevice, gaps);
                    fillableGaps = this.clearTinyGaps(fillableGaps);
                }
                if (!fillableGaps.isEmpty()) {
                    try {
                        EdgeStorageImportTask task = new EdgeStorageImportTask(playbackClient, videoSourceId, this.core, this, this.handler);
                        task.setIsResumedImport(true);
                        task.setResumedGapsList(fillableGaps);
                        task.setPriority(1);
                        this.handler.addTask(task);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Error while creating new EdgeStorageImportTask! " + (Object)((Object)ex));
                    }
                    continue;
                }
                this.logger.warn("There are no gaps left to be filled for " + videoSourceId + " video source.");
                this.handler.importFinished(videoSourceId);
            }
            try {
                Thread.sleep(EDGE_STORAGE_RETRY_PERIOD);
            }
            catch (InterruptedException ex) {
                this.logger.error("Edge storage import watchdog thread was abruptly interupted. Shutting down.");
                this.shutdown();
            }
        }
    }

    @Override
    public synchronized void start() {
        this.running = true;
        super.start();
    }

    private void stopPeriodicRetryFor(Long videoSourceId) {
        this.logger.warn("Stopping periodic edge storage import retry for '" + videoSourceId + "'. Configuration changed or it was disabled.");
        this.remove(videoSourceId);
    }

    private void remove(Long videoSourceId) {
        this.playbackClients.remove(videoSourceId);
        this.unfinishedGaps.remove(videoSourceId);
        this.handler.importFinished(videoSourceId);
    }

    public List<TimeRange> clearTinyGaps(List<TimeRange> gaps) {
        ArrayList<TimeRange> clearedGaps = new ArrayList<TimeRange>();
        for (TimeRange gap : gaps) {
            if (Math.abs(gap.getEndTimestamp() - gap.getStartTimestamp()) >= TimeUnit.SECONDS.toMillis(2L)) {
                clearedGaps.add(gap);
                continue;
            }
            this.logger.warn("Removing leftover gap " + gap);
        }
        return clearedGaps;
    }

    public boolean isRunning() {
        return this.running;
    }

    public List<TimeRange> getTasks(Long videoSourceId) {
        return this.unfinishedGaps.getOrDefault(videoSourceId, new ArrayList());
    }

    private boolean areInputParamsValid(TimeRange unfinishedGap, PlaybackVideoSourceClient playbackVideoSourceClient, Long videoSourceId) {
        return unfinishedGap != null && playbackVideoSourceClient != null && videoSourceId != null;
    }

    public void setRetryPeriod(long milis) {
        EDGE_STORAGE_RETRY_PERIOD = milis;
    }

    public void shutdown() {
        this.running = false;
    }
}

