/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandler;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandlerIntf;
import de.seetec.v5.re.cm.device.shared.EdgeStorageImportWatchdog;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.cm.shared.sql.DataObjectEdgeStorageMarker;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.TimerangeCnf;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqGetWriteProtections;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.shared.timerange.TimeRangeList;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EdgeStorageImportTask
implements Runnable {
    private final PlaybackVideoSourceClient playbackVideoSourceClient;
    private final Long videoSourceId;
    private final Logger logger;
    private final Core core;
    private final EdgeStorageImportWatchdog watchdog;
    private final EdgeStorageHandlerIntf edgeStorageHandlerIntf;
    private int priority = Integer.MIN_VALUE;
    private boolean isResumedImport = false;
    private List<TimeRange> resumedGaps;
    private long markerAtStartOfFillGapsMode;

    public EdgeStorageImportTask(PlaybackVideoSourceClient playbackVideoSourceClient, Long videoSourceId, Core core, EdgeStorageImportWatchdog watchdog, EdgeStorageHandlerIntf edgeStorageHandlerIntf) throws SeeTecException {
        this.checkForNull(new Object[]{playbackVideoSourceClient, videoSourceId, core, watchdog, edgeStorageHandlerIntf});
        this.playbackVideoSourceClient = playbackVideoSourceClient;
        this.videoSourceId = videoSourceId;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.core = core;
        this.watchdog = watchdog;
        this.edgeStorageHandlerIntf = edgeStorageHandlerIntf;
    }

    @Override
    public void run() {
        if (this.isResumedImport) {
            this.handleResumeOldImport();
        } else {
            this.handleNewManualImport();
        }
    }

    private void handleNewManualImport() {
        List<Object> gapList = new ArrayList();
        if (this.playbackVideoSourceClient.getEdgeStorageMode() == EdgeStorageMode.GAP_FILLING) {
            gapList = this.handleFillGapsMode(false);
        } else if (this.playbackVideoSourceClient.getEdgeStorageMode() == EdgeStorageMode.IMPORT) {
            gapList = this.handleImportMode();
        }
        if (gapList.size() > 0) {
            this.fillGaps(gapList);
        } else {
            this.edgeStorageHandlerIntf.importFinished(this.videoSourceId);
        }
    }

    private void handleResumeOldImport() {
        if (this.resumedGaps != null && this.resumedGaps.size() > 0) {
            this.fillGaps(this.resumedGaps);
        }
    }

    private void fillGaps(List<TimeRange> gapList) {
        ArrayList<TimeRange> originalGapList = new ArrayList<TimeRange>();
        if (gapList == null) {
            return;
        }
        originalGapList.addAll(gapList);
        long startTimestamp = System.currentTimeMillis();
        ArrayList<TimeRange> unfinishedGaps = new ArrayList<TimeRange>();
        while (!gapList.isEmpty()) {
            if (this.playbackVideoSourceClient.isShutdown()) {
                String entityName = "";
                if (this.playbackVideoSourceClient.getVideoSrv() != null) {
                    entityName = this.playbackVideoSourceClient.getVideoSrv().getEntityName();
                }
                this.logger.info("EdgeStorageHandling: Gaps cannot be filled, because PlaybackVideoSourceClient " + entityName + " is shutdown");
                break;
            }
            TimeRange timeRange = gapList.remove(0);
            try {
                this.logger.info("EdgeStorageHandling: Try to fill gap [" + Tools.formateTimestamp(timeRange.getStartTimestamp()) + " to " + Tools.formateTimestamp(timeRange.getEndTimestamp()) + "] for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
                TimeRange filledGap = this.playbackVideoSourceClient.fillGap(timeRange.getStartTimestamp(), timeRange.getEndTimestamp(), timeRange.getNameOfTimerange());
                if (filledGap == null) {
                    throw new SeeTecException(-20001, "Could not fill gap ( " + new Date(timeRange.getStartTimestamp()) + " to " + new Date(timeRange.getEndTimestamp()) + " ) for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
                }
                if (filledGap.isSimilar(timeRange, 3000L)) {
                    this.onSuccessfulFilling(filledGap);
                    continue;
                }
                throw new SeeTecException(-20001, "Could not fill gap ( " + new Date(timeRange.getStartTimestamp()) + " to " + new Date(timeRange.getEndTimestamp()) + " ) for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
            }
            catch (SeeTecException seeTecException) {
                if (this.playbackVideoSourceClient.getTimeStampLastFrame() != Long.MAX_VALUE && timeRange.isSimilar(new TimeRange(this.playbackVideoSourceClient.getTimeStampFirstFrame(), this.playbackVideoSourceClient.getTimeStampLastFrame()), 3000L)) {
                    this.onSuccessfulFilling(new TimeRange(this.playbackVideoSourceClient.getTimeStampFirstFrame(), this.playbackVideoSourceClient.getTimeStampLastFrame()));
                    continue;
                }
                if (timeRange.getLength() <= TimeUnit.SECONDS.toMillis(3L)) continue;
                this.logger.error("EdgeStorageHandling: Gap could not be filled: (" + new Date(timeRange.getStartTimestamp()) + " to " + new Date(timeRange.getEndTimestamp()) + ") for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
                if (this.playbackVideoSourceClient.getTimeStampLastFrame() != Long.MAX_VALUE && timeRange.getStartTimestamp() < this.playbackVideoSourceClient.getTimeStampLastFrame()) {
                    this.logger.warn("Some frames were written to MDBWriter, adjusting timerange.");
                    timeRange = new TimeRange(this.playbackVideoSourceClient.getTimeStampLastFrame(), timeRange.getEndTimestamp(), timeRange.getNameOfTimerange());
                }
                this.logger.warn("Adding the gap (" + new Date(timeRange.getStartTimestamp()) + " to " + new Date(timeRange.getEndTimestamp()) + ") of " + this.playbackVideoSourceClient.getVideoSrv().getEntityName() + " to edge storage import watchdog for later retry.");
                unfinishedGaps.add(timeRange);
                this.playbackVideoSourceClient.resetLastWrittenFrameTimestamp();
            }
        }
        if (this.playbackVideoSourceClient.getEdgeStorageMode() == EdgeStorageMode.GAP_FILLING) {
            List<TimeRange> additionalGapsToFill;
            List<TimeRange> additionalGaps = this.handleFillGapsMode(true);
            if (!originalGapList.isEmpty()) {
                StringBuilder buffer = new StringBuilder("Original list of Gaps to be filled for ");
                buffer.append(this.playbackVideoSourceClient.getVideoSrv().getEntityName());
                buffer.append(":");
                for (TimeRange timeRange : originalGapList) {
                    buffer.append("\r\n\t\t");
                    buffer.append(timeRange);
                }
                this.logger.info(buffer.toString());
            }
            if (!additionalGaps.isEmpty()) {
                String logString = "Gaps that appeared while filling older gaps for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName() + ":";
                for (TimeRange timeRange : additionalGaps) {
                    logString = logString + "\r\n\t\t" + timeRange;
                }
                this.logger.info(logString);
            }
            if ((additionalGapsToFill = EdgeStorageHandler.removeOverlappingTimeRanges(originalGapList, additionalGaps)).size() > 0) {
                String logString = "Gaps that appeared while filling older gaps, with original gaps removed for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName() + ":";
                for (TimeRange timeRange : additionalGapsToFill) {
                    logString = logString + "\r\n\t\t" + timeRange;
                }
                this.logger.info(logString);
            }
            this.watchdog.addEdgeStorageTasks(additionalGapsToFill, this.playbackVideoSourceClient, this.videoSourceId);
        }
        if (unfinishedGaps.size() > 0) {
            String logString = "Unfinished Gaps that we'll retry to fill for " + this.playbackVideoSourceClient + ":";
            for (TimeRange timeRange : unfinishedGaps) {
                logString = logString + "\r\n\t\t" + timeRange;
            }
            this.logger.info(logString);
        }
        this.watchdog.addEdgeStorageTasks(unfinishedGaps, this.playbackVideoSourceClient, this.videoSourceId);
        long stopTimestamp = System.currentTimeMillis();
        if (this.watchdog.getTasks(this.videoSourceId).isEmpty()) {
            this.logger.info("EdgeStorageHandling: +++++ Checking for GAPS: COMPLETE +++++");
            this.logger.info("EdgeStorageHandling: +++++ Time needed: " + (stopTimestamp - startTimestamp) + " ms for " + this.playbackVideoSourceClient + " +++++");
            this.logSuccessfulImport();
            this.edgeStorageHandlerIntf.importFinished(this.videoSourceId);
            this.playbackVideoSourceClient.shutdown();
        } else {
            this.logger.warn("EdgeStorageHandling: Some gaps were not correctly imported for " + this.playbackVideoSourceClient.getVideoSrv().getContentName() + ", they were scheduled for later retry.");
            this.logInterruptedImport();
        }
    }

    private void onSuccessfulFilling(TimeRange filledGap) {
        this.logger.info("EdgeStorageHandling: Gap (" + new Date(filledGap.getStartTimestamp()) + " to " + new Date(filledGap.getEndTimestamp()) + ") filled successfully for " + this.playbackVideoSourceClient);
        this.sendGapFetchedEvent(this.videoSourceId, filledGap);
        if (this.playbackVideoSourceClient.isManualTrigger() && this.playbackVideoSourceClient.getEdgeStorageMode() == EdgeStorageMode.IMPORT) {
            this.logger.info("EdgeStorageHandling: Marker will be ignored for " + this.playbackVideoSourceClient);
        } else {
            DataObjectEdgeStorageMarker dataObjectEdgeStorageMarker = this.core.getSqlDatabaseHandler().getMarker(this.playbackVideoSourceClient.getVideoSrv().getEntityID());
            if (dataObjectEdgeStorageMarker != null && dataObjectEdgeStorageMarker.getTimestamp() != null && dataObjectEdgeStorageMarker.getTimestamp() < filledGap.getEndTimestamp()) {
                try {
                    this.core.getSqlDatabaseHandler().setMarker(new DataObjectEdgeStorageMarker(this.videoSourceId, filledGap.getEndTimestamp()));
                    this.logger.info("EdgeStorageHandling: Marker set to " + new Date(filledGap.getEndTimestamp()) + " for " + this.videoSourceId);
                }
                catch (SeeTecException seeTecException) {
                    this.logger.warn("EdgeStorageHandling: Could not set marker to " + new Date(filledGap.getEndTimestamp()) + " for " + this.videoSourceId);
                }
            } else {
                this.logger.warn("EdgeStorageHandling: Could not locate/set marker to " + new Date(filledGap.getEndTimestamp()) + " for " + this.videoSourceId);
            }
        }
    }

    private List<TimeRange> handleFillGapsMode(boolean ignoreMarker) {
        List<TimeRange> recordingGaps = new ArrayList<TimeRange>();
        VideoSrv videoSrv = this.playbackVideoSourceClient.getVideoSrv();
        try {
            TimeRangeList timeRangeList = this.getRecordingTimeRangeList();
            if (timeRangeList.size() > 1) {
                List gapTimeRanges = timeRangeList.getGaps();
                this.logger.info("EdgeStorageHandling: Found " + gapTimeRanges.size() + " gaps for " + this.playbackVideoSourceClient);
                long timeNow = System.currentTimeMillis();
                long calculatedStartOptionalTimeRange = this.calculateOptionalTimeRange(timeNow);
                long lastCheckMarker = this.checkMarker(calculatedStartOptionalTimeRange, timeNow);
                long marker = this.checkRecordingTimeLimit(videoSrv, lastCheckMarker);
                long limitForGapSearching = System.currentTimeMillis() - this.edgeStorageHandlerIntf.getLimitForGapSearching() * 1000L;
                marker = marker < limitForGapSearching ? marker : limitForGapSearching;
                this.logger.info("Looking for recordings from " + new Date(marker) + " for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
                if (ignoreMarker) {
                    recordingGaps = this.filterRecordingGaps(gapTimeRanges, this.markerAtStartOfFillGapsMode);
                } else {
                    this.markerAtStartOfFillGapsMode = marker;
                    recordingGaps = this.filterRecordingGaps(gapTimeRanges, marker);
                }
                this.logger.info("EdgeStorageHandling: Remaining gaps after filtering: " + recordingGaps.size() + " gaps for " + this.playbackVideoSourceClient);
            }
        }
        catch (Exception exception) {
            this.logger.warn("EdgeStorageHandling: Could not read RecordingInfos for " + this.playbackVideoSourceClient, (Throwable)exception);
        }
        if (recordingGaps.size() > 0) {
            recordingGaps = this.checkRecordingPeriod(recordingGaps);
            this.logger.info("EdgeStorageHandling: Remaining gaps after checking the recording period: " + recordingGaps.size() + " gaps for " + this.playbackVideoSourceClient);
            List<TimeRange> recordingInfosFromDevice = this.getRecordingInfosFromCamera(recordingGaps);
            recordingGaps = EdgeStorageHandler.getOverlappingTimeRanges(recordingInfosFromDevice, recordingGaps);
            this.logger.info("EdgeStorageHandling: Remaining gaps after checking for recordings on device: " + recordingGaps.size() + " gaps for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
            recordingGaps = EdgeStorageHandler.removeShortGaps(recordingGaps);
            this.logger.info("EdgeStorageHandling: Remaining gaps after removing gaps smaller then 1 second: " + recordingGaps.size() + " gaps for " + this.playbackVideoSourceClient.getVideoSrv().getEntityName());
            for (TimeRange timerange : recordingGaps) {
                this.logger.info("Timerange after filtering on device " + this.playbackVideoSourceClient.getVideoSrv().getEntityName() + ": " + timerange.toString());
            }
            this.logger.info("EdgeStorageHandling: Remaining gaps after checking for recordings on device: " + recordingGaps.size() + " gaps for " + this.playbackVideoSourceClient);
        }
        return recordingGaps;
    }

    private List<TimeRange> handleImportMode() {
        List<TimeRange> gaps = new ArrayList<TimeRange>();
        VideoSrv videoSrv = this.playbackVideoSourceClient.getVideoSrv();
        if (this.playbackVideoSourceClient.getStartTime() == null || this.playbackVideoSourceClient.getEndTime() == null) {
            this.logger.info("EdgeStorageHandling: No start and/or end time available for " + this.playbackVideoSourceClient);
            long timeNow = System.currentTimeMillis();
            long calculatedStartOptionalTimeRange = this.calculateOptionalTimeRange(timeNow);
            long lastCheckMarker = this.checkMarker(calculatedStartOptionalTimeRange, timeNow);
            this.playbackVideoSourceClient.setTimeRangeToSynchronize(lastCheckMarker, timeNow);
            this.logger.info("EdgeStorageHandling: New start/end time set (Start: " + new Date(lastCheckMarker) + " | End: " + new Date(timeNow) + ") for " + this.playbackVideoSourceClient);
        }
        if (this.playbackVideoSourceClient.getStartTime() != null && this.playbackVideoSourceClient.getEndTime() != null) {
            try {
                List<TimeRange> writeProtectedTiles = this.getWriteProtections(this.playbackVideoSourceClient.getStartTime(), this.playbackVideoSourceClient.getEndTime());
                if (writeProtectedTiles.size() > 0) {
                    this.logger.info("Found " + writeProtectedTiles.size() + " write protected tile(s) on MDS for " + this.playbackVideoSourceClient);
                    writeProtectedTiles.forEach(tile -> this.logger.info("Write protected tile [" + Core.getUniformFormattedDateTime((long)tile.getStartTimestamp()) + " | " + Core.getUniformFormattedDateTime((long)tile.getEndTimestamp()) + "]"));
                    List<TimeRange> unprotectedTimeRanges = this.calculateUnprotectedRecording(writeProtectedTiles);
                    unprotectedTimeRanges.forEach(tile -> this.logger.info("Unprotected tile [" + Core.getUniformFormattedDateTime((long)tile.getStartTimestamp()) + " | " + Core.getUniformFormattedDateTime((long)tile.getEndTimestamp()) + "]"));
                    gaps = unprotectedTimeRanges;
                } else {
                    gaps.add(new TimeRange(this.playbackVideoSourceClient.getStartTime().longValue(), this.playbackVideoSourceClient.getEndTime().longValue()));
                }
                List<TimeRange> recordingInfosFromDevice = this.getRecordingInfosFromCamera(gaps);
                gaps = EdgeStorageHandler.getOverlappingTimeRanges(recordingInfosFromDevice, gaps);
                for (TimeRange timeRange : gaps) {
                    this.logger.info("EdgeStorageHandling: trying to delete range from camera. Start: " + new Date(timeRange.getStartTimestamp()) + " End: " + new Date(timeRange.getEndTimestamp()));
                    videoSrv.removeRecording(timeRange.getStartTimestamp(), timeRange.getEndTimestamp(), videoSrv.getEntityID());
                }
                this.logger.info("EdgeStorageHandling: Remaining gaps after checking for recordings on device: " + gaps.size() + " gaps for " + this.playbackVideoSourceClient);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Full import not possible [" + seeTecException.getMessage() + "|" + seeTecException.getErrorCode() + "] for " + this.playbackVideoSourceClient);
            }
        } else {
            this.logger.error("No import possible. No start/end time given for " + this.playbackVideoSourceClient);
        }
        return gaps;
    }

    private TimeRangeList getRecordingTimeRangeList() {
        ReqGetRecordingInfos reqGetRecordingInfos = new ReqGetRecordingInfos(this.videoSourceId, Long.valueOf(-1L), Long.valueOf(-1L), Long.valueOf(-1L), Long.valueOf(-1L));
        reqGetRecordingInfos.setToken(this.core.getCayugaToken());
        VideoSrv videoSrv = this.playbackVideoSourceClient.getVideoSrv();
        TimeRangeInfoContainer timeRangeInfoContainer = videoSrv.getRecordingInfos(reqGetRecordingInfos, true, false);
        this.logger.info("EdgeStorageHandling: Got " + timeRangeInfoContainer.getTimeRangeList().size() + " recording infos for " + this.playbackVideoSourceClient + " - now check for gaps");
        return timeRangeInfoContainer.getTimeRangeList();
    }

    private List<TimeRange> getWriteProtections(long startTime, long endTime) throws SeeTecException {
        ReqGetWriteProtections reqGetWriteProtections = new ReqGetWriteProtections(this.videoSourceId, Long.valueOf(startTime), Long.valueOf(endTime));
        VideoSrv videoSrv = this.playbackVideoSourceClient.getVideoSrv();
        List<Long[]> writeProtectedTiles = videoSrv.getDefaultMdbWriteProtections(reqGetWriteProtections);
        ArrayList<TimeRange> timeRangeList = new ArrayList<TimeRange>();
        writeProtectedTiles.forEach(tile -> timeRangeList.add(new TimeRange(tile[0].longValue(), tile[1].longValue())));
        Collections.sort(timeRangeList);
        return timeRangeList;
    }

    private long calculateOptionalTimeRange(long timeNow) {
        long calculatedStartOptionalTimeRange = 0L;
        if (this.playbackVideoSourceClient.getEdgeStorageParameter().isUseOptionalTimeRange() && this.playbackVideoSourceClient.getEdgeStorageParameter().getOptionalTimeRange() > 0L) {
            calculatedStartOptionalTimeRange = timeNow - TimeUnit.MINUTES.toMillis(this.playbackVideoSourceClient.getEdgeStorageParameter().getOptionalTimeRange());
        }
        return calculatedStartOptionalTimeRange;
    }

    private long checkMarker(long calculatedStartOptionalTimeRange, long timeNow) {
        long lastCheckMarker = -1L;
        DataObjectEdgeStorageMarker dataObjectEdgeStorageMarker = this.core.getSqlDatabaseHandler().getMarker(this.videoSourceId);
        if (dataObjectEdgeStorageMarker != null && dataObjectEdgeStorageMarker.getTimestamp() != null) {
            lastCheckMarker = dataObjectEdgeStorageMarker.getTimestamp();
        }
        long l = lastCheckMarker = lastCheckMarker > timeNow ? 0L : lastCheckMarker;
        if (calculatedStartOptionalTimeRange > lastCheckMarker) {
            lastCheckMarker = calculatedStartOptionalTimeRange;
        }
        return lastCheckMarker;
    }

    private long checkRecordingTimeLimit(VideoSrv videoSrv, long lastCheckMarker) {
        long recordingMarker = -1L;
        try {
            long maxRecordingTime = videoSrv.getVideoSourceCnf().getMaxRecordingTime("Standard");
            recordingMarker = System.currentTimeMillis() - maxRecordingTime;
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("EdgeStorageHandling: Could not read MaxRecordingTime from configuration for " + this.playbackVideoSourceClient, (Throwable)configurationException);
        }
        this.logger.info("EdgeStorageHandling: Marker for maxRecordingTime: " + new Date(recordingMarker) + " for " + this.playbackVideoSourceClient);
        this.logger.info("EdgeStorageHandling: Marker for last check: " + new Date(lastCheckMarker) + " for " + this.playbackVideoSourceClient);
        long marker = lastCheckMarker > recordingMarker ? lastCheckMarker : recordingMarker;
        this.logger.info("EdgeStorageHandling: Remove all gaps before " + new Date(marker) + " for " + this.playbackVideoSourceClient);
        return marker;
    }

    private List<TimeRange> filterRecordingGaps(List<TimeRange> gapTimeRanges, long marker) {
        ArrayList<TimeRange> gaps = new ArrayList<TimeRange>();
        for (TimeRange gapTimeRange : gapTimeRanges) {
            if (gapTimeRange.getStartTimestamp() > marker) {
                gaps.add(gapTimeRange);
                continue;
            }
            if (gapTimeRange.getEndTimestamp() <= marker) continue;
            gaps.add(new TimeRange(marker, gapTimeRange.getEndTimestamp()));
        }
        return gaps;
    }

    private List<TimeRange> getRecordingInfosFromCamera(List<TimeRange> recordingGaps) {
        long[] startEndTimestamp = EdgeStorageHandler.getMinMaxTimestampFromList(recordingGaps);
        long startTimestamp = startEndTimestamp[0];
        long endTimestamp = startEndTimestamp[1];
        List<TimeRange> recordingInfosFromDevice = this.playbackVideoSourceClient.getRecordingInfosFromDevice(startTimestamp, endTimestamp);
        return recordingInfosFromDevice;
    }

    private List<TimeRange> calculateUnprotectedRecording(List<TimeRange> writeProtectedTiles) {
        ArrayList<TimeRange> unprotectedRecordings = new ArrayList<TimeRange>();
        long importStart = this.playbackVideoSourceClient.getStartTime();
        long importEnd = this.playbackVideoSourceClient.getEndTime();
        if (writeProtectedTiles == null || writeProtectedTiles.isEmpty()) {
            unprotectedRecordings.add(new TimeRange(importStart, importEnd));
        } else {
            for (TimeRange writeProtectedTile : writeProtectedTiles) {
                if (writeProtectedTile.getStartTimestamp() > importStart) {
                    unprotectedRecordings.add(new TimeRange(importStart, writeProtectedTile.getStartTimestamp() - 1L));
                    importStart = writeProtectedTile.getEndTimestamp() + 1L;
                    continue;
                }
                if (writeProtectedTile.getEndTimestamp() >= importEnd) continue;
                importStart = writeProtectedTile.getEndTimestamp() + 1L;
            }
            long lastWriteProtectedTileEnd = writeProtectedTiles.get(writeProtectedTiles.size() - 1).getEndTimestamp();
            if (importEnd > lastWriteProtectedTileEnd) {
                unprotectedRecordings.add(new TimeRange(lastWriteProtectedTileEnd + 1L, importEnd));
            }
        }
        return unprotectedRecordings;
    }

    private List<TimeRange> checkRecordingPeriod(List<TimeRange> gapList) {
        try {
            long entityId = this.playbackVideoSourceClient.getVideoSrv().getVideoSourceCnf().getTimeRangeID("Standard");
            if (entityId >= 0L) {
                ArrayList<TimeRange> newGapList = new ArrayList<TimeRange>();
                TimerangeCnf timerangeCnf = new TimerangeCnf(this.core.getWorkCenterCalendarRepository());
                timerangeCnf.init(this.core.getEntityByID(entityId).getConfiguration());
                for (TimeRange timeRange : gapList) {
                    long position = timeRange.getStartTimestamp();
                    while (position < timeRange.getEndTimestamp()) {
                        boolean needToFill;
                        long expirationTime = timerangeCnf.getExpirationTime(position);
                        if (position + Math.abs(expirationTime) > timeRange.getEndTimestamp()) {
                            if (expirationTime >= 0L) {
                                newGapList.add(new TimeRange(position, timeRange.getEndTimestamp()));
                            }
                            position = timeRange.getEndTimestamp();
                            continue;
                        }
                        boolean bl = needToFill = expirationTime >= 0L;
                        if (needToFill) {
                            newGapList.add(new TimeRange(position, position + expirationTime));
                        }
                        position += Math.abs(expirationTime);
                    }
                }
                return newGapList;
            }
            this.logger.info("No recording period found for " + this.playbackVideoSourceClient);
        }
        catch (ConfigurationException | SeeTecException exception) {
            this.logger.warn("Error checking checkRecordingPeriod for " + this.playbackVideoSourceClient, exception);
        }
        return gapList;
    }

    private void logImport(EventType type, String subject, String body, String errorMsg) {
        try {
            this.core.sendEvent(type, this.videoSourceId, -1L, null);
            this.core.sendLoggingEvent(type, this.videoSourceId, 0, subject, body);
        }
        catch (NullPointerException ex) {
            this.logger.error(errorMsg + ex.getMessage());
        }
    }

    private void logSuccessfulImport() {
        this.logImport(EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_SUCCESSFUL, "Edge storage import success", "Edge storage import from device '" + this.playbackVideoSourceClient.getVideoSrv().getContentName() + "' was successful.", "Failed to log Edge storage import success for '" + this.videoSourceId + "'. ");
    }

    private void logInterruptedImport() {
        this.logImport(EventType.CM_EVENTTYPE_EDGESTORAGE_IMPORT_INTERRUPTED, "Edge storage import interruption", "Edge storage import from device '" + this.playbackVideoSourceClient.getVideoSrv().getContentName() + "' was interrupted. The system will retry once the device comes back online.", "Failed to log Edge storage import interruption for '" + this.videoSourceId + "'. ");
    }

    private void sendGapFetchedEvent(long videoSourceId, TimeRange filledGap) {
        this.core.sendEvent(EventType.MDB_EVENTTYPE_EDGE_STORAGE_RECORDING_FETCHED, videoSourceId, -1L, ("<StartTimestamp>" + filledGap.getStartTimestamp() + "</StartTimestamp><EndTimestamp>" + filledGap.getEndTimestamp() + "</EndTimestamp>").getBytes());
    }

    public void setIsResumedImport(boolean isResumedImport) {
        this.isResumedImport = isResumedImport;
    }

    public void setResumedGapsList(List<TimeRange> gaps) {
        this.resumedGaps = gaps;
    }

    public Long getVideoSourceId() {
        return this.videoSourceId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public PlaybackVideoSourceClient getPlaybackClient() {
        return this.playbackVideoSourceClient;
    }

    public List<TimeRange> getResumedGaps() {
        return new ArrayList<TimeRange>(this.resumedGaps);
    }

    private void checkForNull(Object ... values) throws SeeTecException {
        for (Object value : values) {
            if (value != null) continue;
            throw new SeeTecException(-20002, "EdgeStorageImportTask parameters cannot be null!");
        }
    }
}

