/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.factory.DeviceServicePack;
import de.seetec.v5.re.cm.device.shared.factory.RangeDeviceMap;
import de.seetec.v5.re.cm.device.shared.factory.packs.ARHPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ATSPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AbusPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ActiPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AcutvistaPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AdvantechPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AllCam23xxPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AmericanDynamicsPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AperPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ArchiveDevicePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ArecontPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AudioDevicePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AvigilonPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.AxisPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.BaslerPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.BoschPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.CBCPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.Canon2Pack;
import de.seetec.v5.re.cm.device.shared.factory.packs.CanonPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ConvisionPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.ConvisionSmartPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.DLinkPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.DahuaPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.DallmeierPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.DigigramAudioPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.DynacolorPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.EtrovisionPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.FlirPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GenericNetworkPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GenericOnvifPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GenericPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GrandEyePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GrundigPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.GrundigSmartPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.HanwhaPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.HikvisionPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.IQinVisionPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.IdsPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.InterlogixPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.IqlePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.JPEGEmulatorDevicePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.JVCPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.LGPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.LumeneraPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.MobotixPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.NorbainPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.NorthernPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.Panasonic2Pack;
import de.seetec.v5.re.cm.device.shared.factory.packs.PanasonicPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.PelcoPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.Qognify2Pack;
import de.seetec.v5.re.cm.device.shared.factory.packs.QognifyPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SamsungPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SantecPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SanyoPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SchneiderITCInterfacePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SchneiderPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SiemensPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SimpleGenericOnvifPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SiquraPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SistoreOnvifPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SonyPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.SpcPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.TDSIPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.TKHPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.VanderbiltPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.VideoFileDevicePack;
import de.seetec.v5.re.cm.device.shared.factory.packs.VivotekPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.VivotekSmartPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.WAndTPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.WBoxPack;
import de.seetec.v5.re.cm.device.shared.factory.packs.WagoPack;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.OpenProblemWrapper;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.Logger;

public class DeviceFactory {
    private static RangeDeviceMap devicePacks;
    private static DeviceFactory instance;

    private DeviceFactory() {
    }

    private static void initFactory() {
        devicePacks = new RangeDeviceMap();
        devicePacks.add(new ARHPack());
        devicePacks.add(new ATSPack());
        devicePacks.add(new AbusPack());
        devicePacks.add(new ActiPack());
        devicePacks.add(new AcutvistaPack());
        devicePacks.add(new AdvantechPack());
        devicePacks.add(new AllCam23xxPack());
        devicePacks.add(new AmericanDynamicsPack());
        devicePacks.add(new AperPack());
        devicePacks.add(new ArchiveDevicePack());
        devicePacks.add(new ArecontPack());
        devicePacks.add(new AudioDevicePack());
        devicePacks.add(new AvigilonPack());
        devicePacks.add(new AxisPack());
        devicePacks.add(new BaslerPack());
        devicePacks.add(new BoschPack());
        devicePacks.add(new CBCPack());
        devicePacks.add(new Canon2Pack());
        devicePacks.add(new CanonPack());
        devicePacks.add(new ConvisionPack());
        devicePacks.add(new ConvisionSmartPack());
        devicePacks.add(new DLinkPack());
        devicePacks.add(new DahuaPack());
        devicePacks.add(new DallmeierPack());
        devicePacks.add(new DigigramAudioPack());
        devicePacks.add(new DynacolorPack());
        devicePacks.add(new EtrovisionPack());
        devicePacks.add(new FlirPack());
        devicePacks.add(new GenericNetworkPack());
        devicePacks.add(new GenericOnvifPack());
        devicePacks.add(new GenericPack());
        devicePacks.add(new GrandEyePack());
        devicePacks.add(new GrundigPack());
        devicePacks.add(new GrundigSmartPack());
        devicePacks.add(new HikvisionPack());
        devicePacks.add(new HanwhaPack());
        devicePacks.add(new IQinVisionPack());
        devicePacks.add(new IdsPack());
        devicePacks.add(new InterlogixPack());
        devicePacks.add(new IqlePack());
        devicePacks.add(new JPEGEmulatorDevicePack());
        devicePacks.add(new JVCPack());
        devicePacks.add(new LGPack());
        devicePacks.add(new LumeneraPack());
        devicePacks.add(new MobotixPack());
        devicePacks.add(new NorbainPack());
        devicePacks.add(new NorthernPack());
        devicePacks.add(new Panasonic2Pack());
        devicePacks.add(new PanasonicPack());
        devicePacks.add(new PelcoPack());
        devicePacks.add(new QognifyPack());
        devicePacks.add(new Qognify2Pack());
        devicePacks.add(new SamsungPack());
        devicePacks.add(new SantecPack());
        devicePacks.add(new SanyoPack());
        devicePacks.add(new SchneiderITCInterfacePack());
        devicePacks.add(new SchneiderPack());
        devicePacks.add(new SiemensPack());
        devicePacks.add(new SimpleGenericOnvifPack());
        devicePacks.add(new SiquraPack());
        devicePacks.add(new SistoreOnvifPack());
        devicePacks.add(new SonyPack());
        devicePacks.add(new SpcPack());
        devicePacks.add(new TDSIPack());
        devicePacks.add(new TKHPack());
        devicePacks.add(new VivotekPack());
        devicePacks.add(new VivotekSmartPack());
        devicePacks.add(new WAndTPack());
        devicePacks.add(new WBoxPack());
        devicePacks.add(new WagoPack());
        devicePacks.add(new VanderbiltPack());
        devicePacks.add(new VideoFileDevicePack());
    }

    public static DeviceFactory getInstance() {
        if (instance == null) {
            instance = new DeviceFactory();
        }
        return instance;
    }

    public Device getDevice(Core core, Logger logger, long entityID, String entityName, long entityType) throws SeeTecException {
        Device device = null;
        try {
            DeviceServicePack devicePack = this.getUninitializedDevice(core, logger, entityID, entityName, entityType);
            device = devicePack.getDevice();
            this.initializeDevice(device, devicePack.getService(), core, logger, entityID, entityName, entityType);
        }
        catch (Exception exception) {
            if (exception instanceof SeeTecException) {
                throw (SeeTecException)((Object)exception);
            }
            throw new SeeTecException(-21015, "Creating device type [" + entityType + "] of [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "] failed: " + exception.getMessage());
        }
        return device;
    }

    protected void initializeDevice(Device device, Class<? extends VideoSrv> srvToStart, Core core, Logger logger, long entityID, String entityName, long entityType) throws SeeTecException, ConfigurationException {
        int errorCode = 0;
        errorCode = device.init(core, entityID);
        if (errorCode != 0) {
            device.shutdown();
            core.sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, entityID);
            core.sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, entityID, errorCode, "Cannot create device [" + entityID + "]/[" + entityName + "]", "Cannot create device [" + entityID + "]/[" + entityName + "] at [" + Basic.getLocalHostName() + "/" + core.getDmCnfMgr().getServerAddress() + "] because of error [" + errorCode + "].");
            logger.error("Initializing device [" + entityName + "]/[" + entityID + "] failed with error [" + errorCode + "] :-(");
            throw new SeeTecException(errorCode, "Initializing device [" + entityName + "]/[" + entityID + "] failed with error [" + errorCode + "] :-(");
        }
        OpenProblemWrapper openProblemWrapper = core.getSqlDatabaseHandler().getOpenProblem(entityID, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM);
        if (openProblemWrapper != null) {
            core.sendConnectivityProblemResolvedEvent(openProblemWrapper.getSourceId(), openProblemWrapper.getTimestamp(), "Can create device [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "]", "Can create device [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "] at [" + Basic.getLocalHostName() + "/" + core.getDmCnfMgr().getServerAddress() + "].");
        }
        if ((errorCode = device.initLiveDevice(srvToStart)) != 0) {
            logger.error("Error while initializing LifeDevice. Error: " + errorCode + " for " + device);
        }
    }

    protected DeviceServicePack getUninitializedDevice(Core core, Logger logger, long entityID, String entityName, long entityType) throws SeeTecException, ConfigurationException {
        DeviceServicePack pack = devicePacks.get(entityType);
        if (pack == null) {
            core.sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM);
            core.sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, entityID, -21658, "Device type [" + entityType + "] is unknown", "Device type [" + entityType + "] of [" + entityID + "]/[" + entityName + "] at [" + Basic.getLocalHostName() + "/" + core.getDmCnfMgr().getServerAddress() + "] is unknown.");
            logger.error("Device type [" + entityType + "] of [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "] is unknown");
            throw new SeeTecException(-21658, "Device type [" + entityType + "] of [" + Basic.longToFormattedString((long)entityID) + "]/[" + entityName + "] is unknown");
        }
        OpenProblemWrapper openProblemWrapper = core.getSqlDatabaseHandler().getOpenProblem(entityID, EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM);
        if (openProblemWrapper != null) {
            core.sendConnectivityProblemResolvedEvent(openProblemWrapper.getSourceId(), openProblemWrapper.getTimestamp(), "Device type [" + entityType + "] is known", "Device type [" + entityType + "] of [" + entityID + "]/[" + entityName + "] at [" + Basic.getLocalHostName() + "/" + core.getDmCnfMgr().getServerAddress() + "] is known.");
        }
        return pack;
    }

    static {
        DeviceFactory.initFactory();
    }
}

