/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDevice;
import de.seetec.v5.re.cm.device.shared.DevSRPCConnector;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.shared.srpc.ReqSetState;
import de.seetec.v5.re.cm.shared.srpc.ReqTriggerAction;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.TriggerActionHandler;
import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class DeviceClientRequestHandler
extends AbstractSrpcHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.DeviceClientRequestHandler";
    private Device device = null;
    private DevSRPCConnector srpcConnector = null;
    private final long tsStartup = System.currentTimeMillis();
    private final Socket socket;
    private String clientHost = null;
    private Integer clientPort = null;

    public DeviceClientRequestHandler(Device device, Socket socket) throws SeeTecException {
        this.device = device;
        if (this.device == null) {
            throw new SeeTecException(-21601, "Device is null");
        }
        this.socket = socket;
        if (this.socket == null) {
            throw new SeeTecException(-21601, "Socket is null");
        }
    }

    public int init() {
        int errorCode;
        this.clientHost = this.socket.getInetAddress().getHostAddress();
        this.clientPort = this.socket.getPort();
        try {
            this.srpcConnector = new DevSRPCConnector();
            errorCode = this.srpcConnector.init(this, this.socket);
            if (errorCode != 0) {
                this.logger.error("Initializing new connector with socket [" + this.socket + "] failed with error [" + errorCode + "]");
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Creating new connector with socket [" + this.socket + "] failed", (Throwable)ex);
            return -21604;
        }
        errorCode = this.device.registerClientRequestHandler(this);
        if (errorCode != 0) {
            this.logger.error("Registering client failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        int errorCode = this.device.deregisterClientRequestHandler(this);
        if (errorCode != 0) {
            this.logger.warn("Deregistering client failed with error [" + errorCode + "]");
        }
        if (this.thread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + (Object)((Object)this) + " didn't finished in time :-(");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        if (this.srpcConnector != null) {
            errorCode = this.srpcConnector.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + (Object)((Object)this.srpcConnector) + "] failed with error [" + errorCode + "] :-(");
            }
            this.srpcConnector = null;
        }
        errorCode = super.shutdown();
        this.logger.info("Shutdown done for " + (Object)((Object)this));
        return errorCode;
    }

    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down " + (Object)((Object)this) + " ...");
        this.shutdown();
    }

    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
        long nanoStart = System.nanoTime();
        try {
            while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - nanoStart) <= 2L || !this.isShutdown() && (this.device == null || !this.device.isShutdown())) {
                SrpcMessage req;
                if (tsNextStillAliveMsg < System.currentTimeMillis()) {
                    tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
                    this.logger.info("Thread " + (Object)((Object)this) + " has an uptime of [" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "] :-)");
                }
                if (null == (req = this.getNextReq())) continue;
                RequestHandlerCallback rhc = this.getCallback(req.getId());
                switch (Methods.valueOf((int)req.getHash())) {
                    case ENT_FUNCTION_TRIGGER_ACTION: {
                        this.execTriggerAction(req, rhc);
                        break;
                    }
                    case ENT_FUNCTION_STOP_DEVICE: {
                        this.execStopDevice(req, rhc);
                        break;
                    }
                    case CM_SRPC_REQ_SETSTATE: {
                        this.execSetState(req, rhc);
                        break;
                    }
                    case CM_SRPC_REQ_RESTOREALLALERTS: {
                        this.execRestoreAllAlerts(req, rhc);
                        break;
                    }
                }
                this.doDelayBreakedByShutdown(CLASS_NAME, 25L);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        int errorCode = this.shutdown();
        if (errorCode != 0) {
            this.logger.error("[shutdown] failed with error [" + errorCode + "]");
        }
    }

    protected final void execTriggerAction(SrpcMessage req, RequestHandlerCallback callback) {
        try {
            int errorCode = 0;
            de.seetec.v5.shared.net.srpc.general.ReqTriggerAction request = de.seetec.v5.shared.net.srpc.general.ReqTriggerAction.parseGObject((GObject)req.getPayload());
            try {
                TriggerActionHandler triggerActionHandler = new TriggerActionHandler(request, (RECore)this.device.getCore());
                triggerActionHandler.init();
            }
            catch (SeeTecException seeTecException) {
                this.logger.warn("Problems initializing TriggerActionHandler for " + (Object)((Object)this), (Throwable)seeTecException);
                errorCode = seeTecException.getErrorCode();
            }
            catch (Throwable ex) {
                this.logger.warn("Problems initializing TriggerActionHandler for " + (Object)((Object)this), ex);
                errorCode = -20001;
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            callback.onRequestHandled(req, rsp);
            return;
        }
        catch (Exception errorCode) {
            try {
                ReqTriggerAction request = ReqTriggerAction.parseGObject(req.getPayload());
                int errorCode2 = this.device.triggerAction(request.getActionID(), request.getAlarmScriptID(), request.getAlarmInstanceID(), request.getAlarmTimerange(), request.getGenericData(), -1L, -1L);
                if (errorCode2 != 0) {
                    this.logger.warn("Triggering action failed with error [" + errorCode2 + "] :-(");
                }
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode2);
                callback.onRequestHandled(req, rsp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private void execSetState(SrpcMessage req, RequestHandlerCallback callback) {
        ReqSetState reqSetState = ReqSetState.parseGObject(req.getPayload());
        SpcDevice spcDevice = (SpcDevice)this.device;
        spcDevice.setState(reqSetState);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        callback.onRequestHandled(req, rsp);
    }

    private void execRestoreAllAlerts(SrpcMessage req, RequestHandlerCallback callback) {
        SpcDevice spcDevice = (SpcDevice)this.device;
        spcDevice.restoreAllAlarms();
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        callback.onRequestHandled(req, rsp);
    }

    private void execStopDevice(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = this.device.stopDevice();
        if (errorCode != 0) {
            this.logger.warn("Stopping " + this.device + " failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.DeviceClientRequestHandler@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.clientHost + ":" + this.clientPort + "]]";
    }
}

