/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CameraControlLock {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.VideoSrv.CameraControlLock";
    private String userName = "<unknown>";
    private long clientId = -1L;
    private long timeoutTime = -1L;
    private boolean clientHasLock = false;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public boolean isControlGranted(long clientID, long timeout) {
        if (this.clientId == clientID) {
            this.clientHasLock = true;
            this.timeoutTime = System.currentTimeMillis() + timeout;
            return true;
        }
        this.clientHasLock = false;
        return !this.islocked() || this.isTimedOut();
    }

    public void lock(String userName, long clientID, long timeout) {
        this.userName = userName;
        this.clientId = clientID;
        this.timeoutTime = System.currentTimeMillis() + timeout;
    }

    public void unlock() {
        this.userName = "<unknown>";
        this.clientId = -1L;
        this.timeoutTime = -1L;
    }

    public void unlock(VideoServiceClientRequestHandler videoServiceClientRequestHandler) {
        if (this.clientId != videoServiceClientRequestHandler.getClientID()) {
            this.logger.error("Lock for camera control of " + this + " not held by [" + videoServiceClientRequestHandler + "]");
        }
        this.unlock();
    }

    public boolean isTimedOut() {
        return this.timeoutTime > 0L && this.timeoutTime < System.currentTimeMillis();
    }

    public boolean islocked() {
        return this.timeoutTime > System.currentTimeMillis();
    }

    public String getUsername() {
        return this.userName;
    }

    public long getClientId() {
        return this.clientId;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public boolean getClientHasLock() {
        return this.clientHasLock;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.VideoSrv.CameraControlLock@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Username=[" + this.userName + "], ClientID=[" + Basic.longToFormattedString((long)this.clientId) + "], Timeout=[" + new Date(this.timeoutTime) + "]";
    }
}

