/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private OutputStream out;
    private int buffer;
    private int bitCount;

    public BitOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.flush();
            this.out.close();
            this.out = null;
        }
    }

    private void flush() throws IOException {
        if (this.bitCount > 0) {
            this.out.write((byte)this.buffer);
            this.bitCount = 0;
            this.buffer = 0;
        }
    }

    public synchronized void skipBits(int biteToSkip) throws IOException {
        for (int i = 0; i < biteToSkip; ++i) {
            this.writeBit(0);
        }
    }

    public synchronized void writeBit(int bit) throws IOException {
        if (this.out == null) {
            throw new IOException("Already closed");
        }
        if (bit != 0 && bit != 1) {
            throw new IOException(bit + " is not a bit");
        }
        this.buffer |= bit << 7 - this.bitCount;
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.flush();
        }
    }
}

