/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.sip;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.sip.SIPMessage;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SIPMessageHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.sip.SIPMessageHandler";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Core core = null;
    private Thread thread = null;
    private int listenerPort = -1;
    private Socket socket = null;
    private ServerSocket serverSocket = null;
    private Hashtable<String, Vector<SIPMessage>> htCalls = null;

    public int init(Core core, int nListenerPort) {
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.listenerPort = nListenerPort;
        if (this.listenerPort <= 0) {
            return -21601;
        }
        this.htCalls = new Hashtable();
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
        return 0;
    }

    public int processMessage(SIPMessage sipMessage) {
        long eventType = sipMessage.getEventType();
        String caller = sipMessage.getCaller();
        String callee = sipMessage.getCallee();
        long time = sipMessage.getTime();
        byte[] recording = sipMessage.getRecording();
        Vector<SIPMessage> callMessages = this.htCalls.get(caller);
        this.logger.info("Processing " + sipMessage + " with historie " + callMessages + " ...");
        if (callMessages == null) {
            callMessages = new Vector();
            this.htCalls.put(caller, callMessages);
        }
        if (eventType == 551L) {
            if (callMessages.size() > 0) {
                this.logger.warn("Remove zombie call messages " + callMessages + " ...");
                callMessages.removeAllElements();
            }
            callMessages.addElement(sipMessage);
            this.core.delegateSipEvent(eventType, caller, callee, time, -1L, recording);
        } else if (eventType == 552L) {
            if (callMessages.size() != 1 || callMessages.firstElement().getEventType() != 551L) {
                this.logger.warn("Invalid historie " + callMessages + " for " + sipMessage + ", so discarding all!");
                callMessages.removeAllElements();
            } else {
                callMessages.addElement(sipMessage);
            }
        } else if (eventType == 553L) {
            if (callMessages.size() != 2 || callMessages.elementAt(0).getEventType() != 551L || callMessages.elementAt(1).getEventType() != 552L) {
                this.logger.warn("Invalid historie " + callMessages + " for " + sipMessage + ", so discarding all!");
                callMessages.removeAllElements();
            } else {
                long tsStart = callMessages.elementAt(1).getTime();
                long tsEnd = sipMessage.getTime();
                callMessages.addElement(sipMessage);
                this.core.delegateSipEvent(eventType, caller, callee, tsStart, tsEnd, recording);
            }
        } else if (eventType == 554L) {
            if (callMessages.size() != 3 || callMessages.elementAt(0).getEventType() != 551L || callMessages.elementAt(1).getEventType() != 552L || callMessages.elementAt(2).getEventType() != 553L) {
                for (int i = 0; i < callMessages.size(); ++i) {
                    this.logger.warn("((SIPMessage) vCallMessages.elementAt( " + i + " )).getEventType()=" + callMessages.elementAt(i).getEventType());
                }
                this.logger.warn("Invalid historie " + callMessages + " for " + sipMessage + ", so discarding all!");
                callMessages.removeAllElements();
            } else {
                long tsStart = callMessages.elementAt(1).getTime();
                long tsEnd = callMessages.elementAt(2).getTime();
                callMessages.removeAllElements();
                this.core.delegateSipEvent(eventType, caller, callee, tsStart, tsEnd, recording);
            }
        }
        this.logger.info("DONE!");
        return 0;
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.serverSocket != null) {
            this.logger.info("Discarding " + this.serverSocket + " ...");
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        if (this.thread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            try {
                this.serverSocket = new ServerSocket(this.listenerPort);
            }
            catch (IOException ioex) {
                this.logger.error("Trouble with server socket [" + this.listenerPort + "] for " + this, (Throwable)ioex);
                return;
            }
            while (!this.isShutdown(CLASS_NAME)) {
                try {
                    this.socket = this.serverSocket.accept();
                }
                catch (SocketException sex) {
                    if (this.isShutdown(CLASS_NAME)) {
                        this.logger.info(this + " is shutting down ...");
                        break;
                    }
                    this.logger.warn((Object)sex, (Throwable)sex);
                    continue;
                }
                MessageHandler messageHandler = new MessageHandler();
                messageHandler.init(this.socket);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.other.sip.SIPMessageHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ListenerPort=[" + this.listenerPort + "]]";
    }

    private class MessageHandler
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.seetec.MessageHandler";
        private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
        private Thread thread = null;
        private Socket socket = null;

        MessageHandler() {
        }

        public int init(Socket socket) {
            this.socket = socket;
            if (this.socket == null) {
                this.logger.error("Argument [Socket] is null");
                return -21601;
            }
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }

        public final boolean isShutdown() {
            return this.isShutdown(CLASS_NAME);
        }

        public int shutdown() {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            this.logger.info("Starting shutdown of " + this + " ...");
            if (this.thread != null) {
                long timeout = System.currentTimeMillis() + 30000L;
                while (!this.isRunFinished(CLASS_NAME)) {
                    if (System.currentTimeMillis() > timeout) {
                        this.logger.warn("Thread of " + this + " didn't finished in time");
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.thread = null;
            }
            return 0;
        }

        @Override
        public void run() {
            super.setRunFinished(CLASS_NAME, false);
            this.logger.info("Incoming SIP message from " + this.socket + " ...");
            try {
                byte[] message = null;
                try {
                    int length;
                    InputStream is = this.socket.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((length = is.read(buffer)) > 0) {
                        baos.write(buffer, 0, length);
                    }
                    message = baos.toByteArray();
                }
                catch (SocketTimeoutException ste) {
                    this.logger.warn((Object)ste, (Throwable)ste);
                }
                try {
                    if (this.socket != null) {
                        this.socket.close();
                        this.socket = null;
                    }
                }
                catch (Throwable ste) {
                    // empty catch block
                }
                SIPMessage sipMessage = new SIPMessage();
                int errorCode = sipMessage.init(message);
                if (errorCode != 0) {
                    this.logger.error("Parsing SIP message failed with error [" + errorCode + "]");
                }
                SIPMessageHandler.this.processMessage(sipMessage);
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
            }
            this.logger.info("Thread of this " + this + " finished");
            super.setRunFinished(CLASS_NAME, true);
            this.shutdown();
        }

        public String toString() {
            String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + "]";
        }
    }
}

