/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.sip;

import de.seetec.v5.shared.Basic;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

class SIPMessage {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Document xmlMessage = null;
    private long eventType = -1L;
    private String caller = null;
    private String callee = null;
    private byte[] recording = null;
    private long time = -1L;

    public int init(byte[] message) {
        if (message == null) {
            this.logger.error("Argument [message] is null");
            return -21601;
        }
        int boh = Basic.byteArrayToInt4((byte[])message, (int)0, (int)4);
        int xmlLength = Basic.byteArrayToInt4((byte[])message, (int)4, (int)4);
        int dataLength = Basic.byteArrayToInt4((byte[])message, (int)8, (int)4);
        if (-1599029040L != (long)boh || xmlLength < 16 || xmlLength > 1024 || dataLength > 0x1000000) {
            StringBuffer sb = new StringBuffer(1024);
            for (int i = 0; i < 256 && i < message.length; ++i) {
                sb.append('[');
                sb.append(Integer.toHexString(message[i] & 0xFF));
                sb.append(']');
            }
            if (message.length > 256) {
                sb.append("...");
            }
            this.logger.error("Invalid Audio Message: " + sb);
        }
        try {
            byte[] xml = new byte[xmlLength];
            System.arraycopy(message, 12, xml, 0, xmlLength);
            this.logger.info("SIPMessage: [" + new String(xml) + "]");
            ByteArrayInputStream bais = new ByteArrayInputStream(message, 12, xmlLength);
            this.xmlMessage = new SAXBuilder().build((InputStream)bais);
            try {
                Element eEventType = this.xmlMessage.getRootElement().getChild("EventType");
                this.eventType = Long.parseLong(eEventType.getText().trim());
                Element eCaller = this.xmlMessage.getRootElement().getChild("Caller");
                this.caller = eCaller.getText().trim();
                Element eCallee = this.xmlMessage.getRootElement().getChild("Callee");
                this.callee = eCallee.getText().trim();
                Element eTime = this.xmlMessage.getRootElement().getChild("Time");
                this.time = Long.parseLong(eTime.getText().trim());
            }
            catch (Exception ex) {
                this.logger.error("Paring SIP message failed:");
                this.logger.info(new String(xml));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Parsing configuration failed");
            return -21600;
        }
        if (dataLength > 0) {
            this.recording = new byte[dataLength];
            System.arraycopy(message, 12 + xmlLength, this.recording, 0, dataLength);
        } else {
            this.recording = new byte[0];
        }
        return 0;
    }

    public long getEventType() {
        return this.eventType;
    }

    public String getCaller() {
        return this.caller;
    }

    public String getCallee() {
        return this.callee;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] getRecording() {
        return this.recording;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", EventType=[" + this.eventType + "], Caller=[" + this.caller + "], Callee=[" + this.callee + "], Time=[" + Basic.longToFormattedString((long)this.time) + "], Recording=[" + Basic.longToFormattedString((long)this.recording.length) + " B]]";
    }
}

