/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.sip;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.sip.AudioSrv;
import de.seetec.v5.re.cm.device.other.sip.AudioSrvSRPCConnector;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.communication.DatabaseReaderImpl;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.srpc.ReqLogin;
import de.seetec.v5.re.cm.shared.srpc.ReqOpenContentStream;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmTimerange;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqReadNextFrame;
import de.seetec.v5.re.shared.srpc.ReqReadPreviousFrame;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.RspGetAlarmScenarioOccurrencies;
import de.seetec.v5.re.shared.srpc.RspGetAlarmTimerange;
import de.seetec.v5.re.shared.srpc.RspGetRecordingInfos;
import de.seetec.v5.re.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.shared.timerange.TimeRangeList;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.srpc.general.ReqTriggerAction;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class AudioSrvClientRequestHandler
extends AbstractSrpcHandler
implements MDBAccessorIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.sip.AudioSrvClientRequestHandler";
    private AudioSrv audioSrv = null;
    private AudioSrvSRPCConnector srpcConnector = null;
    private final long tsStartup = System.currentTimeMillis();
    private String userName = "<unknown>";
    private long clientID = -1L;
    private int openingMode = -1;
    private ContentStreamIntf contentStream = null;
    private DatabaseReaderImpl databaseReader = null;
    private InetAddress host = null;
    private String clientHost = null;
    private TimeRangeInfoContainer recordingInfoContainer;

    public int init(AudioSrv audioSrv, Socket socket) {
        int errorCode;
        this.audioSrv = audioSrv;
        if (this.audioSrv == null) {
            return -21601;
        }
        this.logger.info("New client from " + socket + " to " + this + " ...");
        this.host = socket.getInetAddress();
        this.clientHost = this.host.getHostAddress();
        try {
            this.srpcConnector = new AudioSrvSRPCConnector();
            errorCode = this.srpcConnector.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing new connector with socket [" + socket + "] failed with error [" + errorCode + "]");
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Creating new connector with socket [" + socket + "] failed");
            return -21604;
        }
        errorCode = this.audioSrv.register(this);
        if (errorCode != 0) {
            this.logger.error("Registering client failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        return this.shutdown(30000L);
    }

    protected int shutdown(long timeoutPeriod) {
        long duration;
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Starting shutdown of " + this + " ...");
        if (this.contentStream != null) {
            try {
                errorCode = this.contentStream.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down " + this.contentStream + " failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            this.contentStream = null;
        }
        long tsStart = System.currentTimeMillis();
        errorCode = this.audioSrv.deregister(this);
        if (errorCode != 0) {
            this.logger.warn("Deregistering client failed with error [" + errorCode + "]");
        }
        if ((duration = System.currentTimeMillis() - tsStart) > 9999L) {
            this.logger.warn("Deregistering " + this.audioSrv + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        if (this.thread != null) {
            tsStart = System.currentTimeMillis();
            long timeout = System.currentTimeMillis() + timeoutPeriod;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
            duration = System.currentTimeMillis() - tsStart;
            if (duration > 9999L) {
                this.logger.warn("Terminating thread of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
        }
        if (this.srpcConnector != null) {
            tsStart = System.currentTimeMillis();
            errorCode = this.srpcConnector.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + (Object)((Object)this.srpcConnector) + "] failed with error [" + errorCode + "]");
            }
            if ((duration = System.currentTimeMillis() - tsStart) > 9999L) {
                this.logger.warn("Discarding " + (Object)((Object)this.srpcConnector) + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
            this.srpcConnector = null;
        }
        if (this.databaseReader != null) {
            tsStart = System.currentTimeMillis();
            errorCode = this.databaseReader.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + this.databaseReader + "] failed with error [" + errorCode + "]");
            }
            if ((duration = System.currentTimeMillis() - tsStart) > 9999L) {
                this.logger.warn("Discarding " + this.databaseReader + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
            this.databaseReader = null;
        }
        errorCode = super.shutdown();
        return errorCode;
    }

    public void onError(int srpcErrorCode) {
        this.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
        long tsNextBlockingCheck = System.currentTimeMillis() + 60000L;
        try {
            block21: {
                SrpcMessage req;
                block17: while (true) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tsNextStillAliveMsg < System.currentTimeMillis()) {
                        tsNextStillAliveMsg = System.currentTimeMillis() + 3600000L;
                        this.logger.info(this + " has an uptime of [" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "] :-)");
                    }
                    if (tsNextBlockingCheck < System.currentTimeMillis()) {
                        tsNextBlockingCheck = System.currentTimeMillis() + 60000L;
                    }
                    if (this.audioSrv == null || this.audioSrv.isShutdown()) break block21;
                    req = null;
                    try {
                        req = this.getNextReq(1, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (null == req) continue;
                    RequestHandlerCallback callback = this.getCallback(req.getId());
                    switch (Methods.valueOf((int)req.getHash())) {
                        case MD_REQ_LOGIN: {
                            this.execLogin(req, callback);
                            continue block17;
                        }
                        case ENT_FUNCTION_TRIGGER_ACTION: {
                            this.execTriggerAction(req, callback);
                            continue block17;
                        }
                        case CM_SRPC_REQ_OPENCONTENTSTREAM: {
                            this.execOpenContentStream(req, callback);
                            continue block17;
                        }
                        case CM_SRPC_REQ_SETSTREAMPARAMETER: {
                            this.execSetStreamParameter(req, callback);
                            continue block17;
                        }
                        case RE_SRPC_REQ_READNEXTFRAME: {
                            this.execReadNextFrame(req, callback);
                            continue block17;
                        }
                        case RE_SRPC_REQ_READPREVIOUSFRAME: {
                            this.execReadPreviousFrame(req, callback);
                            continue block17;
                        }
                        case RE_SRPC_REQ_GETALARMTIMERANGE: {
                            this.execGetAlarmTimerange(req, callback);
                            continue block17;
                        }
                        case RE_SRPC_REQ_GETRECORDINGINFOS: {
                            this.execGetRecordingInfos(req, callback);
                            continue block17;
                        }
                        case RE_SRPC_REQ_GETALARMSCENARIOOCCURRENCIES: {
                            this.execGetAlarmScenarioOccurrencies(req, callback);
                            continue block17;
                        }
                    }
                    break;
                }
                throw new RuntimeException("INTERNAL ERROR: Request [" + req.getMethodName() + "] unknown");
            }
            this.logger.warn("Associated video service " + this.audioSrv + " is already shutting down! So, leaving thread loop now! this=" + this);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        int errorCode = this.shutdown();
        if (errorCode != 0) {
            this.logger.error("[shutdown] failed with error [" + errorCode + "]");
        }
    }

    private void execLogin(SrpcMessage req, RequestHandlerCallback callback) {
        ReqLogin request = ReqLogin.parseGObject(req.getPayload());
        this.userName = request.getUserName();
        this.clientID = request.getClientID() != null ? request.getClientID() : -1L;
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)0));
        rsp.setError(0);
        callback.onRequestHandled(req, rsp);
    }

    private void execTriggerAction(SrpcMessage req, RequestHandlerCallback callback) {
        ReqTriggerAction request = ReqTriggerAction.parseGObject((GObject)req.getPayload());
        if (this.audioSrv == null || this.audioSrv.isShutdown()) {
            this.logger.warn("Associated video service " + this.audioSrv + " is already shutting down");
            return;
        }
        int errorCode = this.audioSrv.triggerAction(request.getActionID(), request.getAlarmScriptID(), request.getAlarmInstanceID(), request.getAlarmTimerange(), request.getGenericData());
        if (errorCode != 0) {
            this.logger.warn("Triggering action failed with error [" + errorCode + "]");
        }
    }

    private void execOpenContentStream(SrpcMessage req, RequestHandlerCallback callback) {
        int activeThreads;
        ReqOpenContentStream request = ReqOpenContentStream.parseGObject(req.getPayload());
        int errorCode = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Executing " + request + "/[" + Basic.longToFormattedString((long)System.currentTimeMillis()) + "] ...");
        }
        if ((activeThreads = Thread.activeCount()) >= Core.getThreadLimit()) {
            this.logger.error("There are now [" + activeThreads + "] threads active. " + this + "] will be discarded!");
            this.shutdown();
            return;
        }
        if (this.contentStream != null && !this.contentStream.isShutdown()) {
            this.logger.warn("Existing " + this.contentStream + " will be killed!");
        }
        if (request.getPort() == null) {
            throw new RuntimeException("Port argument not existent");
        }
        int udpPort = request.getPort();
        this.openingMode = request.getMode();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Opening content stream to [" + this.clientHost + ":" + udpPort + "] with mode [" + this.openingMode + "] ...");
        }
        try {
            ContentStreamIntf contentStream = this.audioSrv.createContentStream(this.openingMode);
            contentStream.init(this.audioSrv.getCore(), this.host, udpPort, request.getSessionID(), request.getProtocol(), request.getClientID());
            this.contentStream = contentStream;
            if (this.openingMode == 0 && this.getMDBReader() == null) {
                this.contentStream.shutdown();
                this.contentStream = null;
                this.logger.warn("Cannot get valid [MDBReader] for " + this);
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)-21630));
                callback.onRequestHandled(req, rsp);
                return;
            }
        }
        catch (SeeTecException seeTecException) {
            errorCode = seeTecException.getErrorCode();
            this.logger.error("Problems while opening content stream for " + this, (Throwable)seeTecException);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)errorCode));
        callback.onRequestHandled(req, rsp);
    }

    private void execSetStreamParameter(SrpcMessage req, RequestHandlerCallback callback) {
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)0));
        callback.onRequestHandled(req, rsp);
    }

    private void execReadNextFrame(SrpcMessage req, RequestHandlerCallback callback) {
        ReqReadNextFrame request = (ReqReadNextFrame)ReqReadNextFrame.parseGObject((GObject)req.getPayload());
        ArrayList<ContentFrame> vContentFrame = new ArrayList<ContentFrame>();
        Integer mediaType = request.getMediatype();
        Integer track = request.getTrack();
        Long timestamp = request.getTimestamp();
        int transactionId = request.getTransactionId();
        String token = req.getToken();
        int errorCode = this.getMDBReader().readNextFrame(mediaType, track, timestamp, transactionId, token, vContentFrame);
        if (errorCode != 0) {
            this.logger.warn("Reading next frame failed with error [" + errorCode + "]");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)errorCode));
            callback.onRequestHandled(req, rsp);
            return;
        }
        ContentFrame contentFrame = (ContentFrame)vContentFrame.get(2);
        if (contentFrame.isPacked()) {
            contentFrame = contentFrame.getNextUnpackedContentFrame(timestamp.longValue());
        }
        if ((errorCode = this.contentStream.sendFrame(contentFrame, (short)transactionId)) != 0) {
            this.logger.warn("Sending frame to " + this.contentStream + " failed");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)errorCode));
        callback.onRequestHandled(req, rsp);
    }

    private ContentFrame readNextFrame(Integer mediaType, Integer track, Long timestamp, Integer transactionId, String token) throws SeeTecException {
        Vector<ContentFrame> frames = new Vector<ContentFrame>();
        int errorCode = this.getMDBReader().readNextFrame(mediaType, track, timestamp, transactionId, token, frames);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "Reading previous frame failed with error [" + errorCode + "]");
        }
        return frames.get(2);
    }

    private void execReadPreviousFrame(SrpcMessage req, RequestHandlerCallback callback) {
        ReqReadPreviousFrame request = (ReqReadPreviousFrame)ReqReadPreviousFrame.parseGObject((GObject)req.getPayload());
        Integer mediaType = request.getMediatype();
        Integer track = request.getTrack();
        Long timestamp = request.getTimestamp();
        Integer transactionId = request.getTransactionId();
        String token = req.getToken();
        try {
            ContentFrame contentFrame = this.readPreviousFrame(mediaType, track, timestamp, transactionId, token);
            int errorCode = this.contentStream.sendFrame(contentFrame, transactionId.shortValue());
            if (errorCode != 0) {
                this.logger.warn("Sending frame to " + this.contentStream + " failed");
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)errorCode));
            callback.onRequestHandled(req, rsp);
        }
        catch (SeeTecException seetecException) {
            this.logger.warn(seetecException.getMessage());
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException contentFrame) {
                // empty catch block
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)GObject.create((int)seetecException.getErrorCode()));
            callback.onRequestHandled(req, rsp);
        }
    }

    private ContentFrame readPreviousFrame(Integer mediaType, Integer track, Long timestamp, Integer transactionId, String token) throws SeeTecException {
        ArrayList<ContentFrame> frames = new ArrayList<ContentFrame>();
        int errorCode = this.getMDBReader().readPreviousFrame(mediaType, track, timestamp, transactionId, token, frames);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "Reading previous frame failed with error [" + errorCode + "]");
        }
        return (ContentFrame)frames.get(2);
    }

    private void execGetAlarmTimerange(SrpcMessage req, RequestHandlerCallback callback) {
        ReqGetAlarmTimerange request = (ReqGetAlarmTimerange)ReqGetAlarmTimerange.parseGObject((GObject)req.getPayload());
        Integer mediatype = 16;
        Long timestamp = request.getTimestamp();
        String token = req.getToken();
        try {
            ContentFrame contentFrame = this.readNextFrame(mediatype, null, timestamp, null, token);
            Long startTimestamp = contentFrame.getStartTimestamp();
            Long endTimestamp = contentFrame.getEndTimestamp();
            byte[] contentData = contentFrame.getData();
            byte[] genericData = null;
            if (contentData.length > 12 && Basic.byteArrayToInt8((byte[])contentData, (int)0, (int)4) == -1599029040L) {
                int dataLenth = Basic.byteArrayToInt4((byte[])contentData, (int)4, (int)4);
                if (dataLenth < 0 || dataLenth > 65536) {
                    this.logger.error("Invalid generic data for " + contentFrame + " of " + this);
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(-21687);
                    callback.onRequestHandled(req, rsp);
                } else {
                    genericData = new byte[dataLenth];
                    System.arraycopy(contentData, 8, genericData, 0, genericData.length);
                }
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)new RspGetAlarmTimerange(startTimestamp, endTimestamp, genericData).createGObject());
            callback.onRequestHandled(req, rsp);
        }
        catch (SeeTecException seetecException) {
            this.logger.warn(request + " failed with error [" + seetecException.getErrorCode() + "]");
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(seetecException.getErrorCode());
            callback.onRequestHandled(req, rsp);
        }
    }

    private void execGetRecordingInfos(SrpcMessage req, RequestHandlerCallback rhc) {
        long time = System.currentTimeMillis();
        int errorCode = 0;
        ReqGetRecordingInfos request = (ReqGetRecordingInfos)ReqGetRecordingInfos.parseGObject((GObject)req.getPayload());
        request.setToken(req.getToken());
        long cumulationDistance = Math.max(request.getCumulationDistance(), 1000L);
        TimeRangeInfoContainer localRecordingInfoContainer = this.getRecordingInfos(request, true, true);
        if (localRecordingInfoContainer != null) {
            long startTimestamp = localRecordingInfoContainer.getTimeRangeList().getStartTimestamp();
            TimeRangeList recordingInfoList = localRecordingInfoContainer.getTimeRangeList();
            if (recordingInfoList.containsFailoverData()) {
                recordingInfoList = recordingInfoList.cleanAndMerge(cumulationDistance);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (TimeRangeInfo recordingInfo : recordingInfoList) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("RecordingInfo >>> Range:" + new Date(startTimestamp + recordingInfo.getTimestamp()) + " -> " + new Date(startTimestamp + recordingInfo.getTimestamp() + (long)recordingInfo.getLength()) + " | Track: " + recordingInfo.getTrack() + " | Failover: " + recordingInfo.isFailover());
                    }
                    byteArrayOutputStream.write(recordingInfo.serialize());
                }
                catch (IOException exception) {
                    this.logger.error("Could not add recording info " + recordingInfo + " to list for " + this);
                }
            }
            byte[] recordingInfosByteArray = byteArrayOutputStream.toByteArray();
            GObject goResp = new RspGetRecordingInfos(Long.valueOf(startTimestamp), recordingInfosByteArray).createGObject();
            this.logger.info("Got [" + recordingInfoList.size() + "] RecordingInfos in " + (System.currentTimeMillis() - time) + " ms");
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)goResp);
            rsp.setCompression((byte)1);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("No Recording Infos available for " + this);
            }
            errorCode = -21600;
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setCompression((byte)1);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        }
    }

    private void execGetAlarmScenarioOccurrencies(SrpcMessage req, RequestHandlerCallback rhc) {
        RspGetAlarmScenarioOccurrencies gorsp = new RspGetAlarmScenarioOccurrencies(Integer.valueOf(0), new ArrayList());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)gorsp.createGObject());
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
    }

    private DatabaseReaderImpl getMDBReader() {
        if (this.databaseReader != null && (!this.databaseReader.isValid() || this.databaseReader.isShutdown())) {
            this.logger.warn("Discarding [MDBReader] ...");
            this.databaseReader.shutdown();
            this.databaseReader = null;
        }
        if (this.databaseReader == null) {
            DatabaseReaderImpl tempDatabaseReader = new DatabaseReaderImpl();
            int errorCode = tempDatabaseReader.init(this, this.audioSrv.getCore());
            if (errorCode != 0) {
                tempDatabaseReader.shutdown();
                tempDatabaseReader = null;
                this.logger.warn("Creating [MDBReader] failed with error [" + errorCode + "]");
            }
            this.databaseReader = tempDatabaseReader;
        }
        return this.databaseReader;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public long getClientID() {
        return this.clientID;
    }

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
    }

    @Override
    public long getContentID() {
        return this.audioSrv.getServiceID();
    }

    @Override
    public String getContentName() {
        return this.audioSrv.getServiceName();
    }

    @Override
    public void setVideoMode(String videoMode) {
    }

    @Override
    public long getRecordingDuration() {
        return -1L;
    }

    @Override
    public MDBCnfIntf getMDBCnf() {
        return this.audioSrv.getMDBCnf();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.other.sip.AudioSrvClientRequestHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + (Object)((Object)this.srpcConnector) + ", " + this.audioSrv + ", Username=[" + this.userName + "], ClientID=[" + this.clientID + "]]";
    }

    @Override
    public TimeRangeInfoContainer getRecordingInfos(ReqGetRecordingInfos request, boolean retrieveFromMDB, boolean useCleanAndMerge) {
        if (!retrieveFromMDB && this.recordingInfoContainer != null && this.recordingInfoContainer.getAge() > 300000L) {
            return this.recordingInfoContainer;
        }
        TimeRangeInfoContainer recInfoContainer = null;
        Vector<RspGetRecordingInfos> result = new Vector<RspGetRecordingInfos>();
        this.logger.info("Executing " + request + " ...");
        int errorCode = this.audioSrv.getRecordingInfosFromMdb(request, result);
        if (errorCode != 0) {
            this.logger.warn(request + " failed with error [ " + errorCode + " ] ");
            return null;
        }
        Long startTimestamp = ((RspGetRecordingInfos)result.get(0)).getStartTimestamp();
        byte[] recordingInfos = ((RspGetRecordingInfos)result.get(0)).getRecordings();
        Long startTimestampFailover = null;
        byte[] recordingInfosFailover = null;
        if (result.size() >= 2) {
            startTimestampFailover = ((RspGetRecordingInfos)result.get(1)).getStartTimestamp();
            recordingInfosFailover = ((RspGetRecordingInfos)result.get(1)).getRecordings();
        }
        try {
            TimeRangeList recordingInfoList = new TimeRangeList();
            TimeRangeList recordingInfoListFailover = new TimeRangeList();
            if (recordingInfos.length % 10 == 0) {
                int i;
                for (i = 0; i < recordingInfos.length; i += 10) {
                    byte[] singleRecordingInfo = Arrays.copyOfRange(recordingInfos, i, i + 10);
                    TimeRangeInfo recordingInfo = new TimeRangeInfo(singleRecordingInfo);
                    recordingInfo.setIsFailover(false);
                    recordingInfoList.add(recordingInfo);
                }
                if (startTimestampFailover != null && startTimestampFailover != -1L && recordingInfosFailover != null && recordingInfosFailover.length > 0) {
                    if (recordingInfosFailover.length % 10 == 0) {
                        for (i = 0; i < recordingInfosFailover.length; i += 10) {
                            byte[] singleRecordingInfoFailover = Arrays.copyOfRange(recordingInfosFailover, i, i + 10);
                            TimeRangeInfo recordingInfoFailover = new TimeRangeInfo(singleRecordingInfoFailover);
                            recordingInfoFailover.setIsFailover(true);
                            recordingInfoListFailover.add(recordingInfoFailover);
                        }
                        long timeDifference = startTimestamp - startTimestampFailover;
                        if (timeDifference < 0L) {
                            for (TimeRangeInfo recordingInfo : recordingInfoListFailover) {
                                recordingInfo.setTimestamp(recordingInfo.getTimestamp() - timeDifference);
                            }
                        } else if (timeDifference > 0L) {
                            startTimestamp = startTimestampFailover;
                            for (TimeRangeInfo recordingInfo : recordingInfoList) {
                                recordingInfo.setTimestamp(recordingInfo.getTimestamp() + timeDifference);
                            }
                        }
                        recordingInfoList = recordingInfoList.dissect(recordingInfoListFailover);
                        recordingInfoListFailover = recordingInfoListFailover.dissect(recordingInfoList);
                        recordingInfoList = recordingInfoList.purge(recordingInfoListFailover);
                        recordingInfoListFailover = recordingInfoListFailover.purge(recordingInfoList);
                        recordingInfoList.addAll((Collection)recordingInfoListFailover);
                        Collections.sort(recordingInfoList);
                    } else {
                        this.logger.error("Could not parse recording infos. Length: " + recordingInfos.length);
                    }
                }
                recordingInfoList.setStartTimestamp(startTimestamp);
                this.recordingInfoContainer = recInfoContainer = new TimeRangeInfoContainer(recordingInfoList);
                return recInfoContainer;
            }
            this.logger.error("Could not parse recording infos. Length: " + recordingInfos.length);
        }
        catch (SeeTecException exception) {
            this.logger.warn("Problems while preparing recording information for " + this + " : " + exception.getMessage());
        }
        return recInfoContainer;
    }
}

