/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCDataUnit;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCSrvCnf;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;

public class SchneiderITCSrv
extends Service {
    private String myRuleName = null;
    private long myEntityID = 0L;
    private SchneiderITCSrvCnf srvCnf = null;

    @Override
    public int init(Core core, Device device, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.srvCnf = new SchneiderITCSrvCnf();
        errorCode = this.srvCnf.init(entity.getConfiguration());
        if (errorCode != 0) {
            this.logger.error("Creating [SchneiderITCSrvCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.myRuleName = entity.getEntityName();
        this.myEntityID = entity.getEntityID();
        errorCode = core.registerEntity(this.getServiceID(), this.getServiceType());
        if (errorCode != 0) {
            this.logger.error("Registering service " + (Object)((Object)this) + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            this.getCore().setEntityStatus(entity.getEntityID(), 0);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    @Override
    public int checkService() {
        return 0;
    }

    public void checkIncomingMessage(SchneiderITCDataUnit data) {
        try {
            if (null != data && data.matches(this.srvCnf.getTask(), this.srvCnf.getType())) {
                boolean p2Match;
                boolean p1Match = null == this.srvCnf.getParam1() ? true : data.getParam1().equalsIgnoreCase(this.srvCnf.getParam1());
                boolean bl = p2Match = null == this.srvCnf.getParam2() ? true : data.getParam2().equalsIgnoreCase(this.srvCnf.getParam2());
                if (p1Match && p2Match) {
                    this.logger.info("Incoming event " + data + " for: " + this.myRuleName + ".");
                    this.getCore().sendApplicationEvent(this.myEntityID);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error("Trouble handling message for " + (Object)((Object)this) + ". Message: " + data, ex);
        }
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ", ActionID=[" + Basic.longToFormattedString((Long)this.getEntity().getEntityID()) + "]]";
    }
}

