/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;

public class SchneiderITCSecUtils {
    public static byte[] calculatePasswordHash(String password) {
        if (null == password || password.isEmpty()) {
            throw new IllegalArgumentException("Argument password must not be null and not empty!");
        }
        byte[] hash = new byte[]{0, 0};
        String choppedPassword = password.substring(0, Math.min(8, password.length()));
        int[] weightVector = new int[]{1, 32, 1024, 32768, 130, 2056, 8320, 4680};
        long passwdSum = 0L;
        for (int index = 0; index < choppedPassword.length(); ++index) {
            passwdSum += (long)(weightVector[index] * choppedPassword.charAt(index));
        }
        int lSum = (int)(passwdSum >> 16 & 0xFFFFL);
        int rSum = (int)(passwdSum & 0xFFFFL);
        int sumsum = lSum + rSum & 0xFFFF;
        hash[0] = (byte)(sumsum & 0xFF);
        hash[1] = (byte)((sumsum & 0xFF00) >> 8);
        return hash;
    }

    public static byte[] calcChallangeResponse(byte[] nonce, byte[] pwHash) {
        byte[] reply = null;
        if (null == nonce) {
            throw new IllegalArgumentException("Argument 'nonce' must not be null.");
        }
        if (null == pwHash) {
            throw new IllegalArgumentException("Argument 'pwHash' must not be null.");
        }
        byte[] nonceAndHash = new byte[nonce.length + 2];
        System.arraycopy(nonce, 0, nonceAndHash, 0, nonce.length);
        System.arraycopy(pwHash, 0, nonceAndHash, nonce.length, 2);
        try {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            reply = hash.digest(nonceAndHash);
        }
        catch (NoSuchAlgorithmException nsae) {
            LogManager.getLogger((String)SchneiderITCSecUtils.class.getName()).error("", (Throwable)nsae);
        }
        return reply;
    }
}

