/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCDataUnit;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCInterfaceDevice;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCMessage;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCSrv;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchneiderITCNetworkHandler {
    private final Logger icxLog = LogManager.getLogger((String)"ICX");
    private static final int SO_TIMEOUT = 200;
    private static final boolean SO_KEEPALIVE = true;
    private static final int SLEEP_TIME = 200;
    private final Logger logger;
    private SchneiderITCInterfaceDevice device = null;
    private SchneiderITCSrv[] services = null;
    private final Object socketMutex = new Object();
    private Socket socket = null;
    private OutputStream outStream = null;
    private boolean delayKeepAliveTilChallengeResponse = false;
    private final int keepAliveAttackTime = 30000;
    private volatile long idleSent = -1L;
    private volatile long idleRec = -1L;
    private final ByteArrayOutputStream inputQueue = new ByteArrayOutputStream();
    private final Object queueMutex = new Object();
    private final BlockingQueue<SchneiderITCMessage> messageQueue = new LinkedBlockingQueue<SchneiderITCMessage>();
    private volatile boolean shutdown = false;
    private Thread socketReaderThread = null;
    private Thread messagePumpThread = null;
    private Thread keepAliveThread = null;
    private static final SchneiderITCMessage IDLE_MSG = SchneiderITCMessage.createIdleMessage();

    public SchneiderITCNetworkHandler() {
        this.logger = LogManager.getLogger((String)SchneiderITCNetworkHandler.class.getName());
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    public int init(Core core, SchneiderITCInterfaceDevice device, SchneiderITCSrv[] services) {
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.services = services;
        if (services == null) {
            return -21601;
        }
        String host = null;
        int port = 0;
        try {
            host = device.getDeviceConfiguration().getHost();
            port = device.getDeviceConfiguration().getPort();
            this.delayKeepAliveTilChallengeResponse = device.getDeviceConfiguration().isUseAuthentication();
        }
        catch (Exception e) {
            this.logger.error("Error reading configuration from " + device);
        }
        try {
            this.socket = new Socket(host, port);
            this.socket.setSoTimeout(200);
            this.socket.setKeepAlive(true);
            this.outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Error setting up socket to " + (host != null ? host : "null") + ":" + port + " for " + device);
            return -21656;
        }
        this.messagePumpThread = new Thread((Runnable)new MessagePump(), "SchneiderIntercom_MSGPUMP");
        this.messagePumpThread.start();
        this.socketReaderThread = new Thread((Runnable)new SocketReader(), "SchneiderIntercom_READER");
        this.socketReaderThread.start();
        this.keepAliveThread = new Thread((Runnable)new KeepAlive(), "SchneiderIntercom_KEEPALIVE");
        this.keepAliveThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown() {
        if (this.shutdown) {
            return 0;
        }
        this.shutdown = true;
        Thread.yield();
        this.keepAliveThread = null;
        this.socketReaderThread = null;
        this.messagePumpThread = null;
        Object object = this.socketMutex;
        synchronized (object) {
            try {
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.outStream = null;
            this.socket = null;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseInputQueue() {
        boolean retVal = false;
        try {
            Object object = this.queueMutex;
            synchronized (object) {
                byte[] buffer = this.inputQueue.toByteArray();
                this.inputQueue.reset();
                int start = SchneiderITCMessage.findMessageStart(buffer);
                if (start >= 0) {
                    int end = SchneiderITCMessage.findMessageEnd(buffer, start);
                    if (end >= 0) {
                        byte[] message = new byte[end - start + 1];
                        System.arraycopy(buffer, start, message, 0, message.length);
                        if (end + 1 < buffer.length) {
                            byte[] rest = new byte[buffer.length - (end + 1)];
                            System.arraycopy(buffer, end + 1, rest, 0, rest.length);
                            this.inputQueue.write(rest);
                        }
                        SchneiderITCMessage msgObj = SchneiderITCMessage.deserialize(message);
                        this.handleMessage(msgObj);
                        retVal = true;
                    } else {
                        this.inputQueue.write(buffer);
                    }
                } else {
                    int end = SchneiderITCMessage.findMessageEnd(buffer, 0);
                    if (end >= 0 && buffer.length > 1 && end + 1 < buffer.length) {
                        byte[] cleanQueue = new byte[buffer.length - 1 - end];
                        System.arraycopy(buffer, end + 1, cleanQueue, 0, cleanQueue.length);
                        this.inputQueue.write(cleanQueue);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("ERROR parsing input queue!", (Throwable)ex);
        }
        return retVal;
    }

    private void handleMessage(SchneiderITCMessage message) {
        if (null == message) {
            return;
        }
        if (!this.messageQueue.offer(message)) {
            SchneiderITCDataUnit data = message.getPayload();
            if (null != data) {
                this.logger.warn("Could not add message to queue! [" + data + "]");
            } else {
                this.logger.warn("Could not add message to queue! [" + message + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(SchneiderITCMessage outMessage) {
        if (null == this.outStream && !this.shutdown) {
            this.logger.fatal("Output stream is null! Cannot send to device.");
        }
        Object object = this.socketMutex;
        synchronized (object) {
            try {
                this.outStream.write(outMessage.serialize());
                this.outStream.flush();
            }
            catch (IOException ioe) {
                this.logger.error("Writing to socket: " + ioe.getMessage());
                if (!this.shutdown) {
                    this.onConnectionLoss();
                }
                this.device.shutdown();
            }
        }
    }

    private void onConnectionLoss() {
        this.logger.warn("SCHNEIDER INTERCOM LOST CONNECTION !");
    }

    private class KeepAlive
    implements Runnable {
        private final long keepAliveCycleTime = TimeUnit.SECONDS.toMillis(30L);

        private KeepAlive() {
        }

        @Override
        public void run() {
            try {
                while (SchneiderITCNetworkHandler.this.delayKeepAliveTilChallengeResponse && !SchneiderITCNetworkHandler.this.shutdown) {
                    Thread.sleep(this.keepAliveCycleTime / 2L);
                }
                Thread.sleep(30000L);
                while (!SchneiderITCNetworkHandler.this.shutdown) {
                    if (SchneiderITCNetworkHandler.this.idleSent > 0L) {
                        SchneiderITCNetworkHandler.this.logger.warn("Idle timed out!");
                    }
                    SchneiderITCNetworkHandler.this.idleSent = System.currentTimeMillis();
                    SchneiderITCNetworkHandler.this.send(IDLE_MSG);
                    if (SchneiderITCNetworkHandler.this.shutdown) continue;
                    Thread.sleep(this.keepAliveCycleTime);
                }
            }
            catch (Throwable t) {
                SchneiderITCNetworkHandler.this.logger.error("ERROR in keepalive thread. Terminating thread. [" + t.getMessage() + "]");
            }
        }
    }

    private class MessagePump
    implements Runnable {
        private MessagePump() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                block2: while (!SchneiderITCNetworkHandler.this.shutdown) {
                    SchneiderITCMessage workingMessage = (SchneiderITCMessage)SchneiderITCNetworkHandler.this.messageQueue.poll(200L, TimeUnit.MILLISECONDS);
                    if (null == workingMessage) continue;
                    if (workingMessage.getIndicator() == -12) {
                        byte[] nonce;
                        if (!SchneiderITCNetworkHandler.this.device.getDeviceConfiguration().isUseAuthentication()) {
                            SchneiderITCNetworkHandler.this.logger.fatal("Server sent challenge but there is no password in config!");
                        }
                        if ((nonce = workingMessage.getICX()).length != 2) {
                            SchneiderITCNetworkHandler.this.logger.error("Received nonce with length [" + nonce.length + "bytes], should be 16 bits = 2bytes");
                        }
                        byte[] pass = SchneiderITCNetworkHandler.this.device.getDeviceConfiguration().getPasswordHash();
                        SchneiderITCMessage passwordResponse = SchneiderITCMessage.createResponseMessage(nonce, pass);
                        SchneiderITCNetworkHandler.this.send(passwordResponse);
                        SchneiderITCNetworkHandler.this.delayKeepAliveTilChallengeResponse = false;
                        continue;
                    }
                    if (workingMessage.getIndicator() == -15) {
                        if (SchneiderITCNetworkHandler.this.idleSent > 0L) {
                            SchneiderITCNetworkHandler.this.idleRec = System.currentTimeMillis() - SchneiderITCNetworkHandler.this.idleSent;
                            SchneiderITCNetworkHandler.this.idleSent = -1L;
                            if (SchneiderITCNetworkHandler.this.idleRec <= 2000L) continue;
                            SchneiderITCNetworkHandler.this.send(workingMessage);
                            continue;
                        }
                        SchneiderITCNetworkHandler.this.idleSent = -1L;
                        SchneiderITCNetworkHandler.this.send(workingMessage);
                        continue;
                    }
                    if (workingMessage.getIndicator() == -14) {
                        if (workingMessage.getPayload() == null) {
                            SchneiderITCNetworkHandler.this.icxLog.warn(">>> SCHNEIDER INTERCOM DATA WAS NULL <<<");
                            continue;
                        }
                        if (workingMessage.getPayload().isWatchDog()) {
                            SchneiderITCMessage wdResponse = SchneiderITCMessage.createWatchDogResponse(workingMessage.getPayload());
                            SchneiderITCNetworkHandler.this.send(wdResponse);
                            continue;
                        }
                        SchneiderITCSrv[] schneiderITCSrvArray = SchneiderITCNetworkHandler.this.services;
                        int n = schneiderITCSrvArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block2;
                            SchneiderITCSrv srv = schneiderITCSrvArray[n2];
                            if (null != srv) {
                                srv.checkIncomingMessage(workingMessage.getPayload());
                            }
                            ++n2;
                        }
                    }
                    SchneiderITCNetworkHandler.this.logger.warn(String.format(">>> SCHNEIDER INTERCOM UNSUPPORTED INDICATOR [%X] <<<", workingMessage.getIndicator()));
                }
                return;
            }
            catch (Throwable t) {
                SchneiderITCNetworkHandler.this.logger.fatal("Error in message pump. Terminating Thread.", t);
            }
        }
    }

    private class SocketReader
    implements Runnable {
        private SocketReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buffer = new byte[4096];
            try {
                while (!SchneiderITCNetworkHandler.this.shutdown) {
                    int bytesRead;
                    try {
                        InputStream in = SchneiderITCNetworkHandler.this.socket.getInputStream();
                        bytesRead = in.read(buffer);
                    }
                    catch (SocketTimeoutException ste) {
                        if (!SchneiderITCNetworkHandler.this.shutdown) {
                            continue;
                        }
                        break;
                    }
                    catch (SocketException e) {
                        SchneiderITCNetworkHandler.this.logger.error("Error while reading from socket : " + e.getMessage());
                        if (!SchneiderITCNetworkHandler.this.shutdown) {
                            SchneiderITCNetworkHandler.this.onConnectionLoss();
                        }
                        SchneiderITCNetworkHandler.this.device.shutdown();
                        break;
                    }
                    catch (IOException e2) {
                        SchneiderITCNetworkHandler.this.logger.error("Error while reading from socket : " + e2.getMessage());
                        if (!SchneiderITCNetworkHandler.this.shutdown) {
                            SchneiderITCNetworkHandler.this.onConnectionLoss();
                        }
                        SchneiderITCNetworkHandler.this.device.shutdown();
                        break;
                    }
                    if (bytesRead < 0) {
                        if (!SchneiderITCNetworkHandler.this.shutdown) {
                            SchneiderITCNetworkHandler.this.logger.fatal("Read operation returns negative count. This is a hint for a broken connection. Terminating reader thread.");
                            SchneiderITCNetworkHandler.this.onConnectionLoss();
                        }
                        SchneiderITCNetworkHandler.this.device.shutdown();
                        break;
                    }
                    Object e2 = SchneiderITCNetworkHandler.this.queueMutex;
                    synchronized (e2) {
                        SchneiderITCNetworkHandler.this.inputQueue.write(buffer, 0, bytesRead);
                    }
                    while (!SchneiderITCNetworkHandler.this.shutdown && SchneiderITCNetworkHandler.this.parseInputQueue()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e2) {}
                    }
                }
            }
            catch (Throwable t) {
                SchneiderITCNetworkHandler.this.logger.fatal("Error in socket reader. Terminating Thread.", t);
            }
        }
    }
}

