/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCDeviceCnf;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCNetworkHandler;
import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SchneiderITCInterfaceDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCInterfaceDevice";
    private SchneiderITCNetworkHandler sitcHandler = null;
    private SchneiderITCDeviceCnf srvCnf = null;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.srvCnf = new SchneiderITCDeviceCnf();
        if (null == this.getDeviceEntity()) {
            this.logger.warn("Own DeviceEntity is NULL!");
        }
        if ((errorCode = this.srvCnf.init(this.getDeviceEntity().getConfiguration())) != 0) {
            this.logger.error("Creating [SchneiderITCDeviceCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        Entity[] srvEnities = super.getSrvEntities();
        this.services = new SchneiderITCSrv[srvEnities.length];
        for (int i = 0; i < srvEnities.length; ++i) {
            Entity entity = srvEnities[i];
            boolean enabled = entity.isEnabled();
            if (!enabled) continue;
            SchneiderITCSrv service = new SchneiderITCSrv();
            errorCode = service.init(this.core, this, entity);
            if (errorCode != 0) {
                this.logger.error("Creating " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            this.services[i] = service;
        }
        this.sitcHandler = new SchneiderITCNetworkHandler();
        errorCode = this.sitcHandler.init(this.core, this, (SchneiderITCSrv[])this.services);
        if (errorCode != 0) {
            this.logger.error("Initializing [SchneiderITCNetworkHandler] failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.logger.info(this + " initialized");
        return 0;
    }

    @Override
    protected int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.error("NOT YET IMPLEMENTED for " + this);
        return -21600;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.sitcHandler != null && (errorCode = this.sitcHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + this.sitcHandler + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        if (this.services != null) {
            this.logger.info("Shutting down [" + this.services.length + "] services ...");
            for (Service service : this.services) {
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
            }
        }
        this.srvCnf = null;
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int initializeDevice(long srvType) {
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    public SchneiderITCDeviceCnf getDeviceConfiguration() {
        return this.srvCnf;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

