/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.schneideritc;

import de.seetec.v5.re.cm.device.other.schneideritc.SchneiderITCMessageTypes;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SchneiderITCDataUnit {
    private static final Logger LOGGER = LogManager.getLogger((String)SchneiderITCDataUnit.class.getName());
    private int taskno = -1;
    private int taskoffset = 0;
    private int typeno = -1;
    private String task = "";
    private String type = "";
    private String param1 = "";
    private String param2 = "";
    private String index = "";

    public static synchronized SchneiderITCDataUnit create(byte[] data) {
        String ty;
        if (data.length < 3) {
            return null;
        }
        SchneiderITCDataUnit pdu = new SchneiderITCDataUnit();
        String message = "";
        try {
            message = new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.fatal("Translating message form ASCII-bytes!", (Throwable)uee);
        }
        String ta = message.substring(2, 4);
        int task = -1;
        try {
            task = Integer.parseInt(ta, 16);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format("Could not parse [%s] as TaskNo in Message [%s]!", ta, message));
        }
        int formatOffset = 0;
        String param1 = "";
        String param2 = "";
        if (task < 96) {
            param1 = message.substring(6, 10);
            param2 = message.substring(10, 14);
            ty = message.substring(14);
        } else if (task < 128) {
            ty = message.substring(6, 8);
            param1 = message.substring(8, 16);
            param2 = message.substring(16);
            formatOffset = 32;
        } else if (task < 160) {
            ty = message.substring(6, 8);
            param1 = message.substring(8, 16);
            param2 = message.substring(16);
            formatOffset = 64;
        } else {
            ty = "00";
        }
        int type = 0;
        try {
            type = Integer.parseInt(ty, 16);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format("Could not parse [%s] as Type in Message [%s]!", ty, message));
        }
        pdu.init(ta, task, ty, type, formatOffset, param1, param2);
        return pdu;
    }

    public static SchneiderITCDataUnit createWatchDogResponse(SchneiderITCDataUnit watchdog) {
        SchneiderITCDataUnit pdu = new SchneiderITCDataUnit();
        pdu.init("40", 64, "A4", 164, 0, watchdog.getParam1(), watchdog.getParam2());
        return pdu;
    }

    private SchneiderITCDataUnit() {
    }

    private void init(String ta, int task, String ty, int type, int offset, String param1, String param2) {
        this.task = ta;
        this.taskno = task;
        this.taskoffset = offset;
        this.type = ty;
        this.typeno = type;
        this.param1 = param1;
        this.param2 = param2;
        this.index = String.format("%X%s", task - this.taskoffset, ty);
    }

    public String getTask() {
        return this.task;
    }

    public String getType() {
        return this.type;
    }

    public String getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public String toString() {
        return String.format("[%-35s] (%s) Task [%02X] Type [%02X] Param1 [%8s] Param2 [%s]", SchneiderITCMessageTypes.getTypeDescription(this.index), this.index, this.taskno, this.typeno, this.param1, this.param2);
    }

    public boolean matches(String taskMask, String typeMask) {
        if (taskMask.isEmpty()) {
            return false;
        }
        int localTask = Integer.parseInt(taskMask, 16);
        if (localTask != this.taskno - this.taskoffset && localTask - 32 != this.taskno - this.taskoffset && localTask - 64 != this.taskno - this.taskoffset) {
            return false;
        }
        if (localTask >= 160) {
            return false;
        }
        boolean isType = typeMask.equals(this.type);
        return isType;
    }

    public boolean isWatchDog() {
        return this.matches("42", "A4");
    }
}

