/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.networkio;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkDevice;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkHandler;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkSrvCnf;
import de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.StringTokenizer;
import org.jdom.output.XMLOutputter;

public class GenericNetworkSrv
extends Service {
    public static final String NONE = "NONE";
    private GenericNetworkSrvCnf srvCnf = null;
    private String networkProtokoll = null;
    private String connectTo = null;
    private int listenerPort = -1;
    private String valueType = null;
    private String valueASCII = null;
    private byte[] valueHEX = null;
    private int deadTime = -1;
    private long tsLastEvent = -1L;

    @Override
    public int init(Core core, Device device, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.srvCnf = new GenericNetworkSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [SrvCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            this.networkProtokoll = this.srvCnf.getNetworkProtocol().trim();
            this.connectTo = this.srvCnf.getConnectTo();
            this.listenerPort = this.srvCnf.getListenerPort();
            this.valueType = this.srvCnf.getValueType();
            this.valueASCII = this.srvCnf.getValueASCII();
            this.valueHEX = this.srvCnf.getValueHEX();
            this.deadTime = this.srvCnf.getDeadTime();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -21602;
        }
        try {
            this.getCore().setEntityStatus(entity.getEntityID(), 0);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    private int sendEvent() {
        return this.sendEvent(null);
    }

    private int sendEvent(byte[] genericData) {
        return super.getCore().sendApplicationEvent(this.srvCnf.getEntity().getEntityID(), genericData);
    }

    @Override
    public int checkService() {
        return 0;
    }

    public long getActionID() {
        if ((this.isShutdown() || super.isShutdown() || this.getEntity() == null) && this.getDevice() != null) {
            this.getDevice().shutdown();
        }
        return this.getEntity().getEntityID();
    }

    public int triggerAction() {
        block15: {
            try {
                String messageToSend;
                String message;
                this.logger.info("Triggering action of " + (Object)((Object)this) + " ...");
                long entityType = this.getEntity().getEntityType();
                if (entityType != 9951L) break block15;
                GenericNetworkHandler genericNetworkHandler = ((GenericNetworkDevice)this.getDevice()).getGenericNetworkHandler();
                NetworkProtocolHandler networkProtocolHandler = genericNetworkHandler.getNetworkProtocolHandler(this.connectTo + ":" + this.listenerPort + ":" + this.valueType);
                String networkProtocol = this.getNetworkProtocol().toUpperCase();
                String usr = this.srvCnf.getUser();
                String pwd = this.srvCnf.getPassword();
                if (this.valueType.equals("HEX")) {
                    message = new String(this.valueHEX);
                } else if (this.valueType.equals("ASCII")) {
                    message = this.valueASCII;
                } else {
                    this.logger.error("Value type [" + this.valueType + "] not supported for " + (Object)((Object)this));
                    return -21611;
                }
                String authorization = "";
                if (usr != null && pwd != null && usr.length() > 0 && pwd.length() > 0) {
                    String[] usrPwd = new String[]{usr, pwd};
                    authorization = NetworkHelper.createBasicAuthorization((String[])usrPwd);
                }
                if (networkProtocol.equals("HTTP-GET") || networkProtocol.equals("HTTPS")) {
                    messageToSend = this.createHttpGetRequest(message, this.connectTo, authorization);
                } else if (networkProtocol.equals("TCP")) {
                    messageToSend = message;
                } else {
                    this.logger.error("Network protocol [" + networkProtocol + "] not supported for " + (Object)((Object)this));
                    return -21611;
                }
                byte[] bytesToSend = networkProtocol.equals("TCP") && this.valueType.equals("HEX") ? this.valueHEX : messageToSend.getBytes();
                byte[] result = networkProtocolHandler.sendMsg(bytesToSend, networkProtocol.equals("HTTPS"));
                HTTPResponse httpResponse = new HTTPResponse(result);
                if (!networkProtocol.equals("HTTP-GET") && !networkProtocol.equals("HTTPS") || httpResponse.getHttpHeader().getStatusCode() != HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) break block15;
                String realm = httpResponse.getHttpHeader().getRealm();
                String nonce = httpResponse.getHttpHeader().getNonce();
                String qop = httpResponse.getHttpHeader().getQop();
                authorization = "";
                if (realm == null || nonce == null || usr == null || pwd == null || usr.length() <= 0 || pwd.length() <= 0) break block15;
                String[] usrpwd = new String[]{usr, pwd};
                NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)this.connectTo, (int)this.listenerPort, (boolean)false, (int)-1, (int)1000, (boolean)false, (String[])usrpwd);
                authorization = qop == null ? NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"GET", (String)message) : NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"GET", (String)message, (String)qop);
                messageToSend = this.createHttpGetRequest(message, this.connectTo, authorization);
                try {
                    boolean isHttps = networkProtocol.equals("HTTPS");
                    bytesToSend = messageToSend.getBytes();
                    result = networkProtocolHandler.sendMsg(bytesToSend, isHttps);
                    httpResponse = new HTTPResponse(result);
                    if (httpResponse.getHttpHeader() != null && httpResponse.getHttpHeader().getStatusCode() == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                        throw new SeeTecException(-21657, "Unauthorized");
                    }
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while sending trigger: " + e.getMessage() + " for " + (Object)((Object)this));
                    return e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error("Exception while sending trigger: " + e.getMessage() + " for " + (Object)((Object)this));
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                return -21600;
            }
        }
        return 0;
    }

    public String getConnectTo() {
        return this.connectTo;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getNetworkProtocol() {
        return this.networkProtokoll;
    }

    public String getControlCharacter() {
        try {
            return this.srvCnf.getControlCharacter();
        }
        catch (ConfigurationException cex) {
            return "";
        }
    }

    public boolean checkIncomingMessage(byte[] msg) {
        try {
            String asciiMessage;
            String controlCharacter;
            boolean match = false;
            String networkProtocol = this.srvCnf.getNetworkProtocol().trim().toUpperCase();
            if (this.valueType.equals("ASCII")) {
                int nullCounter = 0;
                for (int i = 0; i < msg.length; ++i) {
                    if (msg[i] != 0) continue;
                    ++nullCounter;
                }
                byte[] tmp = new byte[msg.length - nullCounter];
                int tmpCounter = 0;
                for (int i = 0; i < msg.length; ++i) {
                    if (msg[i] == 0) continue;
                    tmp[tmpCounter] = msg[i];
                    ++tmpCounter;
                }
                msg = tmp;
            }
            if (!(controlCharacter = this.srvCnf.getControlCharacter()).equals(NONE)) {
                String signToReplace = controlCharacter.equals("CR") ? new String(new char[]{'\r'}) : (controlCharacter.equals("LF") ? new String(new char[]{'\n'}) : (controlCharacter.equals("CR/LF") ? new String(new char[]{'\r', '\n'}) : controlCharacter));
                String data = new String(msg);
                data = data.replace(signToReplace, "");
                msg = data.getBytes();
            }
            if (networkProtocol.equals("HTTP")) {
                String s = new String(msg, "UTF-8").trim();
                if (s.length() <= 0) {
                    this.logger.error("Empty HTTP-Request not supported for " + (Object)((Object)this) + " :-(");
                    return false;
                }
                StringTokenizer stringToken = new StringTokenizer(s, " ");
                String element = ((String)stringToken.nextElement()).trim().toUpperCase();
                if (!element.startsWith("GET")) {
                    this.logger.error("HTTP-Request [" + element + "] not supported for " + (Object)((Object)this));
                    return false;
                }
                asciiMessage = ((String)stringToken.nextElement()).trim();
            } else if (networkProtocol.startsWith("TCP")) {
                asciiMessage = new String(msg, "UTF-8").trim();
            } else {
                this.logger.error("Network protocol [" + networkProtocol + "] not supported for " + (Object)((Object)this));
                return false;
            }
            if (this.valueType.equals("ASCII")) {
                match = this.valueASCII.length() == 0 ? true : asciiMessage.equals(this.valueASCII);
            } else if (this.valueType.equals("HEX")) {
                if (this.valueHEX.length == 0) {
                    match = true;
                } else if (this.valueHEX.length == msg.length) {
                    match = true;
                    for (int i = 0; i < this.valueHEX.length; ++i) {
                        if (this.valueHEX[i] == msg[i]) continue;
                        match = false;
                        break;
                    }
                }
            } else {
                this.logger.error("Value type [" + this.valueType + "] not supported for " + (Object)((Object)this));
                return false;
            }
            if (match) {
                String logMessage = this.valueType.equals("ASCII") ? asciiMessage : (msg.length < 32 ? "HEX=" + GenericNetworkSrv.byteArrayToHexString((byte[])msg, (int)0, (int)32) : "HEX=" + GenericNetworkSrv.byteArrayToHexString((byte[])msg, (int)0, (int)32) + " ...");
                if (System.currentTimeMillis() - (long)this.deadTime > this.tsLastEvent) {
                    this.logger.info("Matching message [" + logMessage + "] of " + (Object)((Object)this) + " will be sent");
                    this.tsLastEvent = System.currentTimeMillis();
                    if (this.valueType.equalsIgnoreCase("ASCII")) {
                        String xml = "<AC>" + new XMLOutputter().escapeElementEntities(asciiMessage) + "</AC>";
                        this.sendEvent(xml.getBytes("UTF-8"));
                    } else {
                        this.sendEvent();
                    }
                } else {
                    this.logger.info("Matching message [" + logMessage + "] of " + (Object)((Object)this) + " is within deadtime and will be ignored!");
                }
                return true;
            }
            return false;
        }
        catch (Throwable ex) {
            this.logger.error("Trouble handling message for " + (Object)((Object)this), ex);
            return false;
        }
    }

    protected String createHttpGetRequest(String uri, String host, String authorization) {
        return "GET " + uri + " HTTP/1.1" + "\r\n" + "Host: " + host + "\r\n" + "User-Agent: Java/1.8.0" + "\r\n" + "Keep-Alive: 300" + "\r\n" + "Connection: keep-alive" + "\r\n" + authorization + "\r\n";
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ", ActionID=[" + Basic.longToFormattedString((long)this.getActionID()) + "]]";
    }
}

