/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.other.networkio;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkClientRequestHandler;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkDevice;
import de.seetec.v5.re.cm.device.other.networkio.GenericNetworkSrv;
import de.seetec.v5.re.cm.device.other.networkio.NetworkProtocolHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.networking.srpc.NetworkDispatcherHeader;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericNetworkHandler
extends Basic
implements SRPCDispatcherListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.other.networkio.GenericNetworkHandler";
    private Logger logger = null;
    private Core core = null;
    private GenericNetworkDevice device = null;
    private GenericNetworkSrv[] services = null;
    private Vector<GenericNetworkClientRequestHandler> clientRequestHandlerList = null;
    private Hashtable<String, NetworkProtocolHandler> htNetworkProtocolHandler = null;
    private final Object semaphore = new Object();

    public GenericNetworkHandler() {
        this.logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    public int init(Core core, GenericNetworkDevice device, GenericNetworkSrv[] services) {
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.services = services;
        if (services == null) {
            return -21601;
        }
        this.clientRequestHandlerList = new Vector();
        this.htNetworkProtocolHandler = new Hashtable();
        for (GenericNetworkSrv service : this.services) {
            int errorCode;
            long serviceID = service.getServiceID();
            long serviceType = service.getServiceType();
            String networkProtokoll = service.getNetworkProtocol();
            String controlCharacter = service.getControlCharacter();
            String connectTo = service.getConnectTo();
            int listenerPort = service.getListenerPort();
            String valueType = service.getValueType();
            boolean keepAlive = false;
            String hashID = connectTo + ":" + listenerPort + ":" + valueType;
            NetworkProtocolHandler networkProtocolHandler = this.htNetworkProtocolHandler.get(hashID);
            if (networkProtocolHandler == null) {
                if (serviceType == 9806L && connectTo != null) {
                    keepAlive = true;
                }
                if ((errorCode = (networkProtocolHandler = new NetworkProtocolHandler()).init(this.device, networkProtokoll, connectTo, listenerPort, keepAlive, controlCharacter)) != 0) {
                    this.logger.error("Initializing of " + networkProtocolHandler + " failed with error [" + errorCode + "]");
                    networkProtocolHandler.shutdown();
                    return errorCode;
                }
                this.htNetworkProtocolHandler.put(hashID, networkProtocolHandler);
            }
            if ((errorCode = networkProtocolHandler.addService(service)) != 0) {
                this.logger.error("Adding " + (Object)((Object)service) + " to " + networkProtocolHandler + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            errorCode = this.core.registerEntity(serviceID, serviceType);
            if (errorCode != 0) {
                this.logger.error("Registering service " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            this.core.registerToSRPCDispatcher(this, serviceID);
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Starting shutdown of " + (Object)((Object)this) + " ...");
        Object object = this.semaphore;
        synchronized (object) {
            if (this.clientRequestHandlerList != null) {
                for (int i = 0; i < this.clientRequestHandlerList.size(); ++i) {
                    GenericNetworkClientRequestHandler genericNetworkClientRequestHandler = this.clientRequestHandlerList.elementAt(i);
                    errorCode = genericNetworkClientRequestHandler.shutdown();
                    if (errorCode == 0) continue;
                    this.logger.warn("Shutting down " + (Object)((Object)genericNetworkClientRequestHandler) + " failed with error [" + errorCode + "] :-(");
                }
                this.clientRequestHandlerList = null;
            }
        }
        Enumeration<NetworkProtocolHandler> enumNetworkProtocolHandler = this.htNetworkProtocolHandler.elements();
        while (enumNetworkProtocolHandler.hasMoreElements()) {
            NetworkProtocolHandler networkProtocolHandler = enumNetworkProtocolHandler.nextElement();
            networkProtocolHandler.shutdown();
        }
        for (GenericNetworkSrv service : this.services) {
            errorCode = service.shutdown();
            if (errorCode == 0) continue;
            this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "]");
        }
        if (this.device != null) {
            errorCode = this.device.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + this.device + " failed with error [" + errorCode + "]");
            }
            this.device = null;
        }
        this.logger.info("... shutdown for " + (Object)((Object)this) + " done");
        return 0;
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() != 0) {
            this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported");
            try {
                socket.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            return -21005;
        }
        return this.handleRequest(socket);
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn("... Client refused. Core is already shutting down");
            return -21609;
        }
        this.logger.info("New client from " + socket + " ...");
        GenericNetworkClientRequestHandler genericNetworkClientRequestHandler = new GenericNetworkClientRequestHandler();
        int errorCode = genericNetworkClientRequestHandler.init(this, socket);
        if (errorCode != 0) {
            this.logger.error("Initializing " + (Object)((Object)genericNetworkClientRequestHandler) + " failed with error [" + errorCode + "]");
            errorCode = genericNetworkClientRequestHandler.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + (Object)((Object)genericNetworkClientRequestHandler) + " failed with error [" + errorCode + "]");
            }
            return errorCode;
        }
        return 0;
    }

    public int register(GenericNetworkClientRequestHandler genericNetworkClientRequestHandler) {
        this.clientRequestHandlerList.addElement(genericNetworkClientRequestHandler);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deregister(GenericNetworkClientRequestHandler genericNetworkClientRequestHandler) {
        Object object = this.semaphore;
        synchronized (object) {
            for (int i = 0; this.clientRequestHandlerList != null && i < this.clientRequestHandlerList.size(); ++i) {
                if (this.clientRequestHandlerList.elementAt(i) != genericNetworkClientRequestHandler) continue;
                this.clientRequestHandlerList.removeElementAt(i);
                return 0;
            }
        }
        return -21640;
    }

    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered ...");
        for (GenericNetworkSrv service : this.services) {
            if (service.getActionID() != actionID.longValue()) continue;
            return service.triggerAction();
        }
        this.logger.info((Object)((Object)this) + " has following [GenericNetworkSrv] ...");
        for (GenericNetworkSrv service : this.services) {
            if (service.getActionID() != actionID.longValue()) continue;
            this.logger.info("   " + (Object)((Object)service));
        }
        this.logger.error("Action [" + actionID + "] is unknown :-(");
        return -21670;
    }

    public NetworkProtocolHandler getNetworkProtocolHandler(String sIdentifiert) {
        return this.htNetworkProtocolHandler.get(sIdentifiert);
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.other.networkio.GenericNetworkHandler@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.device + "]";
    }
}

