/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDataWrapper;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDevice;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrvCnf;
import de.seetec.v5.re.cm.device.alarmsystems.spc.ZoneState;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.shared.Action;
import de.seetec.v5.re.cm.shared.ActionHandlerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;

public class SpcSrv
extends Service
implements ActionHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrv";
    private SpcSrvCnf srvCnf = null;
    private Action[] actions = null;
    private String myRuleName = null;
    private int detectorGroup = Integer.MIN_VALUE;

    @Override
    public final int init(Core core, Device device, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.srvCnf = new SpcSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [SpcDeviceCnf] failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            if (this.srvCnf.getRootName().equalsIgnoreCase("SPCEventTrigger")) {
                this.myRuleName = entity.getEntityName();
                this.detectorGroup = Integer.parseInt(this.srvCnf.getDetectorGroup());
            } else if (this.srvCnf.getRootName().equalsIgnoreCase("SPCAreaActiveTrigger")) {
                this.myRuleName = entity.getEntityName();
            } else if (this.srvCnf.getRootName().equalsIgnoreCase("SPCAreaInactiveTrigger")) {
                this.myRuleName = entity.getEntityName();
            }
        }
        catch (ConfigurationException e) {
            this.logger.error("Error while reading configuration of " + this);
            this.logger.info(new String(this.srvCnf.getConfiguration()));
            return -21602;
        }
        errorCode = core.registerEntity(this.getServiceID(), this.getServiceType());
        if (errorCode != 0) {
            this.logger.error("Registering service " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            if (entity.getEntityType() == 9911L || entity.getEntityType() == 9912L || entity.getEntityType() == 9982L) {
                this.getCore().setEntityStatus(entity.getEntityID(), 0);
            } else {
                this.getCore().setEntityStatus(entity.getEntityID(), -2);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        long[] typeList = new long[]{9983L, 9985L, 9984L, 9988L, 9989L, 9986L, 9987L};
        Entity[] entities = this.device.getEnabledEntities(new long[]{super.getEntity().getEntityID()}, typeList);
        this.actions = new Action[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            this.actions[i] = new Action();
            errorCode = this.actions[i].init(entities[i]);
            if (errorCode == 0) continue;
            this.logger.error("Cannot initialize action [" + entities[i] + "]");
            return -21671;
        }
        this.getCore().actionHandler.put(super.getServiceID(), this);
        return 0;
    }

    @Override
    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    private int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        return super.getCore().sendApplicationEvent(sourceID);
    }

    @Override
    public int checkService() {
        return 0;
    }

    public final long getActionID() {
        if ((this.isShutdown() || super.isShutdown() || this.getEntity() == null) && this.getDevice() != null) {
            this.getDevice().shutdown();
        }
        return this.getEntity().getEntityID();
    }

    public final void checkIncomingMessage(SpcDataWrapper data) {
        try {
            if (data != null) {
                if (data.getEventType() == this.srvCnf.getEventGroupID()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Incoming event (" + data.getEventType() + ") for: " + this.myRuleName + ". Event is: " + data.toString());
                    }
                    if (this.srvCnf.getDetectorGroup() != null && data.getDetectorGroup() != null && data.getDetectorGroup().equalsIgnoreCase(this.srvCnf.getDetectorGroup())) {
                        this.sendEvent();
                    }
                }
            } else {
                this.logger.error("Given data null in " + this);
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Trouble handling message for " + this, (Throwable)ex);
        }
    }

    @Override
    public final String toString() {
        return "[" + super.toString() + ", ActionID=[" + Basic.longToFormattedString((long)this.getActionID()) + "]]";
    }

    public void updateStatus(String zoneNumber, ZoneState zoneState) {
        try {
            if (zoneNumber.equals(this.srvCnf.getDetectorGroup())) {
                this.publishServiceStatus(zoneState.getValue());
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
    }

    public int getDetectorGroup() {
        return this.detectorGroup;
    }

    public int triggerAction(Long actionID) {
        return this.triggerAction(actionID, -1L, -1L, -1L, null, -1L, -1L);
    }

    @Override
    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData, long ptzPriority, long ptzTimeout) {
        if (this.isShutdown(CLASS_NAME) || this.getCore().isShutdown()) {
            this.logger.warn("Cannot trigger action [" + actionID + "] of scenario [" + alarmScriptID + "] because of shutdown of " + this);
            return -21609;
        }
        for (Action action : this.actions) {
            long foundActionId = action.getActionID();
            long foundActionType = action.getActionType();
            if (foundActionId != actionID) continue;
            if (foundActionType == 9983L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 1);
                return 0;
            }
            if (foundActionType == 9985L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 2);
                return 0;
            }
            if (foundActionType == 9984L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 3);
                return 0;
            }
            if (foundActionType == 9988L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 10);
                return 0;
            }
            if (foundActionType == 9989L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 11);
                return 0;
            }
            if (foundActionType == 9986L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 12);
                return 0;
            }
            if (foundActionType == 9987L) {
                ((SpcDevice)this.getDevice()).setState(this.getServiceID(), 13);
                return 0;
            }
            this.logger.error("Action type [" + foundActionType + "] is unknown to " + this);
            return -21672;
        }
        this.logger.error("Action [" + actionID + "] is unknown to " + this);
        return -21670;
    }

    public boolean hasAction(long actionID) {
        for (Action action : this.actions) {
            if (action.getActionID() != actionID) continue;
            return true;
        }
        return false;
    }
}

