/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.device.alarmsystems.spc.EDPCommands;
import de.seetec.v5.re.cm.device.alarmsystems.spc.ReplyCode;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SIACode;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SIACodeType;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcCommandWrapper;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDataWrapper;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDevice;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcDeviceCnf;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcIoHandler;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrv;
import de.seetec.v5.re.cm.device.alarmsystems.spc.ZoneState;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpcSocketHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSocketHandler";
    public LinkedBlockingQueue<SpcCommandWrapper> queuedCommands;
    protected byte[] receivedData = null;
    protected int receivedProtocolId = -1;
    protected int receivedProtocolVersion = -1;
    private Thread receiveThread = null;
    private Thread sendCommandThread = null;
    private final Logger logger;
    private SpcDevice device = null;
    private SpcSrv[] services = null;
    private SpcIoHandler spcIoHandler = null;
    private ServerSocket serverSocket = null;
    private Socket socket = null;
    private int port = Integer.MIN_VALUE;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private ReentrantLock lock = null;
    private Condition commandCondition = null;
    private byte[] responseData = null;
    private byte[] receivedFrameData = null;
    private byte[] responseFrameData = null;
    private byte[] receivedDataContent = null;
    private int receivedMajorFunctionCode = -1;
    private int receivedMinorFunctionCode = -1;
    private SpcCommandWrapper lastSendCommand = null;
    private int sourceId = 0;
    private int destinationId = 0;
    private byte[] sequenceNumberAsByteArray = null;
    private long sequenceNumber = Long.MIN_VALUE;
    private long countQueuedCommands = 0L;
    private boolean connectionEstablish = false;
    private boolean sendReply = true;

    public SpcSocketHandler() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(SpcDevice device, SpcSrv[] services, SpcIoHandler spcIoHandler, SpcDeviceCnf spcDeviceCnf) {
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.services = services;
        if (services == null) {
            return -21601;
        }
        this.spcIoHandler = spcIoHandler;
        if (this.spcIoHandler == null) {
            return -21601;
        }
        try {
            this.port = spcDeviceCnf.getLocalPort();
            this.sourceId = spcDeviceCnf.getSourceId();
            this.destinationId = spcDeviceCnf.getDestinationId();
            this.serverSocket = new ServerSocket(this.port);
            this.serverSocket.setSoTimeout(30000);
        }
        catch (ConfigurationException | IOException exception) {
            this.logger.warn("Error while initializing ServerSocket[" + this.port + "]", exception);
        }
        this.queuedCommands = new LinkedBlockingQueue();
        this.lock = new ReentrantLock();
        this.commandCondition = this.lock.newCondition();
        this.receiveThread = new Thread((Runnable)this, "SPC TCP Receiving " + this);
        this.receiveThread.start();
        return 0;
    }

    @Override
    public void run() {
        try {
            this.initializeConnection();
            this.device.sendResolvedConnectionEvent(this.device.getDeviceID());
            while (!this.isShutdown() || this.device != null && !this.device.isShutdown()) {
                byte frameLength1 = (byte)this.inputStream.read();
                byte frameLength2 = (byte)this.inputStream.read();
                byte[] frameLength = new byte[]{frameLength2, frameLength1};
                byte[] buffer = SpcSocketHandler.byteArrayToInt4((byte[])frameLength) < 0 ? new byte[32768] : new byte[SpcSocketHandler.byteArrayToInt4((byte[])frameLength)];
                int length = this.inputStream.read(buffer);
                if (length < 0) {
                    this.logger.warn("SPC panel cut the connection. Reinitializing socket.");
                    this.socket.close();
                    this.initializeConnection();
                    continue;
                }
                this.receivedData = new byte[length + 2];
                this.receivedData[0] = frameLength1;
                this.receivedData[1] = frameLength2;
                System.arraycopy(buffer, 0, this.receivedData, 2, length);
                this.receiveTcpData();
            }
        }
        catch (Exception exception) {
            this.logger.error("Exception while reading from input stream " + this + ": " + exception.getMessage(), (Throwable)exception);
            if (!this.device.isShutdown()) {
                this.device.sendNotReachableEvent();
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception innerException) {
                this.logger.error("Exception while shutting down socket " + this + ": " + innerException.getMessage(), (Throwable)exception);
            }
        }
        if (this.device != null) {
            this.device.shutdown();
        }
    }

    private void initializeConnection() throws SocketException, IOException {
        this.socket = this.serverSocket.accept();
        this.socket.setSoTimeout(60000);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    private void receiveTcpData() {
        if (this.isShutdown()) {
            return;
        }
        if (this.receivedData == null) {
            this.logger.error("Incoming data is null for " + this);
            return;
        }
        this.parseReceivedData();
        this.analyseReceivedData();
        if (this.sendReply) {
            this.prepareResponse();
            this.completeResponse();
            this.sendTcpData(null, null);
        }
        this.lock.lock();
        try {
            this.commandCondition.signalAll();
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        if (this.connectionEstablish) {
            this.sendCommandThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        SpcSocketHandler.this.logger.error((Object)ex, (Throwable)ex);
                    }
                    SpcSocketHandler.this.queuedCommands.offer(new SpcCommandWrapper(EDPCommands.AREA_STATUS, -1));
                    SpcSocketHandler.this.queuedCommands.offer(new SpcCommandWrapper(EDPCommands.ZONE_STATUS, -1));
                    SpcSocketHandler.this.prepareSendCommand();
                }
            }, "SPC TCP Commands " + this);
            this.sendCommandThread.start();
        }
    }

    protected void parseReceivedData() {
        byte[] frameLength = new byte[]{this.receivedData[1], this.receivedData[0]};
        this.receivedFrameData = new byte[SpcSocketHandler.byteArrayToInt4((byte[])frameLength)];
        System.arraycopy(this.receivedData, 2, this.receivedFrameData, 0, this.receivedFrameData.length);
        this.receivedProtocolId = this.receivedFrameData[0];
        this.receivedProtocolVersion = this.receivedFrameData[1];
        this.sequenceNumberAsByteArray = new byte[]{this.receivedFrameData[6], this.receivedFrameData[5], this.receivedFrameData[4], this.receivedFrameData[3]};
        this.receivedMajorFunctionCode = this.receivedFrameData[15];
        this.receivedMinorFunctionCode = this.receivedFrameData[16];
        byte[] lengthOfDataSection = new byte[]{this.receivedFrameData[20], this.receivedFrameData[19]};
        this.receivedDataContent = new byte[Basic.byteArrayToInt4((byte[])lengthOfDataSection)];
        for (int i = 0; i < this.receivedDataContent.length; ++i) {
            this.receivedDataContent[i] = this.receivedFrameData[21 + i];
        }
    }

    private void analyseReceivedData() {
        if (this.receivedProtocolId == 69 && this.receivedProtocolVersion == 2) {
            if (this.receivedMajorFunctionCode == 1 && this.receivedMinorFunctionCode == 0) {
                ++this.countQueuedCommands;
                this.connectionEstablish = false;
                this.sendReply = true;
            } else if (this.receivedMajorFunctionCode == 1 && this.receivedMinorFunctionCode == 2) {
                this.sequenceNumber = Basic.byteArrayToInt8((byte[])this.sequenceNumberAsByteArray);
                this.connectionEstablish = true;
                this.sendReply = true;
                this.logger.info("MajorFunctionCode: " + this.receivedMajorFunctionCode + " (connection control)");
                this.logger.info("MinorFunctionCode: " + this.receivedMinorFunctionCode + " (tcp establish connection)");
                this.logger.info("SequenceNumber: " + this.sequenceNumber);
            } else if (this.receivedMajorFunctionCode == 2 && this.receivedMinorFunctionCode == 0) {
                ++this.countQueuedCommands;
                this.connectionEstablish = false;
                this.sendReply = true;
                this.logger.info("MajorFunctionCode: " + this.receivedMajorFunctionCode + " (event)");
                this.logger.info("MinorFunctionCode: " + this.receivedMinorFunctionCode + " (sia event)");
                String siaEventContent = new String(this.receivedDataContent);
                siaEventContent = siaEventContent.substring(3, siaEventContent.length() - 1);
                siaEventContent = siaEventContent.replace("|", "%%");
                this.logger.info("SIA Event Content: " + siaEventContent);
                String[] siaData = siaEventContent.split("%%");
                SIACode siaCode = SIACode.getSIACode(siaData[2].toUpperCase());
                String address = siaData[3];
                if (siaCode.getCodeType().equals((Object)SIACodeType.ACTIVE) || siaCode.getCodeType().equals((Object)SIACodeType.INACTIVE)) {
                    if (siaCode.equals((Object)SIACode.CG) || siaCode.equals((Object)SIACode.OG)) {
                        if (siaCode.getCodeType().equals((Object)SIACodeType.ACTIVE)) {
                            this.logger.info("Set Area " + address);
                            this.spcIoHandler.checkInput(Integer.parseInt(address) - 1, 1);
                        } else if (siaCode.getCodeType().equals((Object)SIACodeType.INACTIVE)) {
                            this.logger.info("Unset Area " + address);
                            this.spcIoHandler.checkInput(Integer.parseInt(address) - 1, 0);
                        }
                    }
                } else {
                    for (SpcSrv service : this.services) {
                        if (service == null || !siaCode.getCodeType().equals((Object)SIACodeType.EVENT)) continue;
                        SpcDataWrapper spcData = new SpcDataWrapper(siaCode.getEventCode(), address);
                        service.checkIncomingMessage(spcData);
                    }
                    if (siaData[2].toUpperCase().charAt(0) != 'N' && !this.queuedCommands.contains(new SpcCommandWrapper(EDPCommands.ZONE_STATUS, -1))) {
                        this.queuedCommands.offer(new SpcCommandWrapper(EDPCommands.ZONE_STATUS, -1));
                    }
                }
            } else if (this.receivedMajorFunctionCode == 4 && this.receivedMinorFunctionCode == 2) {
                String[] data;
                ReplyCode replyCode;
                this.connectionEstablish = false;
                this.sendReply = false;
                int numberToContinue = 0;
                this.logger.info("MajorFunctionCode: " + this.receivedMajorFunctionCode + " (panel control)");
                this.logger.info("MinorFunctionCode: " + this.receivedMinorFunctionCode + " (reply)");
                this.logger.info("LastCommand: " + (Object)((Object)this.lastSendCommand.getEdpCommand()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("SequenceNumber: " + this.sequenceNumber);
                    this.logger.info("Data length: " + this.receivedData.length);
                    this.logger.info("Frame data length: " + this.receivedFrameData.length);
                    this.logger.info("Content data length: " + this.receivedDataContent.length);
                    this.logger.info("Content data: " + Basic.byteArrayToHexString((byte[])this.receivedDataContent));
                }
                if ((replyCode = ReplyCode.getReplyCode(this.receivedDataContent[0])).isWarn()) {
                    this.logger.warn(replyCode.getDescription());
                } else {
                    this.logger.info(replyCode.getDescription());
                }
                byte[] newDataContent = new byte[this.receivedDataContent.length - 1];
                System.arraycopy(this.receivedDataContent, 1, newDataContent, 0, newDataContent.length);
                String content = new String(newDataContent);
                for (String lineData : data = content.split("\n")) {
                    lineData = lineData.replace("\t", "%%");
                    String[] contents = lineData.split("%%");
                    if (this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.AREA_SET) || this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.AREA_FORCE_SET)) {
                        if (replyCode != ReplyCode.OK && replyCode != ReplyCode.OK_NOT_COMPLETE) continue;
                        this.spcIoHandler.checkInput(this.lastSendCommand.getNumber() - 1, 1);
                        continue;
                    }
                    if (this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.AREA_UNSET)) {
                        if (replyCode != ReplyCode.OK && replyCode != ReplyCode.OK_NOT_COMPLETE) continue;
                        this.spcIoHandler.checkInput(this.lastSendCommand.getNumber() - 1, 0);
                        continue;
                    }
                    if (this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.AREA_STATUS) || this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.AREA_STATUS_SPECIFIC)) {
                        String areaNumber = contents[0];
                        numberToContinue = Integer.parseInt(areaNumber) + 1;
                        String active = contents[2].substring(0, contents[2].length());
                        if (active.equalsIgnoreCase("0")) {
                            this.logger.info("Unset Area " + areaNumber);
                            this.spcIoHandler.checkInput(Integer.parseInt(areaNumber) - 1, 0);
                            continue;
                        }
                        if (!active.equalsIgnoreCase("3")) continue;
                        this.logger.info("Set Area " + areaNumber);
                        this.spcIoHandler.checkInput(Integer.parseInt(areaNumber) - 1, 1);
                        continue;
                    }
                    if (this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.ZONE_STATUS) || this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.ZONE_STATUS_SPECIFIC)) {
                        if (contents.length == 4) {
                            String zoneNumber = contents[0];
                            numberToContinue = Integer.parseInt(zoneNumber) + 1;
                            String zoneType = contents[1];
                            ZoneState zoneState = ZoneState.valueOf(contents[2]);
                            String zoneName = contents[3];
                            this.logger.info("Zone: " + zoneNumber + " - " + zoneName + " - Type: " + zoneType + " - State: " + (Object)((Object)zoneState));
                            for (SpcSrv service : this.services) {
                                if (service == null) continue;
                                service.updateStatus(zoneNumber, zoneState);
                            }
                            continue;
                        }
                        this.logger.error("SPC Panel sending strange information: " + lineData);
                        this.logger.error("Number of elements: " + contents.length);
                        continue;
                    }
                    if (!this.lastSendCommand.getEdpCommand().equals((Object)EDPCommands.OUTPUT_STATUS)) continue;
                    this.logger.info("Number of outputs: " + newDataContent.length);
                    for (int i = 0; i < newDataContent.length; ++i) {
                        this.logger.info("Output #" + (i + 1) + " - Status: " + newDataContent[i]);
                    }
                }
                if (replyCode == ReplyCode.OK_NOT_COMPLETE) {
                    EDPCommands newCommand = null;
                    if (this.lastSendCommand.getEdpCommand() == EDPCommands.AREA_STATUS_SPECIFIC || this.lastSendCommand.getEdpCommand() == EDPCommands.AREA_STATUS) {
                        newCommand = EDPCommands.AREA_STATUS_SPECIFIC;
                    } else if (this.lastSendCommand.getEdpCommand() == EDPCommands.ZONE_STATUS_SPECIFIC || this.lastSendCommand.getEdpCommand() == EDPCommands.ZONE_STATUS) {
                        newCommand = EDPCommands.ZONE_STATUS_SPECIFIC;
                    }
                    if (newCommand != null && !this.queuedCommands.contains(new SpcCommandWrapper(newCommand, numberToContinue))) {
                        this.logger.info("Requesting status of " + newCommand.name() + " starting at #" + numberToContinue);
                        this.queuedCommands.offer(new SpcCommandWrapper(newCommand, numberToContinue));
                    }
                }
            }
        }
    }

    private void prepareResponse() {
        this.responseData = new byte[this.receivedData.length];
        System.arraycopy(this.receivedData, 0, this.responseData, 0, this.receivedData.length);
        this.responseFrameData = new byte[this.receivedFrameData.length];
        System.arraycopy(this.responseData, 2, this.responseFrameData, 0, this.responseFrameData.length);
        this.responseData[2] = 8;
        byte[] destinationIdAsArray = Basic.int4ToByteArray((int)this.destinationId);
        byte[] destinationIdLittleEndian = this.getLittleEndianValue(destinationIdAsArray);
        System.arraycopy(destinationIdLittleEndian, 0, this.responseFrameData, 7, 4);
        byte[] sourceIdLittleEndian = this.getLittleEndianValue(Basic.int4ToByteArray((int)this.sourceId));
        System.arraycopy(sourceIdLittleEndian, 0, this.responseFrameData, 11, 4);
        if (this.receivedMajorFunctionCode == 1 && this.receivedMinorFunctionCode == 0) {
            this.responseFrameData[16] = 1;
        } else if (this.receivedMajorFunctionCode == 1 && this.receivedMinorFunctionCode == 2) {
            this.responseFrameData[16] = 3;
        } else if (this.receivedMajorFunctionCode == 2 && this.receivedMinorFunctionCode == 0) {
            this.responseFrameData[16] = 1;
        } else if (this.receivedMajorFunctionCode == 4 && this.receivedMinorFunctionCode == 2) {
            this.logger.debug("Reply from SPC needs no response from us");
        }
    }

    private void completeResponse() {
        this.responseFrameData[17] = 0;
        this.responseFrameData[18] = 0;
        int crcValue = this.calcCrc(this.responseFrameData);
        byte[] newCrc = SpcSocketHandler.int4ToByteArray((int)crcValue);
        byte[] newCrcLittleEndian = this.getLittleEndianValue(newCrc);
        System.arraycopy(newCrcLittleEndian, 0, this.responseFrameData, 17, 2);
        System.arraycopy(this.responseFrameData, 0, this.responseData, 2, this.responseFrameData.length);
    }

    private void prepareSendCommand() {
        while (!this.isShutdown() || this.device != null && !this.device.isShutdown()) {
            try {
                SpcCommandWrapper take = this.queuedCommands.take();
                Thread.sleep(500L);
                this.sendCommand(take);
            }
            catch (InterruptedException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private void sendCommand(SpcCommandWrapper command) {
        int headerLength = 21;
        int packetLength = 21 + command.getEdpCommand().getContentLength();
        byte[] requestData = new byte[packetLength];
        requestData[0] = 69;
        requestData[1] = 2;
        requestData[2] = 8;
        this.sequenceNumber += this.countQueuedCommands;
        ++this.sequenceNumber;
        if (this.sequenceNumber >= 0xFFFFFFFFL) {
            this.sequenceNumber -= 0xFFFFFFFFL;
        }
        byte[] incrementedSequenceNumber = Basic.int8ToByteArray((long)this.sequenceNumber);
        System.arraycopy(this.getLittleEndianValue(incrementedSequenceNumber), 0, requestData, 3, 4);
        System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)this.destinationId)), 0, requestData, 7, 4);
        System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)this.sourceId)), 0, requestData, 11, 4);
        requestData[15] = 4;
        requestData[16] = 0;
        requestData[17] = 0;
        requestData[18] = 0;
        System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)command.getEdpCommand().getContentLength())), 0, requestData, 19, 2);
        requestData[21] = (byte)command.getEdpCommand().getValue();
        if (EDPCommands.AREA_SET == command.getEdpCommand() || EDPCommands.AREA_FORCE_SET == command.getEdpCommand() || EDPCommands.AREA_UNSET == command.getEdpCommand() || EDPCommands.ZONE_ISOLATE == command.getEdpCommand() || EDPCommands.ZONE_DEISOLATE == command.getEdpCommand() || EDPCommands.ZONE_INHIBIT == command.getEdpCommand() || EDPCommands.ZONE_DEINHIBIT == command.getEdpCommand() || EDPCommands.OUTPUT_SET == command.getEdpCommand() || EDPCommands.OUTPUT_RESET == command.getEdpCommand()) {
            System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)command.getNumber())), 0, requestData, 22, 2);
        } else if (EDPCommands.AREA_STATUS_SPECIFIC == command.getEdpCommand() || EDPCommands.ZONE_STATUS_SPECIFIC == command.getEdpCommand()) {
            System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)command.getNumber())), 0, requestData, 22, 2);
            System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)(command.getNumber() + 1000))), 0, requestData, 24, 2);
        }
        System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)this.calcCrc(requestData))), 0, requestData, 17, 2);
        byte[] fullData = new byte[2 + packetLength];
        System.arraycopy(this.getLittleEndianValue(Basic.int4ToByteArray((int)packetLength)), 0, fullData, 0, 2);
        System.arraycopy(requestData, 0, fullData, 2, packetLength);
        this.countQueuedCommands = 0L;
        this.sendTcpData(fullData, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTcpData(byte[] data, SpcCommandWrapper command) {
        if (data != null) {
            this.lock.lock();
            try {
                this.outputStream.write(data);
                this.outputStream.flush();
                this.lastSendCommand = command;
                this.commandCondition.await();
            }
            catch (Exception exception) {
                this.logger.warn("Error while sending data to [" + this.serverSocket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "] Reason: [" + exception.getMessage() + "]");
            }
            finally {
                if (this.lock.isHeldByCurrentThread()) {
                    this.lock.unlock();
                }
            }
        } else {
            try {
                this.outputStream.write(this.responseData);
                this.outputStream.flush();
            }
            catch (IOException exception) {
                this.logger.warn("Error while sending data to [" + this.serverSocket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "]");
                this.logger.warn((Object)exception, (Throwable)exception);
            }
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        int errorCode = 0;
        if (this.startShutdown(CLASS_NAME)) {
            return errorCode;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException exception) {
            if (this.socket != null) {
                this.logger.warn("Error while shutting down Socket[" + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "]");
            } else {
                this.logger.warn("Error while shutting down Socket");
            }
            this.logger.warn((Object)exception, (Throwable)exception);
        }
        this.outputStream = null;
        this.inputStream = null;
        this.socket = null;
        this.serverSocket = null;
        this.lock = null;
        this.commandCondition = null;
        this.queuedCommands = null;
        return 0;
    }

    private int calcCrc(byte[] data) {
        int hl;
        int lo = 255;
        int hi = 255;
        for (int i = 0; i < data.length; ++i) {
            if (i == 17 || i == 18) continue;
            int c = hi;
            hl = (hi << 8) + lo;
            lo = (byte)((hl <<= 1) % 256);
            hi = hl / 256 & 0xFF;
            lo = lo + data[i] & 0xFF;
            if ((c & 0x80) <= 0) continue;
            lo ^= 0x97;
            hi ^= 0xA0;
        }
        hl = (hi << 8) + lo;
        return hl;
    }

    protected byte[] getLittleEndianValue(byte[] data) {
        byte[] littleEndianValue = new byte[data.length];
        for (int i = 0; i < littleEndianValue.length; ++i) {
            littleEndianValue[i] = data[data.length - 1 - i];
        }
        return littleEndianValue;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSocketHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.device + "]";
    }
}

