/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.spc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcAreaSrv;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcOutputSrv;
import de.seetec.v5.re.cm.device.alarmsystems.spc.SpcSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.ArrayList;
import java.util.List;

public class SpcIoHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.spc.SpcIoHandler";
    private List<SpcSrv> services;
    private final List<SpcAreaSrv> iServices = new ArrayList<SpcAreaSrv>();
    private final List<SpcOutputSrv> oServices = new ArrayList<SpcOutputSrv>();
    private int highestInputNumber = 0;
    private int highestOutputNumber = 0;

    @Override
    public int init(Core core, Device device, Entity[] srvEnities, boolean ignoreSomeParameter) {
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        if (srvEnities == null) {
            return -21601;
        }
        try {
            this.authorization = this.device.getDeviceCnf().getUseAuthorization();
            this.usr = this.device.getDeviceCnf().getUser();
            this.pwd = this.device.getDeviceCnf().getPassword();
        }
        catch (ConfigurationException cex) {
            this.logger.error((Object)cex, (Throwable)cex);
            return -21602;
        }
        for (Entity entity : srvEnities) {
            int errorCode;
            SpcSrv service;
            boolean enabled = entity.isEnabled();
            long srvType = entity.getEntityType();
            if (!enabled) continue;
            if (srvType == 9815L || srvType == 9816L) {
                service = new SpcAreaSrv();
                errorCode = ((SpcAreaSrv)service).init(core, device, this, entity);
                if (errorCode != 0) {
                    this.logger.error("Initializing " + service + " failed with error [" + errorCode + "] ...");
                    return errorCode;
                }
                if (((SpcAreaSrv)service).getAreaNumber() > this.highestInputNumber) {
                    this.highestInputNumber = ((SpcAreaSrv)service).getAreaNumber();
                }
                this.iServices.add((SpcAreaSrv)service);
                ((SpcAreaSrv)service).checkInput(-2);
                continue;
            }
            if (srvType != 9911L && srvType != 9912L) continue;
            service = new SpcOutputSrv();
            errorCode = ((SpcOutputSrv)service).init(core, device, this, entity);
            if (errorCode != 0) {
                this.logger.error("Initializing " + service + " failed with error [" + errorCode + "] ...");
                return errorCode;
            }
            if (((SpcOutputSrv)service).getOutputNumber() > this.highestOutputNumber) {
                this.highestOutputNumber = ((SpcOutputSrv)service).getOutputNumber();
            }
            this.oServices.add((SpcOutputSrv)service);
            ((SpcOutputSrv)service).checkOutput(0);
        }
        this.services = new ArrayList<SpcSrv>();
        for (Entity srvEnitity : srvEnities) {
            SpcSrv spcSrv;
            if (!srvEnitity.isEnabled().booleanValue() || (spcSrv = new SpcSrv()).init(core, device, srvEnitity) != 0) continue;
            core.registerToSRPCDispatcher(this, srvEnitity.getEntityID());
            this.services.add(spcSrv);
        }
        return 0;
    }

    @Override
    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.services.stream().filter(service -> service.hasAction(actionID)).forEach(service -> service.triggerAction(actionID));
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        return 0;
    }

    public final void checkInput(int area, int active) {
        if (this.iServices.size() > 0 && this.iServices.size() > area * 2 + 1) {
            this.iServices.get(2 * area).checkInput(active);
            this.iServices.get(2 * area + 1).checkInput(active);
        }
    }

    @Override
    protected int discard() {
        return 0;
    }

    public List<SpcAreaSrv> getAreas() {
        return this.iServices;
    }

    public List<SpcOutputSrv> getOutputs() {
        return this.oServices;
    }
}

