/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.ats;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSDevice;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSDeviceCnf;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSSrv;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSSrvCnf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ATSSocketHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.seetec.ats.ATSSocketHandler";
    private Thread myThread = null;
    private final Logger logger;
    private Core core = null;
    private ATSDevice device = null;
    private ATSSrv[] services = null;
    private ServerSocket serverSocket = null;
    private Socket socket = null;
    private int port = Integer.MIN_VALUE;
    private InputStream inputStream = null;
    private int configuredCentralId = Integer.MIN_VALUE;

    public ATSSocketHandler(Core core, ATSDevice device, ATSSrv[] services, ATSDeviceCnf atsDeviceCnf) throws SeeTecException {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21601, "Core parameter null.");
        }
        this.device = device;
        if (this.device == null) {
            throw new SeeTecException(-21601, "Device parameter null.");
        }
        this.services = services;
        if (services == null) {
            throw new SeeTecException(-21601, "Services parameter null.");
        }
        try {
            this.port = atsDeviceCnf.getOhPort();
            this.configuredCentralId = atsDeviceCnf.getCentralId();
            this.logger.info("OH Port: " + this.port);
            this.serverSocket = new ServerSocket(this.port);
            this.serverSocket.setSoTimeout(0);
        }
        catch (ConfigurationException exception) {
            this.logger.warn("Error while initializing ServerSocket[" + this.port + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            this.logger.warn("Error while initializing ServerSocket[" + this.port + "]", (Throwable)exception);
        }
    }

    public void init() {
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
    }

    @Override
    public void run() {
        this.setRunFinished(CLASS_NAME, false);
        try {
            if (this.serverSocket == null) {
                this.shutdown();
                return;
            }
            this.logger.info("ATS Socket Handler ready for connection...");
            this.socket = this.serverSocket.accept();
            this.logger.info("ATS Socket Handler accepted connection from " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort());
            this.socket.setSoTimeout(0);
            this.inputStream = this.socket.getInputStream();
            byte[] buffer = new byte[256];
            while (!this.isShutdown()) {
                this.logger.info("Check for input...");
                int length = this.inputStream.read(buffer);
                if (length < 0) {
                    this.logger.info("length < 0 -> break");
                    break;
                }
                this.handleData(Arrays.copyOf(buffer, length));
            }
        }
        catch (IOException exception) {
            this.logger.error("Exception while reading from input stream " + this + ": " + exception.getMessage(), (Throwable)exception);
            try {
                this.socket.close();
            }
            catch (IOException innerException) {
                this.logger.error("Exception while shutting down socket " + this + ": " + innerException.getMessage(), (Throwable)exception);
            }
            this.shutdown();
        }
        this.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected void handleData(byte[] data) {
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null for " + this);
            return;
        }
        String siaEventContent = null;
        try {
            siaEventContent = new String(data);
            this.logger.info("---> New message received: " + siaEventContent);
            if (siaEventContent.contains("SIA")) {
                siaEventContent = siaEventContent.substring(siaEventContent.indexOf("[", siaEventContent.indexOf("SIA")) + 2, siaEventContent.length() - 1);
                String centralId = siaEventContent.substring(0, siaEventContent.indexOf("|"));
                String siaMessage = siaEventContent.substring(siaEventContent.indexOf("|") + 1);
                if (Integer.parseInt(centralId) == this.configuredCentralId) {
                    int area = this.parseArea(siaMessage);
                    String siaCode = siaMessage.substring(siaMessage.length() - 5, siaMessage.length() - 3);
                    String group = siaMessage.substring(siaMessage.length() - 3, siaMessage.length());
                    this.logger.info("Received SIA Message (Details) -> CentralId: " + centralId + " | Area: " + area + " | SiaCode: " + siaCode + " | Zone/Group: " + group);
                    for (ATSSrv service : this.services) {
                        ATSSrvCnf atsSrvCnf;
                        if (service == null || (long)area != (atsSrvCnf = service.getSrvCnf()).getArea() || (long)Integer.parseInt(group) != atsSrvCnf.getZone()) continue;
                        this.logger.info("Matching area and zone/group: Configured Area: " + atsSrvCnf.getArea() + " | configured Zone/Group: " + atsSrvCnf.getZone());
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("SeeTec configuration: Alarm(BA): ").append(atsSrvCnf.getEventsAlarm());
                        stringBuilder.append(" | Tampered(TA): ").append(atsSrvCnf.getEventsTampered());
                        stringBuilder.append(" | Armed(CL): ").append(atsSrvCnf.getEventsArmed());
                        stringBuilder.append(" | Disarmed(OP): ").append(atsSrvCnf.getEventsDisarmed());
                        stringBuilder.append(" | Mask(BT): ").append(atsSrvCnf.getEventsMask());
                        stringBuilder.append(" | Excluded(BB): ").append(atsSrvCnf.getEventsExcluded());
                        stringBuilder.append(" | ArmForced(CF): ").append(atsSrvCnf.getEventsArmForced());
                        this.logger.info((CharSequence)stringBuilder);
                        if (!(siaCode.equals("CL") && atsSrvCnf.getEventsArmed() || siaCode.equals("OP") && atsSrvCnf.getEventsDisarmed() || siaCode.equals("BA") && atsSrvCnf.getEventsAlarm() || siaCode.equals("CF") && atsSrvCnf.getEventsArmForced() || siaCode.equals("BB") && atsSrvCnf.getEventsExcluded() || siaCode.equals("BT") && atsSrvCnf.getEventsMask()) && (!siaCode.equals("TA") || !atsSrvCnf.getEventsTampered())) continue;
                        this.logger.info("We have a SIA match -> send event");
                        long serviceId = service.getEntity().getEntityID();
                        this.sendEvent(serviceId);
                    }
                } else {
                    this.logger.warn("CentralID is not correct. Should be " + centralId + " but is " + this.configuredCentralId);
                }
            }
        }
        catch (ConfigurationException | IndexOutOfBoundsException | NumberFormatException exception) {
            this.logger.warn("Error while processing data (" + siaEventContent + ") from [" + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "]", exception);
        }
    }

    private int parseArea(String siaMessage) throws NumberFormatException {
        int area;
        if (siaMessage.contains("/")) {
            String areaString = siaMessage.substring(3, siaMessage.indexOf("/"));
            area = Integer.parseInt(areaString);
        } else {
            area = 1;
        }
        return area;
    }

    private void sendEvent(long srvEntityID) {
        this.core.sendApplicationEvent(srvEntityID);
    }

    private boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        int errorCode = 0;
        if (this.startShutdown(CLASS_NAME)) {
            return errorCode;
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException exception) {
            if (this.socket != null) {
                this.logger.warn("Error while shutting down Socket[" + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "]");
            } else {
                this.logger.warn("Error while shutting down Socket");
            }
            this.logger.warn((Object)exception, (Throwable)exception);
        }
        this.serverSocket = null;
        for (ATSSrv service : this.services) {
            if (service == null || (errorCode = service.shutdown()) == 0) continue;
            this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
        }
        if (this.device != null) {
            errorCode = this.device.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + this.device + " failed with error [" + errorCode + "]");
            }
            this.device = null;
        }
        return 0;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.seetec.ats.ATSSocketHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.device + "]";
    }
}

