/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.alarmsystems.ats;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSDeviceCnf;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSSocketHandler;
import de.seetec.v5.re.cm.device.alarmsystems.ats.ATSSrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class ATSDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.ats.ATSDevice";
    private ATSSocketHandler atsSocketHandler = null;
    private ATSDeviceCnf deviceCnf = null;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.deviceCnf = new ATSDeviceCnf();
        errorCode = this.deviceCnf.init(this.getDeviceEntity());
        if (errorCode != 0) {
            this.logger.error("Creating [ATSDeviceCnf] failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        Entity[] srvEntities = super.getSrvEntities();
        this.services = new ATSSrv[srvEntities.length];
        for (int i = 0; i < srvEntities.length; ++i) {
            Entity entity = srvEntities[i];
            boolean bEnabled = entity.isEnabled();
            if (!bEnabled) continue;
            ATSSrv service = new ATSSrv();
            errorCode = service.init(this.core, this, entity);
            if (errorCode != 0) {
                this.logger.error("Creating " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
            this.services[i] = service;
        }
        try {
            this.atsSocketHandler = new ATSSocketHandler(this.core, this, (ATSSrv[])this.services, this.deviceCnf);
            this.atsSocketHandler.init();
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Initializing [ATSSocketHandler] failed with error [" + seeTecException.getErrorCode() + "] :-(");
            return seeTecException.getErrorCode();
        }
        this.logger.info(this + " initialized.");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.atsSocketHandler != null && (errorCode = this.atsSocketHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + this.atsSocketHandler + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        if (this.services != null) {
            for (Service service : this.services) {
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
            }
        }
        this.deviceCnf = null;
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long nAlarmDuration, byte[] genericData) {
        this.logger.error("NOT YET IMPLEMENTED for " + this + " :-(");
        return -21600;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        return 0;
    }

    @Override
    protected final IOHandler createIOHandler() {
        return null;
    }

    @Override
    protected final boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

