/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.accesscontrol.tdsi;

import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIDataWrapper;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIDevice;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSISrv;
import de.seetec.v5.shared.Basic;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TDSIFileHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.tdsi.TDSIFileHandler";
    private Thread myThread = null;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private TDSIDevice device = null;
    private TDSISrv[] services = null;
    private String location = null;
    private String delimiter = null;

    public int init(TDSIDevice device, TDSISrv[] services) {
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.services = services;
        if (services == null) {
            return -21601;
        }
        try {
            this.location = device.getDeviceCnf().getGenericParameter("ExportDirectory").trim();
            this.delimiter = device.getDeviceCnf().getGenericParameter("ExportDelimiter").trim();
            this.logger.info("Using location '" + this.location + "' with delimiter '" + this.delimiter + "' for " + device);
        }
        catch (Exception e) {
            this.logger.error("Error reading configuration from " + device);
        }
        try {
            File dir = new File(this.location);
            if (!dir.exists() || !dir.canRead()) {
                this.logger.error("Location '" + this.location + "' not existent or not readable.");
                return -20020;
            }
            if (!dir.isDirectory()) {
                this.logger.error("Location '" + this.location + "' is not a directoy.");
                return -20022;
            }
            try {
                File testFile = new File(this.location + File.separator + "SeeTec5TestFile");
                if (!testFile.createNewFile()) {
                    this.logger.warn("Creating test file not successful.");
                }
                if (!testFile.delete()) {
                    this.logger.error("Error while deleting test file on " + this.location);
                    return -20022;
                }
            }
            catch (Exception e) {
                this.logger.error("Error while checking write access to " + this.location);
                return -20022;
            }
        }
        catch (Exception e) {
            this.logger.error("Error while checking if we can read from: " + this.location);
            return -20020;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String separator = this.delimiter;
        File dir = new File(this.location);
        File[] files = null;
        BufferedReader reader = null;
        String text = null;
        String[] parts = null;
        int eventType = Integer.MIN_VALUE;
        long genericID1 = Long.MIN_VALUE;
        long genericID2 = Long.MIN_VALUE;
        long genericID3 = Long.MIN_VALUE;
        long genericID4 = Long.MIN_VALUE;
        try {
            while (!this.isShutdown()) {
                long startOfTurn = System.currentTimeMillis();
                files = dir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            reader = new BufferedReader(new FileReader(files[i]));
                            text = reader.readLine();
                            if (text != null) {
                                parts = text.split(separator, -1);
                                if (parts.length <= 1) {
                                    this.logger.error("File '" + files[i] + "' is NOT separated by '" + separator + "'. Discard file.");
                                    this.logger.error("Contains: " + text);
                                    continue;
                                }
                                if (parts.length == 16) {
                                    try {
                                        eventType = Integer.parseInt(parts[8]);
                                    }
                                    catch (NumberFormatException nfe) {
                                        this.logger.error("Error while converting eventType into number: " + parts[8]);
                                        eventType = Integer.MIN_VALUE;
                                    }
                                    try {
                                        genericID1 = parts[10].length() > 0 ? Long.parseLong(parts[10]) : Long.MIN_VALUE;
                                        genericID2 = parts[11].length() > 0 ? Long.parseLong(parts[11]) : Long.MIN_VALUE;
                                        genericID3 = parts[12].length() > 0 ? Long.parseLong(parts[12]) : Long.MIN_VALUE;
                                        genericID4 = parts[13].length() > 0 ? Long.parseLong(parts[13]) : Long.MIN_VALUE;
                                    }
                                    catch (NumberFormatException nfe) {
                                        this.logger.error("Error while converting generic IDs into number: " + parts[10] + "," + parts[11] + "," + parts[12] + "," + parts[13]);
                                    }
                                    String eventDescription = parts[1].length() == 0 ? null : parts[1].trim();
                                    String source = parts[2].length() == 0 ? null : parts[2].trim();
                                    String detail1 = parts[3].length() == 0 ? null : parts[3].trim();
                                    String detail2 = parts[4].length() == 0 ? null : parts[4].trim();
                                    String detail3 = parts[5].length() == 0 ? null : parts[5].trim();
                                    String genericText = parts[14].length() == 0 ? null : parts[14].trim();
                                    TDSIDataWrapper data = new TDSIDataWrapper(eventType, eventDescription, source, detail1, detail2, detail3, genericID1, genericID2, genericID3, genericID4, genericText);
                                    for (int j = 0; j < this.services.length; ++j) {
                                        if (this.services[j] == null) continue;
                                        this.services[j].checkIncomingMessage(data);
                                    }
                                    continue;
                                }
                                this.logger.error("Syntax of alarm is not following the API (16 parts)");
                                this.logger.error("Received alarm is: " + text);
                                continue;
                            }
                            this.logger.error("File '" + files[i] + "' has a blank for line. Discard file.");
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            this.logger.error("File '" + files[i] + "' not found. Should be a theoretical case. Discard file.");
                            continue;
                        }
                        catch (IOException e) {
                            this.logger.error("File '" + files[i] + "' not accessible. Discard file.", (Throwable)e);
                            continue;
                        }
                        finally {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                if (!files[i].delete()) {
                                    this.logger.error("File '" + files[i] + "' could not be deleted.");
                                }
                            }
                            catch (IOException e) {
                                this.logger.error("File '" + files[i] + "' could not be deleted.");
                            }
                        }
                    }
                } else {
                    this.logger.error("Given location '" + this.location + "' is not a directory or we have an IO error.");
                    continue;
                }
                long now = System.currentTimeMillis();
                if (startOfTurn + 500L <= now) continue;
                Thread.sleep(startOfTurn + 500L - now);
            }
        }
        catch (Throwable t) {
            this.logger.error("Unexpected error in while for " + this, t);
            this.shutdown();
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        int errorCode = 0;
        if (this.startShutdown(CLASS_NAME)) {
            return errorCode;
        }
        for (TDSISrv service : this.services) {
            if (service == null || (errorCode = service.shutdown()) == 0) continue;
            this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
        }
        if (this.device != null) {
            errorCode = this.device.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + this.device + " failed with error [" + errorCode + "] :-(");
            }
            this.device = null;
        }
        this.location = null;
        this.delimiter = null;
        return 0;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.alarmsystems.tdsi.TDSIFileHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.device + "]";
    }
}

