/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.accesscontrol.tdsi;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIDeviceCnf;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSIFileHandler;
import de.seetec.v5.re.cm.device.accesscontrol.tdsi.TDSISrv;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class TDSIDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.alarmsystems.tdsi.TDSIDevice";
    private TDSIFileHandler tdsiFileHandler = null;
    private TDSIDeviceCnf srvCnf = null;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = 0;
        errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.srvCnf = new TDSIDeviceCnf();
        errorCode = this.srvCnf.init(this.getDeviceEntity());
        if (errorCode != 0) {
            this.logger.error("Creating [TDSIDeviceCnf] failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        Entity[] srvEnities = super.getSrvEntities();
        this.services = new TDSISrv[srvEnities.length];
        for (int i = 0; i < srvEnities.length; ++i) {
            Entity entity = srvEnities[i];
            boolean bEnabled = entity.isEnabled();
            if (!bEnabled) continue;
            TDSISrv service = new TDSISrv();
            errorCode = service.init(this.core, this, entity);
            if (errorCode != 0) {
                this.logger.error("Creating " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
            this.services[i] = service;
        }
        this.tdsiFileHandler = new TDSIFileHandler();
        errorCode = this.tdsiFileHandler.init(this, (TDSISrv[])this.services);
        if (errorCode != 0) {
            this.logger.error("Initializing [TDSIFileHandler] failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        this.logger.info(this + " initialized.");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        int errorCode = 0;
        if (this.tdsiFileHandler != null && (errorCode = this.tdsiFileHandler.shutdown()) != 0) {
            this.logger.error("Shtudown of " + this.tdsiFileHandler + " failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        if (this.services != null) {
            this.logger.info("Shutting down [" + this.services.length + "] services ...");
            for (int i = 0; i < this.services.length; ++i) {
                Service service = this.services[i];
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] :-(");
            }
        }
        this.srvCnf = null;
        return super.shutdown();
    }

    public final TDSIDeviceCnf getTDSIDeviceCnf() {
        return this.srvCnf;
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long nAlarmDuration, byte[] genericData) {
        this.logger.error("NOT YET IMPLEMENTED for " + this + " :-(");
        return -21600;
    }

    protected final TDSIFileHandler getTDSIFileHandler() {
        return this.tdsiFileHandler;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        return 0;
    }

    @Override
    protected final IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected final boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

