/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.EntityLocationCache;
import de.seetec.v5.re.shared.CoreServiceWrapper;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ReadThroughEntityLocationCache
implements EntityLocationCache {
    private final Map<Long, Location> entityLocations = new ConcurrentHashMap<Long, Location>();
    private final CoreServiceWrapper coreServiceWrapper;

    public ReadThroughEntityLocationCache(CoreServiceWrapper coreServiceWrapper) {
        this.coreServiceWrapper = coreServiceWrapper;
    }

    @Override
    public void add(long id, Location location) throws SeeTecException {
        if (location == null) {
            throw new SeeTecException(-20002, "Location null");
        }
        this.entityLocations.put(id, location);
    }

    @Override
    public Location remove(long id) {
        return this.entityLocations.remove(id);
    }

    @Override
    public Location get(long id) throws SeeTecException {
        Location location = this.entityLocations.get(id);
        if (location == null) {
            location = this.coreServiceWrapper.getEntMgrProxy().locateEntityByID(Long.valueOf(id), TimeUnit.SECONDS.toMillis(20L));
            this.add(id, location);
        }
        return location;
    }
}

