/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepositoryListener;
import de.seetec.v5.re.cm.configuration.qognifymetadatamanager.MetadataManager;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.configuration.events.entity.EntityEvent;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class QognifyMetadataManagerRepositoryImpl
implements QognifyMetadataManagerRepository {
    private final Logger logger;
    private final Core core;
    private MetadataManager metadataManager = null;
    private final ReentrantReadWriteLock lock;
    private final List<QognifyMetadataManagerRepositoryListener> listeners = new ArrayList<QognifyMetadataManagerRepositoryListener>();

    public QognifyMetadataManagerRepositoryImpl(Core core) throws SeeTecException {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.lock = new ReentrantReadWriteLock();
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-20002, "Argument for QognifyMetadataManagerRepositoryImpl is null");
        }
        this.readMetadataManagerConfiguration();
    }

    @Override
    public void addListener(QognifyMetadataManagerRepositoryListener listener) {
        if (listener != null) {
            this.lock.writeLock().lock();
            try {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void removeListener(QognifyMetadataManagerRepositoryListener listener) {
        if (listener != null) {
            this.lock.writeLock().lock();
            try {
                this.listeners.remove(listener);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void readMetadataManagerConfiguration() throws SeeTecException {
        Entity[] metadataManagers = this.core.getEntMgrProxy().getEntitiesAsList(Arrays.asList(122L), Boolean.TRUE, TimeUnit.SECONDS.toMillis(60L));
        if (metadataManagers.length > 0) {
            try {
                this.metadataManager = (MetadataManager)Basic.unmarshalXML(MetadataManager.class, (Object)metadataManagers[0].getConfiguration());
            }
            catch (JAXBException | SAXException exception) {
                throw new SeeTecException(-20000, "Exception parsing MetadataManager's configuration: " + exception.getMessage());
            }
        }
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public void notify(ReqNotify request) {
        if (request.getEventType().longValue() != EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType()) {
            return;
        }
        try {
            EntityEvent result = (EntityEvent)Basic.unmarshalXML(EntityEvent.class, (Object)Basic.addRootTag((byte[])request.getData()), (boolean)true);
            if (result.getEntityType() != 122L) {
                return;
            }
            this.readMetadataManagerConfiguration();
            this.lock.readLock().lock();
            try {
                this.listeners.forEach(listener -> listener.configurationChanged());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (SeeTecException | JAXBException | SAXException exception) {
            this.logger.error("Error reading MetadataManager's configuration: " + exception.getMessage());
        }
    }
}

