/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.NativeImport;
import de.seetec.v5.re.shared.srpc.ReqGetImportInfo;
import de.seetec.v5.re.shared.srpc.ReqGetImportPaths;
import de.seetec.v5.re.shared.srpc.RspGetImportInfo;
import de.seetec.v5.re.shared.srpc.RspGetImportPaths;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;

public class NativeImportImpl
implements NativeImport {
    private final DatabaseProxy databaseProxy;

    public NativeImportImpl(DatabaseProxy databaseProxy) throws SeeTecException {
        this.databaseProxy = databaseProxy;
        if (this.databaseProxy == null) {
            throw new SeeTecException(-21601, "DatabaseProxy null");
        }
    }

    public RspGetImportInfo getImportInfo(ReqGetImportInfo request) throws SeeTecException {
        try {
            SrpcMessage response = this.databaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETIMPORTINFO, (GObject)request.createGObject()), request.getTimeout());
            return RspGetImportInfo.parseGObject((GObject)response.getPayload());
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }

    public RspGetImportPaths getImportPaths(ReqGetImportPaths request) throws SeeTecException {
        try {
            SrpcMessage response = this.databaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETIMPORTPATHS, (GObject)request.createGObject()), request.getTimeout());
            return RspGetImportPaths.parseGObject((GObject)response.getPayload());
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }
}

