/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.NativeExportDownloadHandlerClient;
import de.seetec.v5.re.cm.NativeExportStartDownloadHandler;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.srpc.ReqStartExportDownload;
import de.seetec.v5.re.shared.srpc.RspStartExportDownload;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NativeExportStartDownloadHandlerImpl
implements NativeExportStartDownloadHandler {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final DatabaseProxy databaseProxy;

    public NativeExportStartDownloadHandlerImpl(DatabaseProxy databaseProxy) {
        this.databaseProxy = databaseProxy;
    }

    @Override
    public void start(ReqStartExportDownload request, NativeExportDownloadHandlerClient nativeExportDownloadHandlerClient) throws SeeTecException {
        this.logger.info("Starting export download: " + request);
        try {
            SrpcMessage responseFailover = this.databaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_STARTEXPORTDOWNLOAD, (GObject)request.createGObject()), TimeUnit.SECONDS.toMillis(30L));
            RspStartExportDownload rspStartExportDownloadFailover = RspStartExportDownload.parseGObject((GObject)responseFailover.getPayload());
            Future<Integer> result = nativeExportDownloadHandlerClient.init(request.getSequenceID(), rspStartExportDownloadFailover.getFileList());
            int resultOfDownloading = result.get();
            if (resultOfDownloading != 0) {
                throw new SeeTecException(resultOfDownloading, "Error while downloading from failover MDS.");
            }
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20022, "Can't access file");
        }
    }
}

