/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.FailoverHelper;
import de.seetec.v5.re.cm.NativeErrorExportCombiner;
import de.seetec.v5.re.cm.NativeExportFailoverRunner;
import de.seetec.v5.re.cm.NativeExportFailoverStatus;
import de.seetec.v5.re.cm.NativeExportFailoverVolume;
import de.seetec.v5.re.cm.NativeExportGapsFinder;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.FailoverConfiguration;
import de.seetec.v5.re.shared.NativeExport;
import de.seetec.v5.re.shared.NativeExportDownloadHandler;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.srpc.ReqCancelExportDownload;
import de.seetec.v5.re.shared.srpc.ReqCheckTemporaryDirectory;
import de.seetec.v5.re.shared.srpc.ReqDiscardFailedBackup;
import de.seetec.v5.re.shared.srpc.ReqRetryBackup;
import de.seetec.v5.re.shared.srpc.ReqStartExport;
import de.seetec.v5.re.shared.srpc.ReqStartExportDownload;
import de.seetec.v5.re.shared.srpc.RspCheckTemporaryDirectory;
import de.seetec.v5.re.shared.srpc.RspGetFailedBackups;
import de.seetec.v5.re.shared.srpc.RspGetStatusExport;
import de.seetec.v5.re.shared.srpc.RspStartExport;
import de.seetec.v5.re.shared.srpc.RspStartExportDownload;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NativeExportImpl
implements NativeExport,
NativeExportFailoverStatus {
    private final Logger logger;
    private final DatabaseProxy localDatabaseProxy;
    private final Core core;
    private final NativeExportGapsFinder nativeExportGapsFinder;
    private final ConfigurationProvider configurationProvider;
    private final FailoverHelper failoverHelper;
    private RspStartExport lastStartedExportResponseLocalDatabase = null;
    private RspStartExport lastStartedExportResponseFailover = null;
    private long lastStartedExportContentId = -1L;
    private int numberOfGapsInLocalDatabase = 0;
    private List<RspStartExport> failoverExportsFinished = new ArrayList<RspStartExport>();
    private NativeExportFailoverVolume failoverExportsVolume = new NativeExportFailoverVolume();
    private NativeExportDownloadHandler exportDownloadHandler = null;
    private NativeExportFailoverRunner failoverExportWorker = null;

    public NativeExportImpl(DatabaseProxy[] mdsProxies, Core core, ConfigurationProvider configurationProvider, NativeExportGapsFinder nativeExportGapsFinder) throws SeeTecException {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        if (mdsProxies == null) {
            throw new SeeTecException(-21601, "DatabaseProxy null");
        }
        this.localDatabaseProxy = mdsProxies[0];
        if (this.localDatabaseProxy == null) {
            throw new SeeTecException(-21601, "DatabaseProxy null");
        }
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21601, "Core null");
        }
        this.failoverHelper = new FailoverHelper(core, mdsProxies[1]);
        this.configurationProvider = configurationProvider;
        if (this.configurationProvider == null) {
            throw new SeeTecException(-21601, "ConfigurationProvider null");
        }
        this.nativeExportGapsFinder = nativeExportGapsFinder;
        if (this.nativeExportGapsFinder == null) {
            throw new SeeTecException(-21601, "ConfigurationProvider null");
        }
    }

    public void shutdown() {
        if (this.exportDownloadHandler != null) {
            this.exportDownloadHandler.shutdown();
        }
        if (this.failoverExportWorker != null) {
            this.failoverExportWorker.cancel();
        }
    }

    public RspGetFailedBackups getFailedBackups() throws SeeTecException {
        try {
            this.logger.info("Requesting failed backups...");
            SrpcMessage response = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETFAILEDBACKUPS, null), TimeUnit.SECONDS.toMillis(30L));
            return RspGetFailedBackups.parseGObject((GObject)response.getPayload());
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }

    public int retryBackup(ReqRetryBackup request) throws SeeTecException {
        try {
            this.logger.info("Retry backup: " + request);
            SrpcMessage response = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_RETRYBACKUP, (GObject)request.createGObject()), TimeUnit.SECONDS.toMillis(30L));
            return response.getError();
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }

    public int discardFailedBackup(ReqDiscardFailedBackup request) throws SeeTecException {
        try {
            this.logger.info("Discard failed backup: " + request);
            SrpcMessage response = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_DISCARDFAILEDBACKUP, (GObject)request.createGObject()), TimeUnit.SECONDS.toMillis(30L));
            return response.getError();
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }

    @Override
    public void started(RspStartExport rspStartExport) {
        this.lastStartedExportResponseFailover = rspStartExport;
    }

    @Override
    public void finished(RspStartExport rspStartExport) {
        this.failoverExportsFinished.add(rspStartExport);
    }

    @Override
    public void updatedExportedVolume(long sequenceId, long exportedVolume) {
        this.failoverExportsVolume.updatedExportedVolume(sequenceId, exportedVolume);
    }

    public RspStartExport startExport(ReqStartExport request, String token) throws SeeTecException {
        this.failoverExportsFinished = new ArrayList<RspStartExport>();
        this.failoverExportsVolume = new NativeExportFailoverVolume();
        this.numberOfGapsInLocalDatabase = 0;
        this.failoverExportWorker = null;
        boolean isThisFailover = false;
        this.logger.info("Starting export : " + request);
        this.lastStartedExportContentId = request.getContentID();
        try {
            SrpcMessage responseLocal = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_STARTEXPORT, (GObject)request.createGObject(), (String)token), TimeUnit.SECONDS.toMillis(30L));
            this.lastStartedExportResponseLocalDatabase = RspStartExport.parseGObject((GObject)responseLocal.getPayload());
        }
        catch (Exception exception) {
            this.lastStartedExportResponseLocalDatabase = new RspStartExport(-23032);
        }
        try {
            this.lastStartedExportResponseFailover = null;
            isThisFailover = this.failoverHelper.isThisFailover(this.lastStartedExportContentId);
            if (this.failoverHelper.isFailoverDatabaseProxyAvailable()) {
                FailoverConfiguration failoverConfiguration = new FailoverConfiguration(this.configurationProvider.getDMConfigurationFromDatabase());
                if (failoverConfiguration.isMirroredRecordingActivated()) {
                    List<TimeRange> gapsInTimeline = this.nativeExportGapsFinder.find(request.getContentID(), request.getFrom(), request.getTo(), token);
                    this.startExportOnFailover(gapsInTimeline, request, token);
                } else {
                    ArrayList<TimeRange> wholeFailoverExportRange = new ArrayList<TimeRange>();
                    wholeFailoverExportRange.add(new TimeRange(request.getFrom(), request.getTo()));
                    this.startExportOnFailover(wholeFailoverExportRange, request, token);
                }
            } else {
                this.lastStartedExportResponseFailover = isThisFailover ? new RspStartExport(-23032) : new RspStartExport(0);
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while finding gaps in timeline: " + exception.getMessage());
            this.started(new RspStartExport(-23032));
        }
        this.lastStartedExportResponseLocalDatabase.setResultCode(NativeErrorExportCombiner.combineErrorCode(this.lastStartedExportResponseLocalDatabase.getResultCode(), this.lastStartedExportResponseFailover.getResultCode(), this.failoverHelper.isFailoverConfigured(), isThisFailover));
        return this.lastStartedExportResponseLocalDatabase;
    }

    private void startExportOnFailover(List<TimeRange> timeRangesToBeExported, ReqStartExport request, String token) throws SeeTecException, InterruptedException {
        this.numberOfGapsInLocalDatabase = timeRangesToBeExported.size();
        if (!timeRangesToBeExported.isEmpty()) {
            String downloadLocation = this.buildDownloadLocation(request);
            this.failoverExportWorker = this.failoverHelper.createNativeExportRunner(timeRangesToBeExported, request, downloadLocation, this, token);
            this.failoverExportWorker.start();
            while (this.lastStartedExportResponseFailover == null) {
                Thread.sleep(10L);
            }
        } else {
            this.started(new RspStartExport(0));
        }
    }

    public RspStartExportDownload startExportDownload(ReqStartExportDownload request) throws SeeTecException {
        RspStartExportDownload rspStartExportDownloadFailover = new RspStartExportDownload(0, new ArrayList());
        this.logger.info("Starting export download: " + request);
        try {
            this.exportDownloadHandler = new NativeExportDownloadHandler((RECore)this.core, this.lastStartedExportResponseLocalDatabase.getIdExportedSequence().longValue(), new File(this.lastStartedExportResponseLocalDatabase.getPathExportedSequence()), request.getBandwidthLimitation());
            List fileList = this.exportDownloadHandler.getDirectoryEntries();
            this.exportDownloadHandler.startExportDownload();
            return new RspStartExportDownload(rspStartExportDownloadFailover.getResultCode(), fileList);
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20022, "Can't access file");
        }
    }

    private String buildDownloadLocation(ReqStartExport request) {
        if (request.isServerSideExport()) {
            if (request.getAdditionalPath() != null && !request.getAdditionalPath().isEmpty()) {
                return Paths.get(request.getPath(), request.getAdditionalPath()).toString();
            }
            return request.getPath();
        }
        return this.lastStartedExportResponseLocalDatabase.getPathExportedSequence();
    }

    public int cancelExportDownload(ReqCancelExportDownload request) throws SeeTecException {
        this.logger.info("Cancel export download: " + request);
        if (this.exportDownloadHandler != null) {
            return this.exportDownloadHandler.shutdown();
        }
        return 0;
    }

    public int cancelExport() throws SeeTecException {
        int errorCodeLocal;
        this.logger.info("Canceling export.");
        if (this.failoverExportWorker != null) {
            this.failoverExportWorker.cancel();
        }
        try {
            SrpcMessage response = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_CANCELEXPORT, null), TimeUnit.SECONDS.toMillis(30L));
            errorCodeLocal = response.getError();
        }
        catch (Exception exception) {
            errorCodeLocal = -23032;
        }
        int errorCodeRemote = this.failoverHelper.cancelExport(this.numberOfGapsInLocalDatabase);
        return NativeErrorExportCombiner.combineErrorCode(errorCodeLocal, errorCodeRemote, this.failoverHelper.isFailoverConfigured(), false);
    }

    public RspGetStatusExport getStatusExport() throws SeeTecException {
        RspGetStatusExport rspGetStatusExportLocal;
        RspGetStatusExport rspGetStatusExportFailover = new RspGetStatusExport(0, Boolean.valueOf(false), Long.valueOf(0L), Long.valueOf(0L));
        boolean isThisFailover = false;
        try {
            SrpcMessage responseLocal = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETSTATUSEXPORT, null), TimeUnit.SECONDS.toMillis(30L));
            rspGetStatusExportLocal = RspGetStatusExport.parseGObject((GObject)responseLocal.getPayload());
            isThisFailover = this.failoverHelper.isThisFailover(this.lastStartedExportContentId);
        }
        catch (Exception exception) {
            rspGetStatusExportLocal = new RspGetStatusExport(-23032, Boolean.valueOf(false), Long.valueOf(0L), Long.valueOf(0L));
        }
        try {
            if (this.numberOfGapsInLocalDatabase != 0 && this.failoverHelper.isFailoverDatabaseProxyAvailable()) {
                rspGetStatusExportFailover = this.failoverHelper.getStatusExport();
            }
        }
        catch (Exception exception) {
            rspGetStatusExportFailover.setResultCode(-23032);
        }
        ArrayList<Integer> alreadyFinishedExportResults = new ArrayList<Integer>();
        this.failoverExportsFinished.forEach(rspStartExport -> alreadyFinishedExportResults.add(rspStartExport.getResultCode()));
        alreadyFinishedExportResults.add(rspGetStatusExportFailover.getResultCode());
        return new RspGetStatusExport(NativeErrorExportCombiner.combineErrorCode(rspGetStatusExportLocal.getResultCode(), alreadyFinishedExportResults, this.failoverHelper.isFailoverConfigured(), isThisFailover), Boolean.valueOf(rspGetStatusExportLocal.isRunning() != false || rspGetStatusExportFailover.isRunning() != false || this.numberOfGapsInLocalDatabase != this.failoverExportsFinished.size()), rspGetStatusExportLocal.getActualTimestamp(), Long.valueOf(rspGetStatusExportLocal.getExportedVolume() + this.failoverExportsVolume.getExportedVolume()));
    }

    public RspCheckTemporaryDirectory checkTemporaryDirectory(ReqCheckTemporaryDirectory request) throws SeeTecException {
        this.logger.info("Checking temporary directory : " + request);
        try {
            SrpcMessage response = this.localDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_CHECKTEMPORARYDIRECTORY, (GObject)request.createGObject()), TimeUnit.SECONDS.toMillis(30L));
            return RspCheckTemporaryDirectory.parseGObject((GObject)response.getPayload());
        }
        catch (Exception exception) {
            throw new SeeTecException(-23032, "Sending request to Mds failed. [" + exception.getMessage() + "]", (Throwable)exception);
        }
    }
}

