/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.NativeExportDownloadHandlerClientImpl;
import de.seetec.v5.re.cm.NativeExportFailoverStatus;
import de.seetec.v5.re.cm.NativeExportStartDownloadHandler;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.net.DefaultSocketFactory;
import de.seetec.v5.re.shared.srpc.ReqStartExport;
import de.seetec.v5.re.shared.srpc.ReqStartExportDownload;
import de.seetec.v5.re.shared.srpc.RspGetStatusExport;
import de.seetec.v5.re.shared.srpc.RspStartExport;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class NativeExportFailoverRunner
implements Runnable {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final DatabaseProxy databaseProxy;
    private final List<TimeRange> timeRanges;
    private final ReqStartExport request;
    private final String token;
    private final NativeExportFailoverStatus listener;
    private final String downloadLocation;
    private final Location locationOfFailoverMultimediaDatabase;
    private final ExecutorService scheduler;
    private final NativeExportStartDownloadHandler nativeExportStartDownloadHandler;
    private SystemTimeProvider systemTimeProvider;
    private SocketFactory socketFactory;

    NativeExportFailoverRunner(DatabaseProxy databaseProxy, List<TimeRange> timeRanges, ReqStartExport request, String token, NativeExportFailoverStatus listener, String downloadLocation, Location locationOfFailoverMultimediaDatabase, NativeExportStartDownloadHandler nativeExportStartDownloadHandler) throws SeeTecException {
        this(databaseProxy, timeRanges, request, token, listener, downloadLocation, locationOfFailoverMultimediaDatabase, nativeExportStartDownloadHandler, null, null);
    }

    NativeExportFailoverRunner(DatabaseProxy databaseProxy, List<TimeRange> timeRanges, ReqStartExport request, String token, NativeExportFailoverStatus listener, String downloadLocation, Location locationOfFailoverMultimediaDatabase, NativeExportStartDownloadHandler nativeExportStartDownloadHandler, SystemTimeProvider systemTimeProvider, SocketFactory socketFactory) throws SeeTecException {
        this.databaseProxy = databaseProxy;
        if (this.databaseProxy == null) {
            throw new SeeTecException(-20002, "DatabaseProxy is null");
        }
        this.timeRanges = timeRanges;
        if (this.timeRanges == null || timeRanges.isEmpty()) {
            throw new SeeTecException(-20002, "TimeRanges is null");
        }
        this.request = request;
        if (this.request == null) {
            throw new SeeTecException(-20002, "ReqStartExport is null");
        }
        this.token = token;
        if (this.token == null) {
            throw new SeeTecException(-20002, "Token is null");
        }
        this.listener = listener;
        if (this.listener == null) {
            throw new SeeTecException(-20002, "Listener is null");
        }
        this.downloadLocation = downloadLocation;
        if (this.downloadLocation == null) {
            throw new SeeTecException(-20002, "downloadLocation is null");
        }
        this.locationOfFailoverMultimediaDatabase = locationOfFailoverMultimediaDatabase;
        if (this.locationOfFailoverMultimediaDatabase == null) {
            throw new SeeTecException(-20002, "locationOfFailoverMultimediaDatabase is null");
        }
        this.nativeExportStartDownloadHandler = nativeExportStartDownloadHandler;
        if (this.nativeExportStartDownloadHandler == null) {
            throw new SeeTecException(-20002, "nativeExportStartDownloadHandler is null");
        }
        this.setOptionalParameters(systemTimeProvider, socketFactory);
        this.scheduler = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.getClass().getName()));
    }

    private void setOptionalParameters(SystemTimeProvider systemTimeProvider, SocketFactory socketFactory) {
        this.systemTimeProvider = systemTimeProvider != null ? systemTimeProvider : new DefaultSystemTimeProvider();
        this.socketFactory = socketFactory != null ? socketFactory : new DefaultSocketFactory();
    }

    public void start() {
        this.scheduler.execute(this);
    }

    public void cancel() {
        this.scheduler.shutdown();
    }

    @Override
    public void run() {
        try {
            for (TimeRange gap : this.timeRanges) {
                RspGetStatusExport rspGetStatusExport;
                this.request.setFrom(gap.getStartTimestamp());
                this.request.setTo(gap.getEndTimestamp());
                this.request.setPath("");
                this.logger.info("Trying to fill gaps for export: " + new Date(gap.getStartTimestamp()) + " -> " + new Date(gap.getEndTimestamp()));
                SrpcMessage responseFailover = this.databaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_STARTEXPORT, (GObject)this.request.createGObject(), (String)this.token), TimeUnit.SECONDS.toMillis(30L));
                RspStartExport rspStartExport = RspStartExport.parseGObject((GObject)responseFailover.getPayload());
                this.listener.started(rspStartExport);
                do {
                    this.systemTimeProvider.sleep(1000L);
                    SrpcMessage responseGetStatus = this.databaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETSTATUSEXPORT, null), TimeUnit.SECONDS.toMillis(30L));
                    rspGetStatusExport = RspGetStatusExport.parseGObject((GObject)responseGetStatus.getPayload());
                    this.listener.updatedExportedVolume(rspStartExport.getIdExportedSequence(), rspGetStatusExport.getExportedVolume());
                } while (rspGetStatusExport.isRunning().booleanValue() && !this.scheduler.isShutdown());
                try (NativeExportDownloadHandlerClientImpl nativeExportDownloadHandlerClient = new NativeExportDownloadHandlerClientImpl(this.socketFactory, this.locationOfFailoverMultimediaDatabase, new File(this.downloadLocation));){
                    this.nativeExportStartDownloadHandler.start(new ReqStartExportDownload(rspStartExport.getIdExportedSequence().longValue(), Integer.MAX_VALUE), nativeExportDownloadHandlerClient);
                }
                this.listener.finished(RspStartExport.parseGObject((GObject)responseFailover.getPayload()));
            }
        }
        catch (SeeTecException seeTecException) {
            this.listener.finished(new RspStartExport(seeTecException.getErrorCode()));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
            this.listener.finished(new RspStartExport(-20000));
        }
    }
}

