/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.NativeExportDownloadHandlerClient;
import de.seetec.v5.re.shared.ExportDirectoryEntry;
import de.seetec.v5.re.shared.NativeExportFrameHeader;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NativeExportDownloadHandlerClientImpl
implements Callable<Integer>,
NativeExportDownloadHandlerClient {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final SocketFactory socketFactory;
    private final Socket socket;
    private long exportedSequenceId;
    private ExecutorService scheduler = null;
    private List<ExportDirectoryEntry> fileList;
    private final File destination;

    public NativeExportDownloadHandlerClientImpl(SocketFactory socketFactory, Location locationOfMultimediaDatabase, File destination) throws SeeTecException {
        this.socketFactory = socketFactory;
        if (this.socketFactory == null) {
            throw new SeeTecException(-20002, "socketFactory not specified");
        }
        if (locationOfMultimediaDatabase == null) {
            throw new SeeTecException(-20002, "locationOfMultimediaDatabase not specified");
        }
        try {
            this.socket = this.socketFactory.createSocket(locationOfMultimediaDatabase.getHost(), locationOfMultimediaDatabase.getPort());
        }
        catch (IOException ex) {
            throw new SeeTecException(-20100, "Can't create socket to " + locationOfMultimediaDatabase.getHost() + ":" + locationOfMultimediaDatabase.getPort());
        }
        this.destination = destination;
        if (this.destination == null) {
            throw new SeeTecException(-20002, "destination not specified");
        }
        if (!this.destination.exists()) {
            throw new SeeTecException(-20002, "Destination not existing: " + this.destination);
        }
    }

    @Override
    public Future<Integer> init(long exportedSequenceId, List<ExportDirectoryEntry> fileList) throws SeeTecException {
        this.exportedSequenceId = exportedSequenceId;
        this.fileList = fileList;
        if (this.fileList == null || this.fileList.isEmpty()) {
            throw new SeeTecException(-20002, "File list is null");
        }
        if (this.fileList.isEmpty()) {
            throw new SeeTecException(-20002, "FileList empty");
        }
        this.logger.info("Starting export download client for sequence [" + exportedSequenceId + "]");
        this.scheduler = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.toString()));
        return this.scheduler.submit(this);
    }

    @Override
    public void close() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public Integer call() {
        try {
            this.socket.getOutputStream().write(this.createExportStreamHeader());
            InputStream inputStream = this.socket.getInputStream();
            FileOutputStream fileOutputStream = null;
            int numberOfFinishedFiles = 0;
            while (!this.scheduler.isShutdown() && numberOfFinishedFiles != this.fileList.size()) {
                NativeExportFrameHeader currentFile = this.readHeader(inputStream);
                ExportDirectoryEntry exportDirectoryEntry = this.findFileInfo(currentFile.getFileHash());
                this.logger.info("Downloading file: " + exportDirectoryEntry + " to " + this.destination);
                File nextFile = this.getNextFileAndAssureFolderStructure(exportDirectoryEntry);
                fileOutputStream = new FileOutputStream(nextFile);
                this.readOneFile(inputStream, fileOutputStream, currentFile.getLength());
                numberOfFinishedFiles = this.closeFile(fileOutputStream, numberOfFinishedFiles);
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while downloading: " + exception.getMessage(), (Throwable)exception);
            return -20000;
        }
        return 0;
    }

    private NativeExportFrameHeader readHeader(InputStream inputStream) throws IOException, SeeTecException {
        byte[] headerBuffer = new byte[64];
        int bytesRead = 0;
        do {
            int read;
            try {
                read = inputStream.read(headerBuffer, bytesRead, 64 - bytesRead);
            }
            catch (SocketTimeoutException ste) {
                continue;
            }
            if (read <= 0) {
                throw new SeeTecException(-20000, "Expected more header data, but no more data to read from socket");
            }
            bytesRead += read;
        } while (bytesRead < 64);
        return NativeExportFrameHeader.parse((byte[])Arrays.copyOfRange(headerBuffer, 0, 64));
    }

    private void readOneFile(InputStream inputStream, OutputStream outputStream, long expectedDataLength) throws SeeTecException, IOException {
        int read;
        byte[] contentBuffer = new byte[4096];
        for (long bytesRead = 0L; bytesRead < expectedDataLength; bytesRead += (long)read) {
            int bytesToRead = (int)Math.min((long)contentBuffer.length, expectedDataLength - bytesRead);
            read = inputStream.read(contentBuffer, 0, bytesToRead);
            if (read <= 0) {
                throw new SeeTecException(-20000, "Expected more content data, but no more data to read from socket");
            }
            outputStream.write(contentBuffer, 0, read);
        }
    }

    private File getNextFileAndAssureFolderStructure(ExportDirectoryEntry exportDirectoryEntry) throws IOException {
        String pathAndFile = exportDirectoryEntry.getRelativeFilePath();
        String pathOnly = pathAndFile.substring(0, pathAndFile.lastIndexOf("\\"));
        String fileOnly = pathAndFile.substring(pathAndFile.lastIndexOf("\\") + 1);
        Path path = this.destination.toPath().resolve(pathOnly);
        Files.createDirectories(path, new FileAttribute[0]);
        return path.resolve(fileOnly).toFile();
    }

    private ExportDirectoryEntry findFileInfo(String fileHash) {
        return this.fileList.stream().filter(x -> x.getFileHash().equals(fileHash)).findFirst().get();
    }

    private byte[] createExportStreamHeader() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        byteBuffer.put(SSLConstantsIntf.SSL_SRPC_TCP_HEADER);
        byteBuffer.putLong(this.exportedSequenceId);
        byteBuffer.put((byte)2);
        byteBuffer.putLong(this.exportedSequenceId);
        byte[] srpcHeader = byteBuffer.array();
        return srpcHeader;
    }

    private int closeFile(FileOutputStream fileOutputStream, int numberOfFinishedFiles) throws IOException {
        if (fileOutputStream != null) {
            fileOutputStream.flush();
            fileOutputStream.close();
            return numberOfFinishedFiles + 1;
        }
        return numberOfFinishedFiles;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ". Downloading from " + this.socket + ". Files to download: " + this.fileList;
    }
}

