/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NativeErrorExportCombiner {
    private static final Logger LOGGER = LogManager.getLogger((String)NativeErrorExportCombiner.class.getName());

    private NativeErrorExportCombiner() {
    }

    public static int combineErrorCode(int errorCodeLocal, int errorCodeFailover, boolean isFailOverConfigured, boolean isFailoverDM) {
        int newErrorCodeLocal;
        int error = 0;
        int newErrorCodeFailover = isFailoverDM ? errorCodeLocal : errorCodeFailover;
        int n = newErrorCodeLocal = isFailoverDM ? errorCodeFailover : errorCodeLocal;
        if (!isFailOverConfigured && !isFailoverDM) {
            error = newErrorCodeLocal;
        } else if (newErrorCodeLocal != 0 && newErrorCodeFailover == 0) {
            LOGGER.error("Local Multimedia database delivered error: " + newErrorCodeLocal);
            error = -21800;
        } else if (newErrorCodeFailover != 0) {
            if (newErrorCodeLocal == 0) {
                LOGGER.error("Failover Multimedia database delivered error: " + newErrorCodeFailover);
                error = -21801;
            } else {
                LOGGER.error("Both Multimedia database delivered errors. Productive: " + newErrorCodeLocal + ". Failover: " + newErrorCodeFailover);
                error = -21802;
            }
        }
        return error;
    }

    public static int combineErrorCode(int errorCodeLocal, List<Integer> failoverExportErrors, boolean isFailOverConfigured, boolean isFailoverDM) {
        int combinedError = 0;
        if (!isFailOverConfigured && !isFailoverDM) {
            combinedError = errorCodeLocal;
        } else if (errorCodeLocal != 0 && failoverExportErrors.stream().allMatch(error -> error == 0)) {
            LOGGER.error("Local Multimedia database delivered error: " + errorCodeLocal);
            combinedError = isFailoverDM ? -21802 : -21800;
        } else if (errorCodeLocal == 0 && failoverExportErrors.stream().anyMatch(error -> error != 0)) {
            LOGGER.error("Failover Multimedia database delivered error: " + failoverExportErrors);
            combinedError = -21801;
        } else if (errorCodeLocal != 0 && failoverExportErrors.stream().anyMatch(error -> error != 0)) {
            LOGGER.error("Both Multimedia database delivered errors. Productive: " + errorCodeLocal + ". Failover: " + failoverExportErrors);
            combinedError = -21802;
        }
        return combinedError;
    }
}

