/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.RuntimeEnvironmentStatus;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.REStatus;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultimediaDatabaseLifeCycle
implements Runnable {
    private static final long CYCLE = 3L;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final RuntimeEnvironmentStatus runtimeEnvironmentStatus;
    private final Core core;
    private final SystemTimeProvider systemTimeProvider;
    private final long defaultRuntime;
    private final long defaultDevice;
    private long timestampOfLastProblem = -1L;
    private long nextDefaultMultimediaDatabaseCheck = -1L;
    private final ScheduledExecutorService scheduler;

    public MultimediaDatabaseLifeCycle(ConfigurationProvider configurationProvider, RuntimeEnvironmentStatus runtimeEnvironmentStatus, Core core) throws ConfigurationException, SeeTecException {
        this(configurationProvider, runtimeEnvironmentStatus, core, (SystemTimeProvider)new DefaultSystemTimeProvider());
    }

    protected MultimediaDatabaseLifeCycle(ConfigurationProvider configurationProvider, RuntimeEnvironmentStatus runtimeEnvironmentStatus, Core core, SystemTimeProvider systemTimeProvider) throws ConfigurationException, SeeTecException {
        if (configurationProvider == null) {
            throw new SeeTecException(-20002, "ConfigurationProvider null");
        }
        this.runtimeEnvironmentStatus = runtimeEnvironmentStatus;
        if (this.runtimeEnvironmentStatus == null) {
            throw new SeeTecException(-20002, "RuntimeEnvironmentStatus null");
        }
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-20002, "Core null");
        }
        this.systemTimeProvider = systemTimeProvider;
        if (this.systemTimeProvider == null) {
            throw new SeeTecException(-20002, "Core null");
        }
        this.defaultRuntime = configurationProvider.getMDSConfigurationFromFile().getEntityID();
        this.defaultDevice = configurationProvider.getMDSConfigurationFromFile().getEntityID() + 1L;
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("MultimediaDatabaseLifeCycle"));
    }

    public void init() {
        this.scheduler.scheduleWithFixedDelay(this, 0L, 3L, TimeUnit.SECONDS);
    }

    public long getMultimediaDatabaseRuntime() {
        return this.defaultRuntime;
    }

    public long getMultimediaDatabaseDevice() {
        return this.defaultDevice;
    }

    protected void setNextDefaultMultimediaDatabaseCheck(long nextDefaultMultimediaDatabaseCheck) {
        this.nextDefaultMultimediaDatabaseCheck = nextDefaultMultimediaDatabaseCheck;
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.checkPrimaryMultimediaDatabase();
            }
            catch (Throwable ex) {
                this.logger.error("Error while running: ", ex);
                if (this.scheduler.isShutdown()) break block2;
                this.logger.info("Try to restart check for MultimediaDatabaseLifeCycle");
                this.scheduler.scheduleWithFixedDelay(this, 0L, 3L, TimeUnit.SECONDS);
            }
        }
    }

    private void checkPrimaryMultimediaDatabase() {
        if (this.runtimeEnvironmentStatus.getStatus() == -21040 && this.nextDefaultMultimediaDatabaseCheck < this.systemTimeProvider.currentTimeMillis()) {
            this.setNextDefaultMultimediaDatabaseCheck(this.systemTimeProvider.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L));
            try {
                DatabaseProxy databaseProxy = this.core.createDatabaseProxy(null, this.getMultimediaDatabaseDevice());
                databaseProxy.shutdown();
                this.timestampOfLastProblem = -1L;
                this.runtimeEnvironmentStatus.setStatus(REStatus.INITIALIZED.getStatus());
            }
            catch (Throwable throwable) {
                this.logger.warn("MDS connection still N/A", throwable);
            }
        }
    }

    public void checkMdsFailoverState() {
        if (this.runtimeEnvironmentStatus.getStatus() == -21040) {
            return;
        }
        if (this.timestampOfLastProblem == -1L) {
            this.timestampOfLastProblem = this.systemTimeProvider.currentTimeMillis();
        } else if (this.timestampOfLastProblem + TimeUnit.SECONDS.toMillis(30L) < this.systemTimeProvider.currentTimeMillis()) {
            this.logger.error("MDS Failure Timout reached.");
            this.runtimeEnvironmentStatus.setStatus(-21040);
            if (this.core.getFailoverMdbID() != -1L) {
                this.logger.info("We have a failover system, so another DM will start the devices from this DM. The devices will be stopped now.");
                this.core.stopAllDevices();
            }
            this.setNextDefaultMultimediaDatabaseCheck(this.systemTimeProvider.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L));
        }
    }
}

