/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.ImportExportSrpcShutdownListener;
import de.seetec.v5.re.cm.NativeExportGapsFinder;
import de.seetec.v5.re.cm.NativeExportImpl;
import de.seetec.v5.re.cm.NativeImportImpl;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.NativeExport;
import de.seetec.v5.re.shared.NativeImport;
import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.re.shared.srpc.ReqCancelExportDownload;
import de.seetec.v5.re.shared.srpc.ReqCheckTemporaryDirectory;
import de.seetec.v5.re.shared.srpc.ReqDiscardFailedBackup;
import de.seetec.v5.re.shared.srpc.ReqGetImportInfo;
import de.seetec.v5.re.shared.srpc.ReqGetImportPaths;
import de.seetec.v5.re.shared.srpc.ReqRetryBackup;
import de.seetec.v5.re.shared.srpc.ReqStartExport;
import de.seetec.v5.re.shared.srpc.ReqStartExportDownload;
import de.seetec.v5.re.shared.srpc.RspCheckTemporaryDirectory;
import de.seetec.v5.re.shared.srpc.RspGetFailedBackups;
import de.seetec.v5.re.shared.srpc.RspGetImportInfo;
import de.seetec.v5.re.shared.srpc.RspGetImportPaths;
import de.seetec.v5.re.shared.srpc.RspGetStatusExport;
import de.seetec.v5.re.shared.srpc.RspStartExport;
import de.seetec.v5.re.shared.srpc.RspStartExportDownload;
import de.seetec.v5.shared.networking.srpc.DefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class ImportExportSrpcHandler
extends AbstractSrpcHandler
implements ShutdownCallback {
    private static final String CLASS_NAME = "ImportExportSrpcHandler";
    private final Core core;
    private final NativeImport nativeImport;
    private final NativeExport nativeExport;
    private final SrpcClientIntf srpc;
    private final Socket socket;
    private final DatabaseProxy productiveDatabaseProxy;
    private final ImportExportSrpcShutdownListener importExportSrpcShutdownListener;

    public ImportExportSrpcHandler(Core core, Socket socket, ImportExportSrpcShutdownListener importExportSrpcShutdownListener, ConfigurationProvider configurationProvider) throws SeeTecException {
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21001, "Core is null");
        }
        this.socket = socket;
        if (this.socket == null) {
            throw new SeeTecException(-21001, "Socket is null");
        }
        this.importExportSrpcShutdownListener = importExportSrpcShutdownListener;
        if (this.importExportSrpcShutdownListener == null) {
            throw new SeeTecException(-21001, "ImportExportSrpcShutdownListener is null");
        }
        if (configurationProvider == null) {
            throw new SeeTecException(-21001, "ConfigurationProvider is null");
        }
        try {
            this.srpc = SrpcFactory.getSrpc((Socket)socket, (SrpcRequestHandlerFactoryIntf)new DefaultRequestHandlerFactoryImpl((SrpcRequestHandlerIntf)this), null, (ShutdownCallback)this, (boolean)false);
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20210, String.format("Cannot get SRPC for %s, %s", new Object[]{socket, this}), ex);
        }
        DatabaseProxy[] mdsProxies = this.core.createDatabaseProxies(null);
        this.productiveDatabaseProxy = mdsProxies[0];
        if (this.productiveDatabaseProxy == null) {
            throw new SeeTecException(-21601, "Mds proxy not available.");
        }
        this.nativeImport = new NativeImportImpl(this.productiveDatabaseProxy);
        this.nativeExport = new NativeExportImpl(mdsProxies, core, configurationProvider, new NativeExportGapsFinder(core));
    }

    public void init() {
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.nativeExport.shutdown();
        this.productiveDatabaseProxy.shutdown();
        this.srpc.shutdown();
        super.shutdown();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long lastCommandTimeOut = TimeUnit.MINUTES.toMillis(1L);
        try {
            long lastCommand = System.currentTimeMillis();
            while (!this.isShutdown(CLASS_NAME)) {
                if (!this.hasRequest() && System.currentTimeMillis() > lastCommand + lastCommandTimeOut) {
                    break;
                }
                SrpcMessage req = this.getNextReq(1, TimeUnit.SECONDS);
                if (null == req) continue;
                lastCommand = System.currentTimeMillis();
                RequestHandlerCallback callback = this.getCallback(req.getId());
                try {
                    switch (Methods.valueOf((int)req.getHash())) {
                        case MD_REQ_GETIMPORTPATHS: {
                            this.execGetImportPaths(req, callback);
                            break;
                        }
                        case MD_REQ_GETIMPORTINFO: {
                            this.execGetImportInfo(req, callback);
                            break;
                        }
                        case MD_REQ_GETFAILEDBACKUPS: {
                            this.execGetFailedBackups(req, callback);
                            break;
                        }
                        case MD_REQ_RETRYBACKUP: {
                            this.execRetryBackup(req, callback);
                            break;
                        }
                        case MD_REQ_DISCARDFAILEDBACKUP: {
                            this.execDiscardFailedBackup(req, callback);
                            break;
                        }
                        case MD_REQ_STARTEXPORT: {
                            this.execStartExport(req, callback);
                            break;
                        }
                        case MD_REQ_GETSTATUSEXPORT: {
                            this.execStatusExport(req, callback);
                            break;
                        }
                        case MD_REQ_CANCELEXPORT: {
                            this.execCancelExport(req, callback);
                            break;
                        }
                        case MD_REQ_STARTEXPORTDOWNLOAD: {
                            this.execStartExportDownload(req, callback);
                            break;
                        }
                        case MD_REQ_CANCELEXPORTDOWNLOAD: {
                            this.execCancelExportDownload(req, callback);
                            break;
                        }
                        case MD_REQ_CHECKTEMPORARYDIRECTORY: {
                            this.execCheckTemporaryDirectory(req, callback);
                            break;
                        }
                    }
                }
                catch (SeeTecException seeTecException) {
                    SrpcMessage response = SrpcMessage.createResponse((SrpcMessage)req, null);
                    response.setError(seeTecException.getErrorCode());
                    callback.onRequestHandled(req, response);
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        finally {
            this.shutdown();
        }
    }

    private void execGetImportPaths(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspGetImportPaths responseWrapper = this.nativeImport.getImportPaths(ReqGetImportPaths.parseGObject((GObject)request.getPayload()));
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execGetImportInfo(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspGetImportInfo responseWrapper = this.nativeImport.getImportInfo(ReqGetImportInfo.parseGObject((GObject)request.getPayload()));
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execGetFailedBackups(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspGetFailedBackups responseWrapper = this.nativeExport.getFailedBackups();
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execRetryBackup(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        int error = this.nativeExport.retryBackup(ReqRetryBackup.parseGObject((GObject)request.getPayload()));
        SrpcMessage response = SrpcMessage.createResponse((SrpcMessage)request, null);
        response.setError(error);
        callback.onRequestHandled(request, response);
    }

    private void execDiscardFailedBackup(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        int error = this.nativeExport.discardFailedBackup(ReqDiscardFailedBackup.parseGObject((GObject)request.getPayload()));
        SrpcMessage response = SrpcMessage.createResponse((SrpcMessage)request, null);
        response.setError(error);
        callback.onRequestHandled(request, response);
    }

    private void execCheckTemporaryDirectory(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspCheckTemporaryDirectory responseWrapper = this.nativeExport.checkTemporaryDirectory(ReqCheckTemporaryDirectory.parseGObject((GObject)request.getPayload()));
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execStartExport(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspStartExport responseWrapper = this.nativeExport.startExport(ReqStartExport.parseGObject((GObject)request.getPayload()), request.getToken());
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execCancelExport(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        int error = this.nativeExport.cancelExport();
        SrpcMessage response = SrpcMessage.createResponse((SrpcMessage)request, null);
        response.setError(error);
        callback.onRequestHandled(request, response);
    }

    private void execStatusExport(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspGetStatusExport responseWrapper = this.nativeExport.getStatusExport();
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execStartExportDownload(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        RspStartExportDownload responseWrapper = this.nativeExport.startExportDownload(ReqStartExportDownload.parseGObject((GObject)request.getPayload()));
        callback.onRequestHandled(request, SrpcMessage.createResponse((SrpcMessage)request, (GObject)responseWrapper.createGObject()));
    }

    private void execCancelExportDownload(SrpcMessage request, RequestHandlerCallback callback) throws SeeTecException {
        int error = this.nativeExport.cancelExportDownload(ReqCancelExportDownload.parseGObject((GObject)request.getPayload()));
        SrpcMessage response = SrpcMessage.createResponse((SrpcMessage)request, null);
        response.setError(error);
        callback.onRequestHandled(request, response);
    }

    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down proxy ...");
        this.shutdown();
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ", SRPC=" + this.srpc + "]";
    }

    public void onShutdown() {
        this.shutdown();
        this.importExportSrpcShutdownListener.onShutdown(this.socket, this);
    }
}

