/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.ImportExportSrpcHandler;
import de.seetec.v5.re.cm.ImportExportSrpcShutdownListener;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.networking.srpc.NetworkDispatcherHeader;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ImportExportHandler
implements SRPCDispatcherListener,
ImportExportSrpcShutdownListener {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private final Core core;
    private final ConfigurationProvider configurationProvider;
    private final Map<Socket, ImportExportSrpcHandler> importExportSrpcHandlers;
    private final Lock importExportSrpcHandlersLock;
    private boolean isShutdown = false;

    public ImportExportHandler(Core core, ConfigurationProvider configurationProvider) throws SeeTecException, ConfigurationException {
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-20002, "Core null");
        }
        this.configurationProvider = configurationProvider;
        if (this.configurationProvider == null) {
            throw new SeeTecException(-20002, "Core null");
        }
        Long dmEntityId = configurationProvider.getDMConfigurationFromFile().getEntityID();
        Entity[] videoBackups = core.getEntMgrProxy().getEntitiesAsList(Collections.singletonList(9992L), Boolean.FALSE, DEFAULT_TIMEOUT);
        Optional<Long> backupEntityId = Arrays.stream(videoBackups).filter(entity -> dmEntityId.equals(entity.getLogicalParent())).map(Entity::getEntityID).findFirst();
        long idOfVideoBackup = backupEntityId.orElseThrow(() -> new SeeTecException(-20002, "Id of VideoBackup not found!"));
        this.importExportSrpcHandlers = new HashMap<Socket, ImportExportSrpcHandler>();
        this.importExportSrpcHandlersLock = new ReentrantLock();
        core.registerToSRPCDispatcher(this, idOfVideoBackup);
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown()) {
            return -21017;
        }
        this.importExportSrpcHandlersLock.lock();
        try {
            if (this.importExportSrpcHandlers.get(socket) == null) {
                ImportExportSrpcHandler importExportSrpcHandler = new ImportExportSrpcHandler(this.core, socket, this, this.configurationProvider);
                importExportSrpcHandler.init();
                this.importExportSrpcHandlers.put(socket, importExportSrpcHandler);
            }
        }
        catch (SeeTecException ex) {
            throw new RuntimeException("Creating ImportExportSrpcHandler failed because of [" + (Object)((Object)ex) + "]", ex);
        }
        finally {
            this.importExportSrpcHandlersLock.unlock();
        }
        return 0;
    }

    public int handleRequest(Socket aSocket, NetworkDispatcherHeader networkDispatcherHeader) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown() {
        this.isShutdown = true;
        this.importExportSrpcHandlersLock.lock();
        try {
            for (Map.Entry<Socket, ImportExportSrpcHandler> importExportSrpcHandler : this.importExportSrpcHandlers.entrySet()) {
                importExportSrpcHandler.getValue().shutdown();
                try {
                    importExportSrpcHandler.getKey().close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.importExportSrpcHandlersLock.unlock();
        }
        return 0;
    }

    @Override
    public void onShutdown(Socket socket, ImportExportSrpcHandler importExportSrpcHandler) {
        if (socket == null) {
            return;
        }
        if (importExportSrpcHandler == null) {
            return;
        }
        this.importExportSrpcHandlersLock.lock();
        try {
            this.importExportSrpcHandlers.remove(socket);
        }
        finally {
            this.importExportSrpcHandlersLock.unlock();
        }
    }
}

