/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.NativeExportFailoverRunner;
import de.seetec.v5.re.cm.NativeExportFailoverStatus;
import de.seetec.v5.re.cm.NativeExportStartDownloadHandlerImpl;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.srpc.ReqStartExport;
import de.seetec.v5.re.shared.srpc.RspGetStatusExport;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class FailoverHelper {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final Core core;
    private final DatabaseProxy failoverDatabaseProxy;

    FailoverHelper(Core core, DatabaseProxy failoverDatabaseProxy) throws SeeTecException {
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21001, "parameter core is null");
        }
        this.failoverDatabaseProxy = failoverDatabaseProxy;
    }

    boolean isFailoverConfigured() {
        return this.core.getFailoverMdbID() != -1L;
    }

    boolean isFailoverDatabaseProxyAvailable() throws SeeTecException {
        if (this.failoverDatabaseProxy == null) {
            if (this.isFailoverConfigured()) {
                throw new SeeTecException(-21801, "Proxy null but needed.");
            }
            return false;
        }
        return true;
    }

    boolean isThisFailover(long contentId) throws NumberFormatException, ConfigurationException {
        boolean thisIsFailover = false;
        try {
            long configuredRuntimeEnvironmentId;
            long thisRuntimeEnvironmentId;
            Entity videoServerEntity = this.core.getEntityByID(this.core.getEntityByID(contentId).getPhysicalParent());
            DeviceCnf deviceCnf = new DeviceCnf(null);
            int result = deviceCnf.init(videoServerEntity.getConfiguration());
            if (result != 0) {
                this.logger.error("Error while reading device configuration for " + videoServerEntity.getEntityName() + " " + result);
            }
            if ((thisRuntimeEnvironmentId = this.core.getRECnfMgr().getEntityID()) != (configuredRuntimeEnvironmentId = Long.parseLong(deviceCnf.getREID()))) {
                thisIsFailover = true;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Error while reading RE configuration " + ex.getMessage());
            throw ex;
        }
        return thisIsFailover;
    }

    RspGetStatusExport getStatusExport() throws SeeTecException, InterruptedException, ExecutionException, TimeoutException {
        SrpcMessage responseFailover = this.failoverDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_GETSTATUSEXPORT, null), TimeUnit.SECONDS.toMillis(30L));
        return RspGetStatusExport.parseGObject((GObject)responseFailover.getPayload());
    }

    NativeExportFailoverRunner createNativeExportRunner(List<TimeRange> timeRangesToBeExported, ReqStartExport request, String downloadLocation, NativeExportFailoverStatus failoverStatus, String token) throws SeeTecException {
        Location locationOfFailoverMultimediaDatabase = this.core.getEntityLocationCache().get(this.core.getFailoverMdbID());
        NativeExportStartDownloadHandlerImpl nativeExportStartDownloadHandler = new NativeExportStartDownloadHandlerImpl(this.failoverDatabaseProxy);
        return new NativeExportFailoverRunner(this.failoverDatabaseProxy, timeRangesToBeExported, request, token, failoverStatus, downloadLocation, locationOfFailoverMultimediaDatabase, nativeExportStartDownloadHandler);
    }

    int cancelExport(int numberOfGapsInLocalDatabase) {
        try {
            if (numberOfGapsInLocalDatabase != 0 && this.isFailoverDatabaseProxyAvailable()) {
                SrpcMessage responseFailover = this.failoverDatabaseProxy.sendGenericRequest(SrpcMessage.createRequest((Methods)Methods.MD_REQ_CANCELEXPORT, null), TimeUnit.SECONDS.toMillis(30L));
                return responseFailover.getError();
            }
        }
        catch (Exception exception) {
            return -23032;
        }
        return 0;
    }
}

