/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.DeviceManagerSrpcConnector;
import de.seetec.v5.re.cm.device.video.acti.ActiDevice;
import de.seetec.v5.re.cm.device.video.arecont.ArecontDevice;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHelper;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.device.video.jpegemulator.JPEGEmulatorDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifHelper;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicDevice;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.pelco.PelcoDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileDevice;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekDevice;
import de.seetec.v5.re.cm.firmware.FirmwareManager;
import de.seetec.v5.re.cm.shared.RecordingStatistic;
import de.seetec.v5.re.cm.shared.srpc.ReqChangeDeviceIP;
import de.seetec.v5.re.cm.shared.srpc.ReqChangeDevicePassword;
import de.seetec.v5.re.cm.shared.srpc.ReqCheckDeviceInfos;
import de.seetec.v5.re.cm.shared.srpc.ReqCountLoggingOfCameraLiveUsage;
import de.seetec.v5.re.cm.shared.srpc.ReqDeleteFirmware;
import de.seetec.v5.re.cm.shared.srpc.ReqGetLoggingOfCameraLiveUsage;
import de.seetec.v5.re.cm.shared.srpc.ReqIsFirmwareAvailable;
import de.seetec.v5.re.cm.shared.srpc.ReqSendFirmware;
import de.seetec.v5.re.cm.shared.srpc.ReqUpgradeDeviceFirmware;
import de.seetec.v5.re.cm.shared.srpc.RspCheckDeviceInfos;
import de.seetec.v5.re.cm.shared.srpc.RspCountLoggingOfCameraLiveUsage;
import de.seetec.v5.re.cm.shared.srpc.RspGetLoggingOfCameraLiveUsage;
import de.seetec.v5.re.cm.shared.srpc.RspIsFirmwareAvailable;
import de.seetec.v5.re.shared.AbstractRuntimeEnvironmentSrpcHandler;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class DeviceManagerSrpcHandler
extends AbstractRuntimeEnvironmentSrpcHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.DeviceManagerSrpcHandler";
    private final Core core;
    private final DeviceManagerSrpcConnector deviceManagerSrpcConnector;
    private final RecordingStatistic recordingStatistic;

    public DeviceManagerSrpcHandler(Core core, Socket socket) throws SeeTecException {
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21001, "Core is null");
        }
        this.recordingStatistic = new RecordingStatistic(core);
        this.deviceManagerSrpcConnector = new DeviceManagerSrpcConnector(this, socket);
    }

    public void init() {
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
    }

    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        String myInfo = this.toString();
        if (this.thread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn(String.format("Thread of %s didn't finished in time", myInfo));
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        if ((errorCode = this.deviceManagerSrpcConnector.shutdown()) != 0) {
            this.logger.warn("Shutting down connector [" + (Object)((Object)this.deviceManagerSrpcConnector) + "] failed with error [" + errorCode + "] :-(");
        }
        super.shutdown();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long idleSince = Long.MAX_VALUE;
        try {
            RequestHandlerCallback callback;
            SrpcMessage req;
            boolean lastCommandDelay = false;
            long lastCommand = System.currentTimeMillis();
            while (!this.isShutdown(CLASS_NAME) && (this.hasRequest() || Math.abs(lastCommand - System.currentTimeMillis()) <= 60000L)) {
                if (this.deviceManagerSrpcConnector.isShutdown()) {
                    if (lastCommandDelay) break;
                    lastCommandDelay = true;
                    long timeout = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < timeout && !this.hasRequest() && !this.isShutdown(CLASS_NAME)) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (null == (req = this.getNextReq(1, TimeUnit.SECONDS))) {
                    long nanoNow = System.nanoTime();
                    if (nanoNow < idleSince) {
                        idleSince = nanoNow;
                        continue;
                    }
                    if (nanoNow - idleSince <= TimeUnit.HOURS.toNanos(8L)) continue;
                    this.logger.warn(String.format("Handler[%s]: Idle for 8 hours!", Integer.toHexString(((Object)((Object)this)).hashCode())));
                    continue;
                }
                idleSince = System.nanoTime();
                callback = this.getCallback(req.getId());
                lastCommand = System.currentTimeMillis();
                switch (Methods.valueOf((int)req.getHash())) {
                    case ENT_FUNCTION_GET_STATUS: {
                        this.execGetStatus(req, callback);
                        break;
                    }
                    case ENT_FUNCTION_START_DEVICE: {
                        this.execStartDevice(req, callback);
                        break;
                    }
                    case ENT_FUNCTION_STOP_DEVICE: {
                        this.execStopDevice(req, callback);
                        break;
                    }
                    case NOTIFY: {
                        this.execNotify(req, callback);
                        break;
                    }
                    case ENT_FUNCTION_TRIGGER_ACTION: {
                        this.execTriggerAction(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_COUNTLOGGINGOFCAMERALIVEUSAGE: {
                        this.execCountLoggingOfCameraLiveUsage(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETLOGGINGOFCAMERALIVEUSAGE: {
                        this.execGetLoggingOfCameraLiveUsage(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_CHECKDEVICEINFOS: {
                        this.execCheckDeviceInfos(req, callback);
                        break;
                    }
                    case RE_SRPC_GET_CAMERA_RECORDING_STATISTICS: {
                        this.execGetCameraRecordingStatistics(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_CHANGE_DEVICE_PASSWORD: {
                        this.execChangeDevicePassword(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_CHANGE_DEVICE_IP: {
                        this.execChangeDeviceIP(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_IS_FIRMWARE_AVAILABLE: {
                        this.execIsFirmareAvailable(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_IS_DELETE_FIRMWARE: {
                        this.execDeleteFirmware(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_IS_SEND_FIRMWARE: {
                        this.execSendFirmware(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_UPGRADE_DEVICE_FIRMWARE: {
                        this.execUpgradeDeviceFirmware(req, callback);
                        break;
                    }
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while ((req = this.getNextReqOrNull()) != null) {
                callback = this.getCallback(req.getId());
                switch (Methods.valueOf((int)req.getHash())) {
                    case ENT_FUNCTION_TRIGGER_ACTION: {
                        this.execTriggerAction(req, callback);
                        break;
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        finally {
            super.setRunFinished(CLASS_NAME, true);
            int errorCode = this.shutdown();
            if (errorCode != 0) {
                this.logger.error("[shutdown] failed with error [" + errorCode + "] :-(");
            }
        }
    }

    protected final RECore getCore() {
        return this.core;
    }

    private void execCountLoggingOfCameraLiveUsage(SrpcMessage req, RequestHandlerCallback callback) {
        ReqCountLoggingOfCameraLiveUsage request = ReqCountLoggingOfCameraLiveUsage.parseGObject(req.getPayload());
        Long[] videoSources = request.getVideoSources();
        Long[] userIDs = request.getUserIDs();
        String[] userNames = request.getUserNames();
        Long startOfStreaming = request.getStartOfStreaming();
        Long endOfStreaming = request.getEndOfStreaming();
        int counter = this.core.getManagerLoggingOfCameraUsage().countLoggingOfLiveCameraUsage(videoSources, userIDs, userNames, startOfStreaming, endOfStreaming);
        RspCountLoggingOfCameraLiveUsage params = new RspCountLoggingOfCameraLiveUsage(counter);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)params.createGObject());
        callback.onRequestHandled(req, rsp);
    }

    private void execGetLoggingOfCameraLiveUsage(SrpcMessage req, RequestHandlerCallback callback) {
        ReqGetLoggingOfCameraLiveUsage request = ReqGetLoggingOfCameraLiveUsage.parseGObject(req.getPayload());
        Long[] videoSources = request.getVideoSources();
        Long[] userIDs = request.getUserIDs();
        String[] userNames = request.getUserNames();
        Long startOfStreaming = request.getStartOfStreaming();
        Long endOfStreaming = request.getEndOfStreaming();
        Object[] oEntries = this.core.getManagerLoggingOfCameraUsage().getLoggingOfLiveCameraUsage(videoSources, userIDs, userNames, startOfStreaming, endOfStreaming);
        RspGetLoggingOfCameraLiveUsage params = new RspGetLoggingOfCameraLiveUsage(oEntries);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)params.createGObject());
        callback.onRequestHandled(req, rsp);
    }

    private void execCheckDeviceInfos(SrpcMessage req, RequestHandlerCallback callback) {
        int errorCode;
        ReqCheckDeviceInfos request = ReqCheckDeviceInfos.parseGObject(req.getPayload());
        try {
            long manufacturer = request.getType() / 100L;
            long type = request.getType();
            String host = request.getHost();
            int port = request.getPort();
            boolean useAuthorization = request.getUseAuthorization();
            String user = request.getUser();
            String pass = request.getPass();
            int timeout = 7000;
            if (this.doNetworkCheck(type)) {
                String[] stringArray;
                this.logger.info("CheckDeviceInfos general ...");
                String resolveHost = new LteHostResolver(this.core.getLTESupportConfiguration()).resolve(host);
                if (useAuthorization) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = user;
                    stringArray = stringArray2;
                    stringArray2[1] = pass;
                } else {
                    stringArray = null;
                }
                NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)resolveHost, (int)port, (boolean)false, (int)-1, (int)7000, stringArray);
                if (networkParameter.useHTTPS()) {
                    NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getSSLport(), (boolean)true, (int)networkParameter.getSoTimeout());
                } else {
                    NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getHTTPport(), (boolean)false, (int)networkParameter.getSoTimeout());
                }
            }
            this.logger.info("CheckDeviceInfos manufacturer specific ...");
            errorCode = this.execCheckDeviceInfosManufacturerSpecific(manufacturer, type, host, port, useAuthorization, user, pass, 7000);
        }
        catch (SocketTimeoutException e) {
            errorCode = request.getType() / 100L == 2010L ? -21700 : -21698;
        }
        catch (ConnectException e) {
            errorCode = -21699;
        }
        catch (Exception e) {
            errorCode = -21700;
        }
        RspCheckDeviceInfos response = new RspCheckDeviceInfos(errorCode);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)response.createGObject());
        callback.onRequestHandled(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execChangeDevicePassword(SrpcMessage req, RequestHandlerCallback rhc) {
        Entity entity = null;
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        try {
            ReqChangeDevicePassword request = ReqChangeDevicePassword.parseGObject(req.getPayload());
            entity = this.core.getEntityByID(request.getEntityId());
            long manufacturer = entity.getEntityType() / 100L;
            if (manufacturer == 2000L || manufacturer == 2023L) {
                AxisDevice.getCameraAdministration().changeDevicePassword(request.getNewPassword(), this.core.getEntMgrProxy(), entity, this.core);
            } else if (manufacturer == 2017L) {
                BoschDevice.getCameraAdministration().changeDevicePassword(request.getNewPassword(), this.core.getEntMgrProxy(), entity, this.core);
            } else if (GenericOnvifHelper.isOnvifDevice(entity.getEntityType())) {
                GenericOnvifDevice.getCameraAdministration().changeDevicePassword(request.getNewPassword(), this.core.getEntMgrProxy(), entity, this.core);
            } else if (manufacturer == 2018L || manufacturer == 2068L || manufacturer == 2064L) {
                SamsungDevice.getCameraAdministration().changeDevicePassword(request.getNewPassword(), this.core.getEntMgrProxy(), entity, this.core);
            } else if (manufacturer == 2004L || manufacturer == 2060L || manufacturer == 2059L || manufacturer == 2061L || manufacturer == 2044L || entity.getEntityType() == 201117L || entity.getEntityType() == 204190L || manufacturer == 2063L) {
                HikvisionDevice.getCameraAdministration().changeDevicePassword(request.getNewPassword(), this.core.getEntMgrProxy(), entity, this.core);
            } else {
                rsp.setError(-20001);
            }
            rsp.setError(0);
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Exception while changing device password for: " + (entity == null ? "n/a" : entity.toString()) + ". Code: " + seeTecException.getErrorCode() + ". Message: " + seeTecException.getMessage());
            rsp.setError(seeTecException.getErrorCode());
        }
        finally {
            rhc.onRequestHandled(req, rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execChangeDeviceIP(SrpcMessage req, RequestHandlerCallback rhc) {
        Entity entity = null;
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        try {
            ReqChangeDeviceIP request = ReqChangeDeviceIP.parseGObject(req.getPayload());
            entity = this.core.getEntityByID(request.getEntityId());
            if (entity != null) {
                long manufacturer = entity.getEntityType() / 100L;
                if (manufacturer == 2096L) {
                    GenericOnvifDevice.getCameraAdministration().changeDeviceIP(request.getNewIP(), request.getNetworkMask(), this.core.getEntMgrProxy(), entity, this.core);
                } else {
                    rsp.setError(-20001);
                }
                rsp.setError(0);
            } else {
                rsp.setError(-20001);
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Exception while changing device ip for: " + (entity == null ? "n/a" : entity.toString()) + ". Code: " + seeTecException.getErrorCode() + ". Message: " + seeTecException.getMessage());
            rsp.setError(seeTecException.getErrorCode());
        }
        catch (Exception exception) {
            this.logger.error("Exception while changing device ip for: " + (entity == null ? "n/a" : entity.toString()) + ". Error: " + exception.getMessage());
            rsp.setError(-20001);
        }
        finally {
            rhc.onRequestHandled(req, rsp);
        }
    }

    private void execIsFirmareAvailable(SrpcMessage requestMessage, RequestHandlerCallback callback) {
        SrpcMessage responseMessage;
        try {
            ReqIsFirmwareAvailable request = ReqIsFirmwareAvailable.parseGObject(requestMessage.getPayload());
            boolean result = this.core.getFirmwareManager().isFirmwareAvailable(request.getFilename());
            RspIsFirmwareAvailable params = new RspIsFirmwareAvailable(result);
            responseMessage = SrpcMessage.createResponse((SrpcMessage)requestMessage, (GObject)params.createGObject());
        }
        catch (SeeTecException exception) {
            responseMessage = SrpcMessage.createResponse((SrpcMessage)requestMessage, null);
            responseMessage.setError(exception.getErrorCode());
        }
        callback.onRequestHandled(requestMessage, responseMessage);
    }

    private void execDeleteFirmware(SrpcMessage requestMessage, RequestHandlerCallback callback) {
        int error = 0;
        try {
            ReqDeleteFirmware request = ReqDeleteFirmware.parseGObject(requestMessage.getPayload());
            this.core.getFirmwareManager().deleteFirmware(request.getFilename());
        }
        catch (SeeTecException | IOException exception) {
            this.logger.error("Firmware delete failed. Exception " + exception.getClass().getName() + " occurred: " + exception.getMessage());
            error = -21702;
        }
        SrpcMessage responseMessage = SrpcMessage.createResponse((SrpcMessage)requestMessage, null);
        responseMessage.setError(error);
        callback.onRequestHandled(requestMessage, responseMessage);
    }

    private void execSendFirmware(SrpcMessage requestMessage, RequestHandlerCallback callback) {
        int error = 0;
        try {
            ReqSendFirmware request = ReqSendFirmware.parseGObject(requestMessage.getPayload());
            this.core.getFirmwareManager().sendFirmware(request.getFilename(), request.getFirmwareData());
        }
        catch (SeeTecException | IOException exception) {
            this.logger.error("Firmware send failed. Exception " + exception.getClass().getName() + " occurred: " + exception.getMessage());
            error = -21702;
        }
        SrpcMessage responseMessage = SrpcMessage.createResponse((SrpcMessage)requestMessage, null);
        responseMessage.setError(error);
        callback.onRequestHandled(requestMessage, responseMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execUpgradeDeviceFirmware(SrpcMessage req, RequestHandlerCallback rhc) {
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        try {
            ReqUpgradeDeviceFirmware request = ReqUpgradeDeviceFirmware.parseGObject(req.getPayload());
            String fileName = request.getFileName();
            FirmwareManager firmwareManager = this.core.getFirmwareManager();
            if (firmwareManager.isFirmwareAvailable(fileName)) {
                byte[] fileData = firmwareManager.readFirmware(fileName);
                Entity entity = this.core.getEntityByID(request.getEntityId());
                long manufacturer = entity.getEntityType() / 100L;
                if (manufacturer == 2000L || manufacturer == 2023L) {
                    AxisDevice.getCameraAdministration().upgradeDeviceFirmware(fileData, entity, this.core);
                } else if (manufacturer == 2017L) {
                    BoschDevice.getCameraAdministration().upgradeDeviceFirmware(fileData, entity, this.core);
                } else if (manufacturer == 2064L || manufacturer == 2018L) {
                    SamsungDevice.getCameraAdministration().upgradeDeviceFirmware(fileData, entity, this.core);
                } else if (HikvisionHelper.isHikvisionDevice(entity.getEntityType())) {
                    HikvisionDevice.getCameraAdministration().upgradeDeviceFirmware(fileData, entity, this.core);
                }
                rsp.setError(0);
            } else {
                rsp.setError(-20020);
            }
        }
        catch (SeeTecException | IOException exception) {
            this.logger.error("Firmware upgrade failed. Exception " + exception.getClass().getName() + " occurred: " + exception.getMessage());
            rsp.setError(-21702);
        }
        finally {
            rhc.onRequestHandled(req, rsp);
        }
    }

    private boolean doNetworkCheck(long type) {
        return type != 209770L && type != 206802L;
    }

    private int execCheckDeviceInfosManufacturerSpecific(long manufacturer, long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        int errorCode;
        String resolvedHost = new LteHostResolver(this.core.getLTESupportConfiguration()).resolve(host);
        if (manufacturer == 2000L || manufacturer == 2023L) {
            this.logger.info("CheckDeviceInfos Axis ...");
            errorCode = AxisDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2006L && type != 200657L) {
            this.logger.info("CheckDeviceInfos Sony ...");
            errorCode = SonyDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (type == 200550L) {
            this.logger.info("CheckDeviceInfos Panasonic ...");
            errorCode = Panasonic2Device.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2005L) {
            this.logger.info("CheckDeviceInfos Panasonic ...");
            errorCode = PanasonicDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2009L) {
            this.logger.info("CheckDeviceInfos Arecont Vision ...");
            errorCode = ArecontDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2013L) {
            this.logger.info("CheckDeviceInfos IQinVision ...");
            errorCode = IQinVisionDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (type == 206802L) {
            this.logger.info("CheckDeviceInfos Videofile import ...");
            errorCode = VideoFileDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2018L || manufacturer == 2064L || manufacturer == 2068L) {
            this.logger.info("CheckDeviceInfos Samsung/Hanwha ...");
            errorCode = SamsungDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2017L || type == 200657L) {
            this.logger.info("CheckDeviceInfos Bosch ...");
            errorCode = BoschDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2008L) {
            this.logger.info("CheckDeviceInfos Pelco ...");
            errorCode = PelcoDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2024L) {
            this.logger.info("CheckDeviceInfos VIVOTEK ...");
            errorCode = VivotekDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (manufacturer == 2010L) {
            this.logger.info("CheckDeviceInfos ACTi ...");
            errorCode = ActiDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (GenericOnvifHelper.isOnvifDevice(type)) {
            this.logger.info("CheckDeviceInfos ONVIF ...");
            errorCode = GenericOnvifDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else if (type == 209770L) {
            this.logger.info("CheckDeviceInfos JPEG emulator ...");
            errorCode = JPEGEmulatorDevice.checkDeviceInfos(type, resolvedHost, port, useAuthorization, user, pass, timeout);
        } else {
            this.logger.warn("CheckDeviceInfos unknown device ...");
            errorCode = -21696;
        }
        return errorCode;
    }

    private void execGetCameraRecordingStatistics(SrpcMessage request, RequestHandlerCallback callback) throws ConfigurationException, JDOMException, SAXException, JAXBException, SeeTecException {
        SrpcMessage rsp;
        int resultCode = 0;
        GObject requestFromClient = request.getPayload();
        Long granularity = requestFromClient.getAsLong();
        long duration = System.currentTimeMillis();
        RspGetCameraRecordingStatistics response = new RspGetCameraRecordingStatistics(Integer.valueOf(resultCode), "".getBytes());
        try {
            response = this.recordingStatistic.getCameraRecordingStatistics(response, granularity);
            rsp = SrpcMessage.createResponse((SrpcMessage)request, (GObject)response.createGObject());
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error while fetching cameraRecordingStatistics. Reason: " + seeTecException.getMessage());
            rsp = SrpcMessage.createResponse((SrpcMessage)request, null);
            rsp.setError(seeTecException.getErrorCode());
        }
        duration = System.currentTimeMillis() - duration;
        if (duration > TimeUnit.SECONDS.toMillis(5L)) {
            this.logger.info("Execution of " + request + " took " + duration + "ms.");
        }
        callback.onRequestHandled(request, rsp);
    }

    public String toString() {
        String sThis = ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", SRPCConnector=[" + (Object)((Object)this.deviceManagerSrpcConnector) + "]]";
    }
}

