/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.DeviceManagerSrpcHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.DefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;

public class DeviceManagerSrpcConnector
extends Basic
implements SrpcRequestHandlerIntf,
ShutdownCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.DeviceManagerSrpcConnector";
    private final DeviceManagerSrpcHandler deviceManagerSrpc;
    private final Socket socket;
    private SrpcClientIntf nSrpc = null;

    public DeviceManagerSrpcConnector(DeviceManagerSrpcHandler srpcHandler, Socket socket) throws SeeTecException {
        this.deviceManagerSrpc = srpcHandler;
        if (this.deviceManagerSrpc == null) {
            throw new SeeTecException(-21001, "srpcHandler null");
        }
        this.socket = socket;
        if (this.socket == null) {
            throw new SeeTecException(-21001, "socket null");
        }
        try {
            this.nSrpc = SrpcFactory.getSrpc((Socket)this.socket, (SrpcRequestHandlerFactoryIntf)new DefaultRequestHandlerFactoryImpl((SrpcRequestHandlerIntf)this.deviceManagerSrpc), null, (ShutdownCallback)this, (boolean)false);
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20210, String.format("Cannot get SRPC for %s, %s", new Object[]{this.socket, this.deviceManagerSrpc}), ex);
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.nSrpc != null) {
            this.nSrpc.shutdown();
            this.nSrpc = null;
        }
        this.deviceManagerSrpc.shutdown();
        return 0;
    }

    public void handleRequest(SrpcMessage sm, RequestHandlerCallback rhc) {
        this.deviceManagerSrpc.handleRequest(sm, rhc);
    }

    public void onShutdown() {
        this.shutdown();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.DeviceManagerSrpcConnector@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.socket + "], SRPC=" + this.nSrpc + "]";
    }
}

