/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProviderListener;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.shared.RECnfMgr;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.configuration.database.DMConfigurationOnDatabase;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.AbstractMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ConfigurationProvider {
    private final Logger logger;
    private final AbstractMap<ConfigurationProviderListener, Long> listener = new ConcurrentHashMap<ConfigurationProviderListener, Long>();
    private RECnfMgr dmCnfMgr = null;
    private RECnfMgr mdsCnfMgr = null;
    private DMConfigurationOnDatabase dmConfigurationOnDatabase = null;
    private Core core = null;

    public ConfigurationProvider() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(String dmConfFile, String mdsConfFile, Core core) throws InterruptedException, ConfigurationException {
        RECnfMgr tempMdsCnfMgr;
        this.dmCnfMgr = new RECnfMgr();
        int errorCode = this.dmCnfMgr.init(dmConfFile, 60008);
        if (errorCode != 0) {
            this.logger.error("Initializing of " + this.dmCnfMgr + " failed with error [" + errorCode + "] :-(");
            return -21018;
        }
        this.mdsCnfMgr = null;
        while (true) {
            if ((errorCode = (tempMdsCnfMgr = new RECnfMgr()).init(mdsConfFile, 60006)) != 0) {
                this.logger.error("Initializing of " + this.mdsCnfMgr + " failed with error [" + errorCode + "]");
                return -21018;
            }
            if (tempMdsCnfMgr.getEntityID() > 0L) break;
            this.logger.info("No valid MDS ID in conf file found. Try again!");
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        }
        this.mdsCnfMgr = tempMdsCnfMgr;
        this.core = core;
        return 0;
    }

    public void register(ConfigurationProviderListener listener) throws SeeTecException {
        this.checkListener();
        this.listener.put(listener, System.currentTimeMillis());
    }

    public void deregister(ConfigurationProviderListener listener) throws SeeTecException {
        this.checkListener();
        this.listener.remove(listener);
    }

    public RECnfMgr getDMConfigurationFromFile() {
        return this.dmCnfMgr;
    }

    public DMConfigurationOnDatabase getDMConfigurationFromDatabase() throws SeeTecException {
        if (this.dmConfigurationOnDatabase == null) {
            this.getDMConfigurationFromCoreservice();
        }
        return this.dmConfigurationOnDatabase;
    }

    public RECnfMgr getMDSConfigurationFromFile() {
        return this.mdsCnfMgr;
    }

    public void notify(ReqNotify request) throws SeeTecException {
        try {
            if (request.getSourceID().longValue() == this.dmCnfMgr.getEntityID()) {
                this.getDMConfigurationFromCoreservice();
            }
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-20000, "Can read my own ID.");
        }
        this.listener.keySet().stream().forEach(listenerToBeNotified -> listenerToBeNotified.configurationFromDatabaseChanged(request.getSourceID()));
    }

    private void getDMConfigurationFromCoreservice() throws SeeTecException {
        try {
            Entity entity = this.core.getEntMgrProxy().getEntityByID(Long.valueOf(this.dmCnfMgr.getEntityID()), Boolean.valueOf(true), 30000L);
            this.dmConfigurationOnDatabase = (DMConfigurationOnDatabase)Basic.unmarshalXML(DMConfigurationOnDatabase.class, (Object)entity.getConfiguration());
        }
        catch (NullPointerException npe) {
            this.logger.warn("Unable to fetch new configuration from core service [EntMgrProxy is null]");
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-20000, "Can read my own ID.");
        }
        catch (JAXBException | SAXException ex) {
            throw new SeeTecException(-20000, "Can read my own configuration from database.");
        }
    }

    private void checkListener() throws SeeTecException {
        if (this.listener == null) {
            throw new SeeTecException(-20002, "Null argument");
        }
    }
}

