/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.RecordingStatistic;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.configuration.camerarecordingstatistic.CameraRecordingStatistic;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CameraStatisticsPublisher
implements Runnable {
    private static final int DEFAULT_CYCLE = 1;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.DAYS;
    private final Logger logger;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("CameraStatisticsPublisher"));
    private final RecordingStatistic recordingStatistic;
    private final SystemTimeProvider systemTimeProvider;
    private final ConfigurationProvider configurationProvider;
    private final Core core;

    public CameraStatisticsPublisher(RecordingStatistic recordingStatistic, ConfigurationProvider configurationProvider, Core core) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.systemTimeProvider = new DefaultSystemTimeProvider();
        this.recordingStatistic = recordingStatistic;
        this.configurationProvider = configurationProvider;
        this.core = core;
        this.scheduler.scheduleWithFixedDelay(this, 1L, 1L, DEFAULT_UNIT);
    }

    @Override
    public void run() {
        try {
            RspGetCameraRecordingStatistics response = new RspGetCameraRecordingStatistics(Integer.valueOf(0), "".getBytes());
            this.recordingStatistic.getCameraRecordingStatistics(response, this.systemTimeProvider.currentTimeMillis());
            CameraRecordingStatistic cameraRecordingStatistic = (CameraRecordingStatistic)Basic.unmarshalXML(CameraRecordingStatistic.class, (Object)response.getCameraRecordingStatistics());
            this.core.sendEvent(EventType.CM_EVENTTYPE_CAMERA_RECORDING_STATISTICS, this.configurationProvider.getDMConfigurationFromFile().getEntityID(), -1L, Basic.marshalUTF8XML((Object)cameraRecordingStatistic).getBytes());
        }
        catch (Exception exception) {
            this.logger.error("Can't send daily camera recording statistics event: Message: " + exception.getMessage());
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }
}

