/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.xml;

import de.seetec.v5.shared.util.SeeTecException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DocumentWriter {
    public static String toString(Document document) throws SeeTecException {
        if (document == null) {
            throw new SeeTecException(-20002, "Given document null.");
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString().trim();
        }
        catch (IllegalArgumentException | NullPointerException | TransformerException exception) {
            throw new SeeTecException(0, "Exception writing document to string. Reason: " + exception.getMessage());
        }
    }
}

