/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.util.TimeAndOccurence;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class AccumulatingLogger {
    private final Map<String, TimeAndOccurence> logMessages;
    private final Logger logger;

    public AccumulatingLogger(Logger logger, final int maxEntries) {
        if (logger == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.logger = logger;
        this.logMessages = new LinkedHashMap<String, TimeAndOccurence>(){
            private static final long serialVersionUID = 8300976593414373625L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TimeAndOccurence> eldest) {
                return this.size() > maxEntries;
            }
        };
    }

    public void log(Level logLevel, long deadtimeInMs, String uniqueMessage) {
        if (logLevel == null || uniqueMessage == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        if (!this.alreadyLogged(uniqueMessage, deadtimeInMs)) {
            TimeAndOccurence timeAndOccurence = this.logMessages.get(uniqueMessage);
            String logMessage = this.buildLogString(uniqueMessage, timeAndOccurence);
            this.logger.log(logLevel, logMessage);
            timeAndOccurence.resetTimeAndOccurence();
        }
    }

    private boolean alreadyLogged(String uniqueMessage, long duration) {
        boolean alreadyLogged;
        if (this.logMessages.containsKey(uniqueMessage)) {
            TimeAndOccurence timeAndOccurence = this.logMessages.get(uniqueMessage);
            if (System.currentTimeMillis() - timeAndOccurence.getTime() > duration) {
                alreadyLogged = false;
            } else {
                timeAndOccurence.addOccurence();
                alreadyLogged = true;
            }
        } else {
            this.logMessages.put(uniqueMessage, new TimeAndOccurence());
            alreadyLogged = false;
        }
        return alreadyLogged;
    }

    private String buildLogString(String uniqueMessage, TimeAndOccurence timeAndOccurence) {
        StringBuilder logMessage = new StringBuilder(uniqueMessage);
        logMessage.append(" [");
        logMessage.append(timeAndOccurence.getOccurence());
        logMessage.append(" time(s) since ");
        logMessage.append(new Date(timeAndOccurence.getTime()));
        logMessage.append("]");
        return logMessage.toString();
    }
}

